/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.rewrite.util;

import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.internal.core.resources.ResourceLookup;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.TextUtilities;

public class FileHelper {
    private static final String DEFAULT_LINE_DELIMITTER = "\n";

    public static IFile getFileFromNode(IASTNode node) {
        Path implPath = new Path(node.getContainingFilename());
        return ResourceLookup.selectFileForLocation(implPath, null);
    }

    public static String determineLineDelimiter(String text) {
        String platformDefaultLineDelimiter = System.getProperty("line.separator", DEFAULT_LINE_DELIMITTER);
        String defaultLineDelimiter = Platform.getPreferencesService().getString("org.eclipse.core.runtime", "line.separator", platformDefaultLineDelimiter, null);
        if (text.isEmpty()) {
            return defaultLineDelimiter;
        }
        return TextUtilities.determineLineDelimiter((String)text, (String)defaultLineDelimiter);
    }
}

