/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTAttribute;
import org.eclipse.cdt.core.dom.ast.IASTAttributeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameterPackType;
import org.eclipse.cdt.internal.core.dom.parser.ASTAmbiguousNode;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguousParameterDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.core.runtime.Assert;

public class CPPASTAmbiguousParameterDeclaration
extends ASTAmbiguousNode
implements IASTAmbiguousParameterDeclaration,
ICPPASTParameterDeclaration {
    private ICPPASTParameterDeclaration fParameterDecl;

    public CPPASTAmbiguousParameterDeclaration(ICPPASTParameterDeclaration decl) {
        this.fParameterDecl = decl;
    }

    @Override
    public void addParameterDeclaration(IASTParameterDeclaration d) {
        assert (false);
    }

    @Override
    protected final IASTNode doResolveAmbiguity(ASTVisitor resolver) {
        IASTAmbiguityParent owner = (IASTAmbiguityParent)((Object)this.getParent());
        owner.replace(this, this.fParameterDecl);
        this.fParameterDecl.accept(resolver);
        IType t = CPPVisitor.createType(this.fParameterDecl, true);
        if (!(t instanceof ICPPParameterPackType) || !CPPTemplates.containsParameterPack(((ICPPParameterPackType)t).getType())) {
            ICPPASTDeclarator dtor = this.fParameterDecl.getDeclarator();
            dtor.setDeclaresParameterPack(false);
            this.adjustOffsets(dtor);
            ((ICPPASTFunctionDeclarator)this.fParameterDecl.getParent()).setVarArgs(true);
        }
        return this.fParameterDecl;
    }

    private void adjustOffsets(ICPPASTDeclarator dtor) {
        IASTPointerOperator[] ptrOps = dtor.getPointerOperators();
        ASTNode asNode = (ASTNode)((Object)dtor);
        if (ptrOps.length > 0) {
            ASTNode first = (ASTNode)((Object)ptrOps[0]);
            ASTNode last = (ASTNode)((Object)ptrOps[ptrOps.length - 1]);
            asNode.setOffsetAndLength(first.getOffset(), last.getOffset() + last.getLength());
        } else {
            asNode.setOffsetAndLength(0, 0);
        }
    }

    @Override
    public IASTParameterDeclaration[] getParameterDeclarations() {
        return new IASTParameterDeclaration[]{this.fParameterDecl};
    }

    @Override
    public IASTNode[] getNodes() {
        return this.getParameterDeclarations();
    }

    @Override
    public IASTDeclSpecifier getDeclSpecifier() {
        return this.fParameterDecl.getDeclSpecifier();
    }

    @Override
    public ICPPASTDeclarator getDeclarator() {
        return this.fParameterDecl.getDeclarator();
    }

    @Override
    public void setDeclSpecifier(IASTDeclSpecifier declSpec) {
        Assert.isLegal(false);
    }

    @Override
    public void setDeclarator(IASTDeclarator declarator) {
        Assert.isLegal(false);
    }

    @Override
    public ICPPASTParameterDeclaration copy() {
        Assert.isLegal(false);
        return null;
    }

    @Override
    public ICPPASTParameterDeclaration copy(IASTNode.CopyStyle style) {
        Assert.isLegal(false);
        return null;
    }

    @Override
    public boolean isParameterPack() {
        Assert.isLegal(false);
        return true;
    }

    @Override
    public IASTAttributeSpecifier[] getAttributeSpecifiers() {
        return this.fParameterDecl.getAttributeSpecifiers();
    }

    @Override
    public void addAttributeSpecifier(IASTAttributeSpecifier attributeSpecifier) {
        this.fParameterDecl.addAttributeSpecifier(attributeSpecifier);
    }

    @Override
    public IASTAttribute[] getAttributes() {
        return this.fParameterDecl.getAttributes();
    }

    @Override
    @Deprecated
    public void addAttribute(IASTAttribute attribute) {
        this.fParameterDecl.addAttribute(attribute);
    }
}

