/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.EScopeKind;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTAttributeOwner;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.c.CScope;

public class CASTCompoundStatement
extends ASTAttributeOwner
implements IASTCompoundStatement,
IASTAmbiguityParent {
    private IASTStatement[] statements;
    private IScope scope;

    @Override
    public CASTCompoundStatement copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CASTCompoundStatement copy(IASTNode.CopyStyle style) {
        CASTCompoundStatement copy = new CASTCompoundStatement();
        IASTStatement[] iASTStatementArray = this.getStatements();
        int n = iASTStatementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTStatement statement = iASTStatementArray[n2];
            copy.addStatement(statement == null ? null : statement.copy(style));
            ++n2;
        }
        return this.copy(copy, style);
    }

    @Override
    public IASTStatement[] getStatements() {
        if (this.statements == null) {
            return IASTStatement.EMPTY_STATEMENT_ARRAY;
        }
        return ArrayUtil.trim(IASTStatement.class, this.statements);
    }

    @Override
    public void addStatement(IASTStatement statement) {
        this.assertNotFrozen();
        this.statements = ArrayUtil.append(IASTStatement.class, this.statements, statement);
        if (statement != null) {
            statement.setParent(this);
            statement.setPropertyInParent(NESTED_STATEMENT);
        }
    }

    @Override
    public IScope getScope() {
        if (this.scope == null) {
            this.scope = new CScope(this, EScopeKind.eLocal);
        }
        return this.scope;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitStatements) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (!this.acceptByAttributeSpecifiers(action)) {
            return false;
        }
        IASTStatement[] s2 = this.getStatements();
        int i = 0;
        while (i < s2.length) {
            if (!s2[i].accept(action)) {
                return false;
            }
            ++i;
        }
        if (action.shouldVisitStatements) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (this.statements == null) {
            return;
        }
        int i = 0;
        while (i < this.statements.length) {
            if (this.statements[i] == child) {
                other.setParent(this.statements[i].getParent());
                other.setPropertyInParent(this.statements[i].getPropertyInParent());
                this.statements[i] = (IASTStatement)other;
                break;
            }
            ++i;
        }
    }
}

