/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICommandLauncher;
import org.eclipse.cdt.internal.core.Cygwin;
import org.eclipse.cdt.internal.core.Messages;
import org.eclipse.cdt.internal.core.ProcessClosure;
import org.eclipse.cdt.utils.PathUtil;
import org.eclipse.cdt.utils.spawner.EnvironmentReader;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;

public class CommandLauncher
implements ICommandLauncher {
    public static final int COMMAND_CANCELED = 1;
    public static final int ILLEGAL_COMMAND = -1;
    public static final int OK = 0;
    private static final String PATH_ENV = "PATH";
    private static final String NEWLINE = System.getProperty("line.separator", "\n");
    protected Process fProcess = null;
    protected boolean fShowCommand = false;
    protected String[] fCommandArgs;
    private Properties fEnvironment = null;
    protected String fErrorMessage = "";
    private IProject fProject;
    protected static final long DELAY = 50L;

    @Override
    public void showCommand(boolean show) {
        this.fShowCommand = show;
    }

    @Override
    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    @Override
    public void setErrorMessage(String error) {
        this.fErrorMessage = error;
    }

    @Override
    public String[] getCommandArgs() {
        return this.fCommandArgs;
    }

    @Override
    public Properties getEnvironment() {
        if (this.fEnvironment == null) {
            return EnvironmentReader.getEnvVars();
        }
        return this.fEnvironment;
    }

    private String getEnvironmentProperty(String key) {
        if (this.fEnvironment == null) {
            return EnvironmentReader.getEnvVar((String)key);
        }
        return this.fEnvironment.getProperty(key);
    }

    @Override
    public String getCommandLine() {
        return this.getCommandLine(this.getCommandArgs());
    }

    protected String[] constructCommandArray(String command, String[] commandArgs) {
        String[] args = new String[1 + commandArgs.length];
        args[0] = command;
        System.arraycopy(commandArgs, 0, args, 1, commandArgs.length);
        return args;
    }

    private void parseEnvironment(String[] env) {
        this.fEnvironment = null;
        if (env != null) {
            this.fEnvironment = new Properties();
            String[] stringArray = env;
            int n = env.length;
            int n2 = 0;
            while (n2 < n) {
                String envStr = stringArray[n2];
                int pos = envStr.indexOf(61);
                if (pos < 0) {
                    pos = envStr.length();
                }
                String key = envStr.substring(0, pos);
                if (Platform.getOS().equals("win32")) {
                    key = key.toUpperCase();
                }
                String value = envStr.substring(pos + 1);
                this.fEnvironment.put(key, value);
                ++n2;
            }
        }
    }

    @Deprecated
    public Process execute(IPath commandPath, String[] args, String[] env, IPath changeToDirectory) {
        try {
            return this.execute(commandPath, args, env, changeToDirectory, null);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    @Override
    public Process execute(IPath commandPath, String[] args, String[] env, IPath workingDirectory, IProgressMonitor monitor) throws CoreException {
        File dir;
        this.parseEnvironment(env);
        String envPathValue = this.getEnvironmentProperty(PATH_ENV);
        Boolean isFound = null;
        String command = commandPath.toOSString();
        this.fCommandArgs = this.constructCommandArray(command, args);
        if (Platform.getOS().equals("win32")) {
            IPath location = PathUtil.findProgramLocation(command, envPathValue);
            isFound = location != null;
            if (location != null) {
                try {
                    this.fCommandArgs[0] = Cygwin.cygwinToWindowsPath(location.toString(), envPathValue);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        File file = dir = workingDirectory != null ? workingDirectory.toFile() : null;
        if (dir != null && !dir.isDirectory()) {
            CCorePlugin.logStackTrace(4, NLS.bind(Messages.CommandLauncher_InvalidWorkingDirectory, dir));
            dir = null;
        }
        try {
            this.fProcess = ProcessFactory.getFactory().exec(this.fCommandArgs, env, dir);
            this.fCommandArgs[0] = command;
            this.fErrorMessage = "";
        }
        catch (IOException e) {
            CCorePlugin.log(e);
            if (isFound == null) {
                IPath location = PathUtil.findProgramLocation(command, envPathValue);
                isFound = location != null;
            }
            String errorMessage = this.getCommandLineQuoted(this.fCommandArgs, true);
            String exMsg = e.getMessage();
            if (exMsg != null && !exMsg.isEmpty()) {
                errorMessage = String.valueOf(errorMessage) + exMsg + NEWLINE;
            }
            if (!isFound.booleanValue()) {
                if (envPathValue == null) {
                    envPathValue = System.getenv(PATH_ENV);
                }
                errorMessage = String.valueOf(errorMessage) + NEWLINE + NLS.bind(Messages.CommandLauncher_ProgramNotFoundInPath, command) + NEWLINE + "PATH=[" + envPathValue + "]" + NEWLINE;
            }
            this.setErrorMessage(errorMessage);
            this.fProcess = null;
        }
        return this.fProcess;
    }

    @Override
    @Deprecated
    public int waitAndRead(OutputStream out, OutputStream err) {
        if (this.fShowCommand) {
            this.printCommandLine(out);
        }
        if (this.fProcess == null) {
            return -1;
        }
        ProcessClosure closure = new ProcessClosure(this.fProcess, out, err);
        closure.runBlocking();
        return 0;
    }

    @Override
    public int waitAndRead(OutputStream output, OutputStream err, IProgressMonitor monitor) {
        if (this.fShowCommand) {
            this.printCommandLine(output);
        }
        if (this.fProcess == null) {
            return -1;
        }
        ProcessClosure closure = new ProcessClosure(this.fProcess, output, err);
        closure.runNonBlocking();
        while (!monitor.isCanceled() && closure.isAlive()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        int state = 0;
        if (monitor.isCanceled()) {
            closure.terminate();
            state = 1;
            this.setErrorMessage(Messages.CommandLauncher_CommandCancelled);
        }
        try {
            this.fProcess.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return state;
    }

    protected void printCommandLine(OutputStream os) {
        if (os != null) {
            try {
                os.write(this.getCommandLineQuoted(this.getCommandArgs(), true).getBytes());
                os.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private String getCommandLineQuoted(String[] commandArgs, boolean quote) {
        StringBuilder buf = new StringBuilder();
        if (commandArgs != null) {
            String[] stringArray = commandArgs;
            int n = commandArgs.length;
            int n2 = 0;
            while (n2 < n) {
                String commandArg = stringArray[n2];
                if (quote && (commandArg.contains(" ") || commandArg.contains("\"") || commandArg.contains("\\"))) {
                    commandArg = String.valueOf('\"') + commandArg.replaceAll("\\\\", "\\\\\\\\").replaceAll("\"", "\\\\\"") + '\"';
                }
                buf.append(commandArg);
                buf.append(' ');
                ++n2;
            }
            buf.append(NEWLINE);
        }
        return buf.toString();
    }

    protected String getCommandLine(String[] commandArgs) {
        return this.getCommandLineQuoted(commandArgs, false);
    }

    @Override
    public IProject getProject() {
        return this.fProject;
    }

    @Override
    public void setProject(IProject project) {
        this.fProject = project;
    }
}

