/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.processing.strategy;

import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Strategy {
    private Strategy() {
    }

    public static @NonNull Iterator<Node> NO_STRATEGY(@NonNull Node x) {
        return Collections.emptyIterator();
    }

    public static @NonNull Iterator<Node> EOG_FORWARD(@NonNull Node x) {
        return x.getNextEOG().iterator();
    }

    public static @NonNull Iterator<Node> EOG_BACKWARD(@NonNull Node x) {
        return x.getPrevEOG().iterator();
    }

    public static @NonNull Iterator<Node> DFG_FORWARD(@NonNull Node x) {
        return x.getNextDFG().iterator();
    }

    public static @NonNull Iterator<Node> DFG_BACKWARD(@NonNull Node x) {
        return x.getPrevDFG().iterator();
    }

    public static @NonNull Iterator<Node> AST_FORWARD(@NonNull Node x) {
        HashSet<Node> children = new HashSet<Node>();
        Class<?> classType = x.getClass();
        for (Field field : Strategy.getAllFields(classType)) {
            SubGraph subGraph = field.getAnnotation(SubGraph.class);
            if (subGraph == null || !Arrays.asList(subGraph.value()).contains("AST")) continue;
            try {
                field.setAccessible(true);
                Object obj = field.get(x);
                field.setAccessible(false);
                if (obj == null) continue;
                if (obj instanceof Node) {
                    children.add((Node)obj);
                    continue;
                }
                if (!(obj instanceof Collection)) continue;
                Collection astChildren = (Collection)obj;
                astChildren.removeIf(Objects::isNull);
                children.addAll(astChildren);
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        return children.iterator();
    }

    private static Collection<Field> getAllFields(Class<?> classType) {
        if (classType.getSuperclass() != null) {
            Collection<Field> fields = Strategy.getAllFields(classType.getSuperclass());
            fields.addAll(Arrays.asList(classType.getDeclaredFields()));
            return fields;
        }
        return new ArrayList<Field>();
    }
}

