/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes.scopes;

import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.AssertStatement;
import de.fraunhofer.aisec.cpg.graph.BreakStatement;
import de.fraunhofer.aisec.cpg.graph.CatchClause;
import de.fraunhofer.aisec.cpg.graph.CompoundStatement;
import de.fraunhofer.aisec.cpg.graph.ConstructorDeclaration;
import de.fraunhofer.aisec.cpg.graph.ContinueStatement;
import de.fraunhofer.aisec.cpg.graph.Declaration;
import de.fraunhofer.aisec.cpg.graph.DeclaredReferenceExpression;
import de.fraunhofer.aisec.cpg.graph.DoStatement;
import de.fraunhofer.aisec.cpg.graph.FieldDeclaration;
import de.fraunhofer.aisec.cpg.graph.ForEachStatement;
import de.fraunhofer.aisec.cpg.graph.ForStatement;
import de.fraunhofer.aisec.cpg.graph.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.IfStatement;
import de.fraunhofer.aisec.cpg.graph.LabelStatement;
import de.fraunhofer.aisec.cpg.graph.MethodDeclaration;
import de.fraunhofer.aisec.cpg.graph.NamespaceDeclaration;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.ParamVariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.Statement;
import de.fraunhofer.aisec.cpg.graph.SwitchStatement;
import de.fraunhofer.aisec.cpg.graph.TryStatement;
import de.fraunhofer.aisec.cpg.graph.TypedefDeclaration;
import de.fraunhofer.aisec.cpg.graph.ValueDeclaration;
import de.fraunhofer.aisec.cpg.graph.VariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.WhileStatement;
import de.fraunhofer.aisec.cpg.passes.scopes.BlockScope;
import de.fraunhofer.aisec.cpg.passes.scopes.DeclarationScope;
import de.fraunhofer.aisec.cpg.passes.scopes.FunctionScope;
import de.fraunhofer.aisec.cpg.passes.scopes.GlobalScope;
import de.fraunhofer.aisec.cpg.passes.scopes.IBreakable;
import de.fraunhofer.aisec.cpg.passes.scopes.IContinuable;
import de.fraunhofer.aisec.cpg.passes.scopes.LoopScope;
import de.fraunhofer.aisec.cpg.passes.scopes.NameScope;
import de.fraunhofer.aisec.cpg.passes.scopes.RecordScope;
import de.fraunhofer.aisec.cpg.passes.scopes.Scope;
import de.fraunhofer.aisec.cpg.passes.scopes.SwitchScope;
import de.fraunhofer.aisec.cpg.passes.scopes.TryScope;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScopeManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScopeManager.class);
    private final Map<Node, Scope> scopeMap = new HashMap<Node, Scope>();
    private Scope currentScope = null;
    private LanguageFrontend lang;

    public ScopeManager() {
        this.pushScope(new GlobalScope());
    }

    public LanguageFrontend getLang() {
        return this.lang;
    }

    public void setLang(LanguageFrontend lang) {
        this.lang = lang;
    }

    private void pushScope(Scope scope) {
        if (this.scopeMap.containsKey(scope.astNode)) {
            LOGGER.error("Node cannot be scoped twice. A node at most one associated scope apart from the parent scopes.");
            return;
        }
        this.scopeMap.put(scope.astNode, scope);
        if (this.currentScope != null) {
            this.currentScope.getChildren().add(scope);
            scope.setParent(this.currentScope);
        }
        this.currentScope = scope;
    }

    public boolean isInBlock() {
        return this.getFirstScopeThat(scope -> scope instanceof BlockScope) != null;
    }

    public boolean isInFunction() {
        return this.getFirstScopeThat(scope -> scope instanceof FunctionScope) != null;
    }

    public boolean isInRecord() {
        return this.getFirstScopeThat(scope -> scope instanceof RecordScope) != null;
    }

    public @Nullable CompoundStatement getCurrentBlock() {
        Scope blockScope = this.getFirstScopeThat(scope -> scope instanceof BlockScope);
        if (blockScope == null) {
            LOGGER.error("Cannot get current block. No scope.");
            return null;
        }
        Node node = blockScope.getAstNode();
        if (!(node instanceof CompoundStatement)) {
            LOGGER.error("Cannot get current block. No AST node {}", (Object)blockScope.toString());
            return null;
        }
        return (CompoundStatement)node;
    }

    public @Nullable FunctionDeclaration getCurrentFunction() {
        Scope functionScope = this.getFirstScopeThat(scope -> scope instanceof FunctionScope);
        if (functionScope == null) {
            LOGGER.error("Cannot get current function. No scope.");
            return null;
        }
        Node node = functionScope.getAstNode();
        if (!(node instanceof FunctionDeclaration)) {
            LOGGER.error("Cannot get current function. No AST node {}", (Object)functionScope.toString());
            return null;
        }
        return (FunctionDeclaration)node;
    }

    public @Nullable RecordDeclaration getCurrentRecord() {
        Scope recordScope = this.getFirstScopeThat(scope -> scope instanceof RecordScope);
        if (recordScope == null) {
            LOGGER.error("Cannot get current function. No scope.");
            return null;
        }
        Node node = recordScope.getAstNode();
        if (!(node instanceof RecordDeclaration)) {
            LOGGER.error("Cannot get current function. No AST node {}", (Object)recordScope.toString());
            return null;
        }
        return (RecordDeclaration)node;
    }

    public List<ValueDeclaration> getGlobals() {
        GlobalScope globalS = (GlobalScope)this.getFirstScopeThat(scope -> scope instanceof GlobalScope);
        if (globalS != null) {
            return globalS.getValueDeclarations();
        }
        return new ArrayList<ValueDeclaration>();
    }

    public Scope getCurrentScope() {
        return this.currentScope;
    }

    public void addGlobal(VariableDeclaration global) {
        this.getGlobals().add(global);
    }

    public void enterScopeIfExists(Node nodeToScope) {
        if (this.scopeMap.containsKey(nodeToScope)) {
            this.currentScope = this.scopeMap.get(nodeToScope);
        }
    }

    public @Nullable Scope leaveScopeIfExists(Node nodeToLeave) {
        Scope leaveScope = this.scopeMap.getOrDefault(nodeToLeave, null);
        if (leaveScope != null) {
            this.currentScope = leaveScope.parent;
        }
        return leaveScope;
    }

    public void enterScope(Node nodeToScope) {
        if (!this.scopeMap.containsKey(nodeToScope)) {
            Scope newScope;
            if (nodeToScope instanceof CompoundStatement) {
                newScope = new BlockScope((CompoundStatement)nodeToScope);
            } else if (nodeToScope instanceof WhileStatement || nodeToScope instanceof DoStatement) {
                newScope = new LoopScope((Statement)nodeToScope);
            } else if (nodeToScope instanceof ForStatement || nodeToScope instanceof ForEachStatement) {
                newScope = new LoopScope((Statement)nodeToScope);
            } else if (nodeToScope instanceof SwitchStatement) {
                newScope = new SwitchScope((SwitchStatement)nodeToScope);
            } else if (nodeToScope instanceof AssertStatement) {
                newScope = new DeclarationScope(nodeToScope);
            } else if (nodeToScope instanceof FunctionDeclaration) {
                newScope = new FunctionScope((FunctionDeclaration)nodeToScope);
            } else if (nodeToScope instanceof IfStatement) {
                newScope = new DeclarationScope(nodeToScope);
            } else if (nodeToScope instanceof CatchClause) {
                newScope = new DeclarationScope(nodeToScope);
            } else if (nodeToScope instanceof RecordDeclaration) {
                newScope = new RecordScope(nodeToScope);
            } else if (nodeToScope instanceof TryStatement) {
                newScope = new TryScope(nodeToScope);
            } else if (nodeToScope instanceof NamespaceDeclaration) {
                newScope = new NameScope(nodeToScope, this.getCurrentNamePrefix(), this.lang.getNamespaceDelimiter());
            } else {
                LOGGER.error("No known scope for AST-nodes of type {}", (Object)nodeToScope.getClass());
                return;
            }
            this.pushScope(newScope);
        }
        this.currentScope = this.scopeMap.get(nodeToScope);
    }

    public boolean isBreakable(Scope scope) {
        return scope instanceof LoopScope || scope instanceof SwitchScope;
    }

    public boolean isContinuable(Scope scope) {
        return scope instanceof LoopScope;
    }

    public @Nullable Scope leaveScope(@NonNull Node nodeToLeave) {
        if (!this.scopeMap.containsKey(nodeToLeave)) {
            return null;
        }
        Scope leaveScope = this.getFirstScopeThat(scope -> Objects.equals(scope.astNode, nodeToLeave));
        if (leaveScope == null) {
            if (this.scopeMap.containsKey(nodeToLeave)) {
                LOGGER.error("Node of type {} has a scope but is not active in the moment.", (Object)nodeToLeave.getClass());
            } else {
                LOGGER.error("Node of type {} is not associated with a scope.", (Object)nodeToLeave.getClass());
            }
            return null;
        }
        this.currentScope = leaveScope.parent;
        return leaveScope;
    }

    public @Nullable Scope getFirstScopeThat(Predicate<Scope> predicate) {
        return this.getFirstScopeThat(this.currentScope, predicate);
    }

    public @Nullable Scope getFirstScopeThat(Scope searchScope, Predicate<Scope> predicate) {
        while (searchScope != null) {
            if (predicate.test(searchScope)) {
                return searchScope;
            }
            searchScope = searchScope.parent;
        }
        return null;
    }

    public List<Scope> getScopesThat(Predicate<Scope> predicate) {
        ArrayList<Scope> scopes = new ArrayList<Scope>();
        for (Scope scope : this.scopeMap.values()) {
            if (!predicate.test(scope)) continue;
            scopes.add(scope);
        }
        return scopes;
    }

    public <T> List<Scope> getUniqueScopesThat(Predicate<Scope> predicate, Function<Scope, T> uniqueProperty) {
        ArrayList<Scope> scopes = new ArrayList<Scope>();
        HashSet<T> seen = new HashSet<T>();
        for (Scope scope : this.scopeMap.values()) {
            if (!predicate.test(scope) || !seen.add(uniqueProperty.apply(scope))) continue;
            scopes.add(scope);
        }
        return scopes;
    }

    public void addBreakStatement(BreakStatement breakStatement) {
        if (breakStatement.getLabel() == null) {
            Scope scope = this.getFirstScopeThat(this::isBreakable);
            if (scope == null) {
                LOGGER.error("Break inside of unbreakable scope. The break will be ignored, but may lead to an incorrect graph. The source code is not valid or incomplete.");
                return;
            }
            ((IBreakable)((Object)scope)).addBreakStatement(breakStatement);
        } else {
            LabelStatement labelStatement = this.getLabelStatement(breakStatement.getLabel());
            if (labelStatement != null) {
                Scope scope = this.getScopeOfStatment(labelStatement.getSubStatement());
                ((IBreakable)((Object)scope)).addBreakStatement(breakStatement);
            }
        }
    }

    public void addContinueStatement(ContinueStatement continueStatement) {
        if (continueStatement.getLabel() == null) {
            Scope scope = this.getFirstScopeThat(this::isContinuable);
            if (scope == null) {
                LOGGER.error("Continue inside of not continuable scope. The continue will be ignored, but may lead to an incorrect graph. The source code is not valid or incomplete.");
                return;
            }
            ((IContinuable)((Object)scope)).addContinueStatement(continueStatement);
        } else {
            LabelStatement labelStatement = this.getLabelStatement(continueStatement.getLabel());
            if (labelStatement != null) {
                Scope scope = this.getScopeOfStatment(labelStatement.getSubStatement());
                ((IContinuable)((Object)scope)).addContinueStatement(continueStatement);
            }
        }
    }

    public void addLabelStatement(LabelStatement labelStatement) {
        this.currentScope.addLabelStatement(labelStatement);
    }

    public @Nullable LabelStatement getLabelStatement(String labelString) {
        Scope searchScope = this.currentScope;
        while (searchScope != null) {
            LabelStatement labelStatement = searchScope.getLabelStatements().getOrDefault(labelString, null);
            if (labelStatement != null) {
                return labelStatement;
            }
            searchScope = searchScope.parent;
        }
        return null;
    }

    public void addValueDeclaration(VariableDeclaration variableDeclaration) {
        DeclarationScope dScope = (DeclarationScope)this.getFirstScopeThat(scope -> scope instanceof DeclarationScope);
        if (dScope == null) {
            LOGGER.error("Cannot add VariableDeclaration. Not in declaration scope.");
            return;
        }
        dScope.addValueDeclaration(variableDeclaration);
        if (dScope.astNode instanceof Statement) {
            ((Statement)dScope.astNode).getLocals().add(variableDeclaration);
        }
    }

    public void addValueDeclaration(ParamVariableDeclaration paramDeclaration) {
        FunctionScope fScope = (FunctionScope)this.getFirstScopeThat(scope -> scope instanceof FunctionScope);
        if (fScope == null) {
            LOGGER.error("Cannot add ParamVariableDeclaration. Not in function scope.");
            return;
        }
        fScope.addValueDeclaration(paramDeclaration);
        List<ParamVariableDeclaration> params = ((FunctionDeclaration)fScope.getAstNode()).getParameters();
        if (!params.contains(paramDeclaration)) {
            params.add(paramDeclaration);
        }
    }

    public void addValueDeclaration(FieldDeclaration fieldDeclaration) {
        RecordScope rScope = (RecordScope)this.getFirstScopeThat(scope -> scope instanceof RecordScope);
        if (rScope == null) {
            LOGGER.error("Cannot add FieldDeclaration. Not in record scope.");
            return;
        }
        rScope.addValueDeclaration(fieldDeclaration);
        List<FieldDeclaration> fields = ((RecordDeclaration)rScope.getAstNode()).getFields();
        if (!fields.contains(fieldDeclaration)) {
            fields.add(fieldDeclaration);
        }
    }

    public void addValueDeclaration(FunctionDeclaration functionDeclaration) {
        DeclarationScope scopeForFunction = (DeclarationScope)this.getFirstScopeThat(scope -> scope instanceof RecordScope);
        if (scopeForFunction == null) {
            scopeForFunction = (DeclarationScope)this.getFirstScopeThat(scope -> scope instanceof GlobalScope);
        }
        if (scopeForFunction == null) {
            LOGGER.error("Cannot add FunctionDeclaration. Not in record or global scope.");
            return;
        }
        scopeForFunction.addValueDeclaration(functionDeclaration);
        if (scopeForFunction.getAstNode() != null) {
            RecordDeclaration rDecl = (RecordDeclaration)scopeForFunction.getAstNode();
            List<FunctionDeclaration> functions = new ArrayList<FunctionDeclaration>();
            if (functionDeclaration instanceof ConstructorDeclaration) {
                functions = rDecl.getConstructors().stream().map(m3 -> m3).collect(Collectors.toList());
            } else if (functionDeclaration instanceof MethodDeclaration) {
                functions = rDecl.getMethods().stream().map(m3 -> m3).collect(Collectors.toList());
            }
            if (!functions.contains(functionDeclaration)) {
                functions.add(functionDeclaration);
            }
        }
    }

    public void addTypedef(TypedefDeclaration typedef) {
        DeclarationScope scope = (DeclarationScope)this.getFirstScopeThat(DeclarationScope.class::isInstance);
        if (scope == null) {
            LOGGER.error("Cannot add typedef. Not in declaration scope.");
            return;
        }
        scope.addTypedef(typedef);
        if (scope.astNode == null) {
            this.lang.getCurrentTU().addTypedef(typedef);
        } else {
            scope.astNode.addTypedef(typedef);
        }
    }

    public List<TypedefDeclaration> getCurrentTypedefs() {
        return this.getCurrentTypedefs(this.currentScope);
    }

    private List<TypedefDeclaration> getCurrentTypedefs(Scope scope) {
        ArrayList<TypedefDeclaration> curr = new ArrayList<TypedefDeclaration>();
        if (scope instanceof DeclarationScope) {
            curr.addAll(((DeclarationScope)scope).getTypedefs());
        }
        if (scope.getParent() != null) {
            for (TypedefDeclaration parentTypedef : this.getCurrentTypedefs(scope.getParent())) {
                if (!curr.stream().map(TypedefDeclaration::getAlias).noneMatch(parentTypedef.getAlias()::equals)) continue;
                curr.add(parentTypedef);
            }
        }
        return curr;
    }

    public String getCurrentNamePrefix() {
        Scope namedScope = this.getFirstScopeThat(scope -> scope instanceof NameScope || scope instanceof RecordScope);
        if (namedScope instanceof NameScope) {
            return ((NameScope)namedScope).getNamePrefix();
        }
        if (namedScope instanceof RecordScope) {
            return namedScope.getAstNode().getName();
        }
        return "";
    }

    public String getCurrentNamePrefixWithDelimiter() {
        Object namePrefix = this.getCurrentNamePrefix();
        if (!((String)namePrefix).isEmpty()) {
            namePrefix = (String)namePrefix + this.lang.getNamespaceDelimiter();
        }
        return namePrefix;
    }

    public String getFullNamePrefix() {
        Scope searchScope = this.currentScope;
        StringBuilder fullname = new StringBuilder();
        do {
            if (!(searchScope instanceof NameScope) && !(searchScope instanceof RecordScope)) continue;
            if (searchScope instanceof NameScope) {
                fullname.insert(0, ((NameScope)searchScope).getNamePrefix() + ".");
            }
            if (!(searchScope instanceof RecordScope)) continue;
            fullname.insert(0, searchScope.getAstNode().getName() + ".");
        } while ((searchScope = searchScope.parent) != null);
        if (fullname.length() > 0) {
            return fullname.substring(0, fullname.length() - 1);
        }
        return "";
    }

    public @Nullable ValueDeclaration resolve(DeclaredReferenceExpression ref) {
        return this.resolve(this.currentScope, ref);
    }

    private @Nullable ValueDeclaration resolve(Scope scope, DeclaredReferenceExpression ref) {
        if (scope instanceof DeclarationScope) {
            for (ValueDeclaration valDecl : ((DeclarationScope)scope).getValueDeclarations()) {
                if (!valDecl.getName().equals(ref.getName())) continue;
                return valDecl;
            }
        }
        return scope.getParent() != null ? this.resolve(scope.getParent(), ref) : null;
    }

    public Scope getScopeOfStatment(Node node) {
        return this.scopeMap.getOrDefault(node, null);
    }

    public void connectToLocal(DeclaredReferenceExpression referenceExpression) {
        RecordDeclaration currentRecord;
        FunctionDeclaration currentFunction;
        CompoundStatement currentBlock;
        if (this.isInBlock() && this.expressionRefersToDeclaration(referenceExpression, (currentBlock = this.getCurrentBlock()).getLocals())) {
            return;
        }
        if (this.isInFunction() && (currentFunction = this.getCurrentFunction()) != null && this.expressionRefersToDeclaration(referenceExpression, currentFunction.getParameters())) {
            return;
        }
        if (this.isInRecord() && this.expressionRefersToDeclaration(referenceExpression, (currentRecord = this.getCurrentRecord()).getFields())) {
            return;
        }
        this.expressionRefersToDeclaration(referenceExpression, this.getGlobals());
    }

    private <T extends ValueDeclaration> boolean expressionRefersToDeclaration(DeclaredReferenceExpression referenceExpression, List<T> variables) {
        Optional<ValueDeclaration> any = variables.stream().filter(param -> Objects.equals(param.getName(), referenceExpression.getName())).findAny();
        if (any.isPresent()) {
            ValueDeclaration declaration = any.get();
            referenceExpression.setRefersTo(declaration);
            referenceExpression.setType(declaration.getType());
            LOGGER.debug("Connecting {} to method parameter {} of type {}", referenceExpression, declaration, declaration.getType());
            return true;
        }
        return false;
    }

    public void replaceNode(Node newNode, Node oldNode) {
        Scope scope = this.scopeMap.get(oldNode);
        if (scope != null) {
            scope.astNode = newNode;
            this.scopeMap.remove(oldNode);
            this.scopeMap.put(newNode, scope);
        }
    }

    public void resetToGlobal() {
        GlobalScope global = (GlobalScope)this.getFirstScopeThat(scope -> scope instanceof GlobalScope);
        if (global != null) {
            this.currentScope = global;
        }
    }

    @Deprecated
    public @Nullable Declaration getDeclarationForName(String name) {
        RecordDeclaration currentRecord;
        FunctionDeclaration currentFunction;
        CompoundStatement currentBlock;
        Declaration declaration;
        if (this.isInBlock() && (declaration = this.getForName((currentBlock = this.getCurrentBlock()).getLocals(), name)) != null) {
            return declaration;
        }
        if (this.isInFunction() && (declaration = this.getForName((currentFunction = this.getCurrentFunction()).getParameters(), name)) != null) {
            return declaration;
        }
        if (this.isInRecord() && (declaration = this.getForName((currentRecord = this.getCurrentRecord()).getFields(), name)) != null) {
            return declaration;
        }
        declaration = this.getForName(this.getGlobals(), name);
        return declaration;
    }

    @Deprecated
    private <T extends ValueDeclaration> @Nullable Declaration getForName(List<T> variables, String name) {
        Optional<ValueDeclaration> any = variables.stream().filter(param -> Objects.equals(param.getName(), name)).findAny();
        return any.orElse(null);
    }
}

