/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes;

import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.frontends.java.JavaLanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.Declaration;
import de.fraunhofer.aisec.cpg.graph.DeclaredReferenceExpression;
import de.fraunhofer.aisec.cpg.graph.EnumDeclaration;
import de.fraunhofer.aisec.cpg.graph.FieldDeclaration;
import de.fraunhofer.aisec.cpg.graph.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.MemberCallExpression;
import de.fraunhofer.aisec.cpg.graph.MemberExpression;
import de.fraunhofer.aisec.cpg.graph.MethodDeclaration;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.NodeBuilder;
import de.fraunhofer.aisec.cpg.graph.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.StaticReferenceExpression;
import de.fraunhofer.aisec.cpg.graph.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.ValueDeclaration;
import de.fraunhofer.aisec.cpg.graph.type.FunctionPointerType;
import de.fraunhofer.aisec.cpg.graph.type.Type;
import de.fraunhofer.aisec.cpg.graph.type.TypeParser;
import de.fraunhofer.aisec.cpg.graph.type.UnknownType;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import de.fraunhofer.aisec.cpg.helpers.Util;
import de.fraunhofer.aisec.cpg.passes.Pass;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariableUsageResolver
extends Pass {
    private static final Logger log = LoggerFactory.getLogger(VariableUsageResolver.class);
    private Map<Type, List<Type>> superTypesMap = new HashMap<Type, List<Type>>();
    private Map<Type, RecordDeclaration> recordMap = new HashMap<Type, RecordDeclaration>();
    private Map<Type, EnumDeclaration> enumMap = new HashMap<Type, EnumDeclaration>();
    private TranslationUnitDeclaration currTu;
    private SubgraphWalker.ScopedWalker walker;

    @Override
    public void cleanup() {
        this.superTypesMap.clear();
        if (this.recordMap != null) {
            this.recordMap.clear();
        }
        this.enumMap.clear();
    }

    @Override
    public void accept(TranslationResult result) {
        this.walker = new SubgraphWalker.ScopedWalker();
        Iterator<TranslationUnitDeclaration> iterator = result.getTranslationUnits().iterator();
        while (iterator.hasNext()) {
            TranslationUnitDeclaration tu;
            this.currTu = tu = iterator.next();
            this.walker.clearCallbacks();
            this.walker.registerHandler((currClass, parent, currNode) -> this.walker.collectDeclarations((Node)currNode));
            this.walker.registerHandler(this::findRecordsAndEnums);
            this.walker.iterate(this.currTu);
        }
        Map<Type, List> currSuperTypes = this.recordMap.values().stream().collect(Collectors.toMap(r -> TypeParser.createFrom(r.getName(), true), RecordDeclaration::getSuperTypes));
        this.superTypesMap.putAll(currSuperTypes);
        for (TranslationUnitDeclaration tu : result.getTranslationUnits()) {
            this.walker.clearCallbacks();
            this.walker.registerHandler(this::resolveFieldUsages);
            this.walker.iterate(tu);
        }
        for (TranslationUnitDeclaration tu : result.getTranslationUnits()) {
            this.walker.clearCallbacks();
            this.walker.registerHandler(this::resolveLocalVarUsage);
            this.walker.iterate(tu);
        }
    }

    private void findRecordsAndEnums(Node node, RecordDeclaration curClass) {
        if (node instanceof RecordDeclaration) {
            Type type = TypeParser.createFrom(node.getName(), true);
            this.recordMap.putIfAbsent(type, (RecordDeclaration)node);
        } else if (node instanceof EnumDeclaration) {
            Type type = TypeParser.createFrom(node.getName(), true);
            this.enumMap.putIfAbsent(type, (EnumDeclaration)node);
        }
    }

    private Set<ValueDeclaration> resolveFunctionPtr(Type containingClass, DeclaredReferenceExpression reference) {
        if (!(reference.getType() instanceof FunctionPointerType)) {
            log.error("Can't resolve a function pointer without a function pointer type!");
            return Collections.emptySet();
        }
        FunctionPointerType fptrType = (FunctionPointerType)reference.getType();
        Optional<Object> target = Optional.empty();
        String functionName = reference.getName();
        Matcher matcher = Pattern.compile("(?:(?<class>.*)(?:\\.|::))?(?<function>.*)").matcher(reference.getName());
        if (matcher.matches()) {
            String cls = matcher.group("class");
            String finalFunctionName = functionName = matcher.group("function");
            if (cls == null) {
                target = this.walker.getAllDeclarationsForScope(reference).stream().filter(FunctionDeclaration.class::isInstance).map(FunctionDeclaration.class::cast).filter(d -> d.getName().equals(finalFunctionName) && d.getType().equals(fptrType.getReturnType()) && d.hasSignature(fptrType.getParameters())).findFirst();
            } else {
                containingClass = TypeParser.createFrom(cls, true);
                if (this.recordMap.containsKey(containingClass)) {
                    target = this.recordMap.get(containingClass).getMethods().stream().map(FunctionDeclaration.class::cast).filter(f -> f.getName().equals(finalFunctionName) && f.getType().equals(fptrType.getReturnType()) && f.hasSignature(fptrType.getParameters())).findFirst();
                }
            }
        }
        HashSet<ValueDeclaration> targets = new HashSet<ValueDeclaration>();
        if (target.isPresent()) {
            targets.add((ValueDeclaration)target.get());
            return targets;
        }
        if (containingClass == null) {
            targets.add(this.handleUnknownMethod(functionName, reference.getType()));
        } else {
            MethodDeclaration resolved = this.handleUnknownClassMethod(containingClass, functionName, reference.getType());
            if (resolved != null) {
                targets.add(resolved);
            }
        }
        return targets;
    }

    private void resolveLocalVarUsage(RecordDeclaration currentClass, Node parent, Node current) {
        if (current instanceof DeclaredReferenceExpression) {
            ValueDeclaration field;
            DeclaredReferenceExpression ref = (DeclaredReferenceExpression)current;
            if (parent instanceof MemberCallExpression && current == ((MemberCallExpression)parent).getMember() && !(ref.getType() instanceof FunctionPointerType)) {
                return;
            }
            Set<ValueDeclaration> refersTo = this.walker.getDeclarationForScope(parent, v -> !(v instanceof FunctionDeclaration) && v.getName().equals(ref.getName())).map(d -> {
                HashSet<ValueDeclaration> set = new HashSet<ValueDeclaration>();
                set.add((ValueDeclaration)d);
                return set;
            }).orElse(new HashSet());
            Type recordDeclType = null;
            if (currentClass != null) {
                recordDeclType = TypeParser.createFrom(currentClass.getName(), true);
            }
            if (ref.getType() instanceof FunctionPointerType && refersTo.isEmpty()) {
                refersTo = this.resolveFunctionPtr(recordDeclType, ref);
            }
            if (refersTo.isEmpty() && !(current instanceof StaticReferenceExpression) && recordDeclType != null && this.recordMap.containsKey(recordDeclType) && (field = this.resolveMember(recordDeclType, (DeclaredReferenceExpression)current)) != null) {
                HashSet<ValueDeclaration> resolvedMember = new HashSet<ValueDeclaration>();
                resolvedMember.add(field);
                refersTo = resolvedMember;
            }
            if (!refersTo.isEmpty()) {
                ref.setRefersTo(refersTo);
            } else {
                Util.warnWithFileLocation(current, log, "Did not find a declaration for {}", ref.getName());
            }
        }
    }

    private void resolveFieldUsages(Node current, RecordDeclaration curClass) {
        if (current instanceof MemberExpression) {
            MemberExpression memberExpression = (MemberExpression)current;
            Node base = memberExpression.getBase();
            Node member = memberExpression.getMember();
            if (base instanceof DeclaredReferenceExpression) {
                if (this.lang instanceof JavaLanguageFrontend && base.getName().equals("super")) {
                    if (curClass != null && !curClass.getSuperClasses().isEmpty()) {
                        base = this.recordMap.get(curClass.getSuperClasses().get(0)).getThis();
                    } else {
                        Type objectType = TypeParser.createFrom(Object.class.getName(), true);
                        base = this.handleUnknownField(objectType, "this", objectType);
                    }
                } else {
                    base = this.resolveBase((DeclaredReferenceExpression)memberExpression.getBase());
                }
            }
            if (member instanceof DeclaredReferenceExpression) {
                if (base instanceof EnumDeclaration) {
                    String name = member.getName();
                    member = ((EnumDeclaration)base).getEntries().stream().filter(e -> e.getName().equals(name)).findFirst().orElse(null);
                } else {
                    Type baseType = UnknownType.getUnknownType();
                    if (base instanceof HasType) {
                        baseType = ((HasType)((Object)base)).getType();
                    }
                    if (base instanceof RecordDeclaration) {
                        baseType = TypeParser.createFrom(base.getName(), true);
                    }
                    Node node = member = base == null ? null : this.resolveMember(baseType, (DeclaredReferenceExpression)memberExpression.getMember());
                    if (member != null) {
                        HasType typedMember = (HasType)((Object)member);
                        typedMember.setType(memberExpression.getType());
                        HashSet<Type> subTypes = new HashSet<Type>(typedMember.getPossibleSubTypes());
                        subTypes.addAll(memberExpression.getPossibleSubTypes());
                        typedMember.setPossibleSubTypes(subTypes);
                    }
                }
            }
            if (base != null && member != null) {
                if (base != memberExpression.getBase()) {
                    memberExpression.getBase().disconnectFromGraph();
                }
                if (member != memberExpression.getMember()) {
                    memberExpression.getMember().disconnectFromGraph();
                }
                memberExpression.setBase(base);
                memberExpression.setMember(member);
            } else {
                log.warn("Unexpected: null base or member in field usage: {}", (Object)current);
            }
        }
    }

    private Declaration resolveBase(DeclaredReferenceExpression reference) {
        if (this.enumMap.containsKey(reference.getType())) {
            return this.enumMap.get(reference.getType());
        }
        if (this.recordMap.containsKey(reference.getType())) {
            RecordDeclaration recordDeclaration = this.recordMap.get(reference.getType());
            if (reference instanceof StaticReferenceExpression) {
                return recordDeclaration;
            }
            if (recordDeclaration.getThis() != null) {
                return recordDeclaration.getThis();
            }
            return recordDeclaration;
        }
        log.info("Type declaration for {} not found in graph, using dummy to collect all usages", (Object)reference.getType());
        return this.handleUnknownField(reference.getType(), reference.getName(), reference.getType());
    }

    private ValueDeclaration resolveMember(Type containingClass, DeclaredReferenceExpression reference) {
        if (this.lang instanceof JavaLanguageFrontend && reference.getName().matches("(?<class>.+\\.)?super")) {
            return null;
        }
        Optional<FieldDeclaration> member = Optional.empty();
        if (!(containingClass instanceof UnknownType) && this.recordMap.containsKey(containingClass)) {
            member = this.recordMap.get(containingClass).getFields().stream().filter(f -> f.getName().equals(reference.getName())).findFirst();
        }
        if (member.isEmpty()) {
            member = this.superTypesMap.getOrDefault(containingClass, Collections.emptyList()).stream().map(this.recordMap::get).filter(Objects::nonNull).flatMap(r -> r.getFields().stream()).filter(f -> f.getName().equals(reference.getName())).findFirst();
        }
        return member.orElseGet(() -> this.handleUnknownField(containingClass, reference.getName(), reference.getType()));
    }

    private FieldDeclaration handleUnknownField(Type base, String name, Type type) {
        if (!this.recordMap.containsKey(base)) {
            return null;
        }
        List<FieldDeclaration> declarations = this.recordMap.get(base).getFields();
        Optional<FieldDeclaration> target = declarations.stream().filter(f -> f.getName().equals(name)).findFirst();
        if (target.isEmpty()) {
            FieldDeclaration declaration = NodeBuilder.newFieldDeclaration(name, type, Collections.emptyList(), "", null, null, false);
            declarations.add(declaration);
            declaration.setImplicit(true);
            return declaration;
        }
        return target.get();
    }

    private MethodDeclaration handleUnknownClassMethod(Type base, String name, Type type) {
        if (!this.recordMap.containsKey(base)) {
            return null;
        }
        RecordDeclaration containingRecord = this.recordMap.get(base);
        List<MethodDeclaration> declarations = containingRecord.getMethods();
        Optional<MethodDeclaration> target = declarations.stream().filter(f -> f.getName().equals(name)).findFirst();
        if (target.isEmpty()) {
            MethodDeclaration declaration = NodeBuilder.newMethodDeclaration(name, "", false, containingRecord);
            declaration.setType(type);
            declarations.add(declaration);
            declaration.setImplicit(true);
            return declaration;
        }
        return target.get();
    }

    private FunctionDeclaration handleUnknownMethod(String name, Type type) {
        Optional<FunctionDeclaration> target = this.currTu.getDeclarations().stream().filter(FunctionDeclaration.class::isInstance).map(FunctionDeclaration.class::cast).filter(f -> f.getName().equals(name)).filter(f -> f.hasSignature(((FunctionPointerType)type).getParameters())).findFirst();
        if (target.isEmpty()) {
            FunctionDeclaration declaration = NodeBuilder.newFunctionDeclaration(name, "");
            if (type instanceof FunctionPointerType) {
                declaration.setType(((FunctionPointerType)type).getReturnType());
                declaration.setParameters(Util.createParameters(((FunctionPointerType)type).getParameters()));
            } else {
                declaration.setType(type);
            }
            this.currTu.add(declaration);
            declaration.setImplicit(true);
            return declaration;
        }
        return target.get();
    }
}

