/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes;

import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.type.FunctionPointerType;
import de.fraunhofer.aisec.cpg.graph.type.ObjectType;
import de.fraunhofer.aisec.cpg.graph.type.SecondOrderType;
import de.fraunhofer.aisec.cpg.graph.type.Type;
import de.fraunhofer.aisec.cpg.graph.type.TypeParser;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import de.fraunhofer.aisec.cpg.passes.Pass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TypeResolver
extends Pass {
    private Set<Type> firstOrderTypes = new HashSet<Type>();
    private Map<Type, List<Type>> typeState = new HashMap<Type, List<Type>>();

    private void processSecondOrderTypes(Type type) {
        Type root = type.getRoot();
        if (this.typeState.get(root).contains(type)) {
            return;
        }
        this.typeState.get(root).add(type);
        Type element = null;
        if (type instanceof SecondOrderType) {
            element = ((SecondOrderType)((Object)type)).getElementType();
        }
        assert (element != null);
        if (!(element instanceof SecondOrderType)) {
            return;
        }
        Type finalElement = element;
        Type newElement = this.typeState.get(root).stream().filter(t -> t.equals(finalElement)).findAny().orElse(null);
        if (newElement != null) {
            ((SecondOrderType)((Object)type)).setElementType(newElement);
        } else {
            this.processSecondOrderTypes(element);
        }
    }

    public Type obtainType(Type type) {
        if (type == null) {
            return null;
        }
        Type root = type.getRoot();
        if (root.equals(type) && this.typeState.containsKey(type)) {
            for (Type t : this.typeState.keySet()) {
                if (!t.equals(type)) continue;
                return t;
            }
        } else {
            this.addType(type);
            return type;
        }
        if (this.typeState.containsKey(root)) {
            List<Type> references = this.typeState.get(root);
            for (Type r : references) {
                if (!r.equals(type)) continue;
                return r;
            }
            this.addType(type);
            return type;
        }
        this.addType(type);
        return type;
    }

    private void addType(Type type) {
        Type root = type.getRoot();
        if (root.equals(type) && !this.typeState.containsKey(type)) {
            this.typeState.put(type, new ArrayList());
            return;
        }
        if (this.typeState.containsKey(root)) {
            if (!this.typeState.get(root).contains(type)) {
                this.typeState.get(root).add(type);
                this.addType(((SecondOrderType)((Object)type)).getElementType());
            }
        } else {
            this.addType(type.getRoot());
            this.addType(type);
        }
    }

    private void removeDuplicateTypes() {
        TypeManager typeManager = TypeManager.getInstance();
        this.firstOrderTypes.addAll(typeManager.getFirstOrderTypes());
        Set<Type> secondOrderTypes = typeManager.getSecondOrderTypes();
        for (Type t : secondOrderTypes) {
            Type root;
            Type newRoot = root = t.getRoot();
            for (Type firstOrderRoot : this.firstOrderTypes) {
                if (!firstOrderRoot.equals(root)) continue;
                newRoot = firstOrderRoot;
                break;
            }
            t.setRoot(newRoot);
        }
        for (Type t : this.firstOrderTypes) {
            this.typeState.put(t, new ArrayList());
        }
        for (Type t : secondOrderTypes) {
            this.processSecondOrderTypes(t);
        }
        for (Type t : secondOrderTypes) {
            this.removeDuplicatesInFields(t);
        }
    }

    private void removeDuplicatesInFields(Type t) {
        if (t instanceof FunctionPointerType) {
            ((FunctionPointerType)t).setReturnType(this.obtainType(((FunctionPointerType)t).getReturnType()));
            ArrayList<Type> newParameters = new ArrayList<Type>();
            for (Type t2 : ((FunctionPointerType)t).getParameters()) {
                newParameters.add(this.obtainType(t2));
            }
            ((FunctionPointerType)t).setParameters(newParameters);
        } else if (t instanceof ObjectType) {
            ArrayList<Type> newGenerics = new ArrayList<Type>();
            for (Type generic : ((ObjectType)t).getGenerics()) {
                newGenerics.add(this.obtainType(generic));
            }
            ((ObjectType)t).setGenerics(newGenerics);
        }
    }

    @Override
    public void accept(TranslationResult translationResult) {
        this.removeDuplicateTypes();
        SubgraphWalker.IterativeGraphWalker walker = new SubgraphWalker.IterativeGraphWalker();
        walker.registerOnNodeVisit(this::ensureUniqueType);
        walker.registerOnNodeVisit(this::handle);
        for (TranslationUnitDeclaration tu : translationResult.getTranslationUnits()) {
            walker.iterate(tu);
        }
    }

    public Set<Type> ensureUniqueSubTypes(Set<Type> subTypes) {
        HashSet<Type> uniqueTypes = new HashSet<Type>();
        block0: for (Type subType : subTypes) {
            Collection<Type> trackedTypes;
            if (subType.isFirstOrderType()) {
                trackedTypes = this.typeState.keySet();
            } else {
                Type root = subType.getRoot();
                trackedTypes = this.typeState.get(root);
            }
            for (Type t : trackedTypes) {
                if (!t.equals(subType)) continue;
                uniqueTypes.add(t);
                continue block0;
            }
        }
        return uniqueTypes;
    }

    public void ensureUniqueType(Node node) {
        if (node instanceof HasType) {
            Collection<Type> types;
            Type oldType = ((HasType)((Object)node)).getType();
            if (oldType.isFirstOrderType()) {
                types = this.typeState.keySet();
            } else {
                Type root = oldType.getRoot();
                types = this.typeState.get(root);
            }
            for (Type t : types) {
                if (!t.equals(oldType)) continue;
                ((HasType)((Object)node)).updateType(t);
                break;
            }
            ((HasType)((Object)node)).updatePossibleSubtypes(this.ensureUniqueSubTypes(((HasType)((Object)node)).getPossibleSubTypes()));
        }
    }

    public void handle(Node node) {
        if (node instanceof RecordDeclaration) {
            String recordDeclarationName = node.getName();
            for (Type t : this.typeState.keySet()) {
                if (!t.getTypeName().equals(recordDeclarationName) || !(t instanceof ObjectType)) continue;
                ((ObjectType)t).setRecordDeclaration((RecordDeclaration)node);
            }
        }
    }

    @Override
    public void cleanup() {
        this.firstOrderTypes.clear();
        this.typeState.clear();
        TypeParser.reset();
        TypeManager.reset();
    }
}

