/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph.type;

import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.type.FunctionPointerType;
import de.fraunhofer.aisec.cpg.graph.type.IncompleteType;
import de.fraunhofer.aisec.cpg.graph.type.ObjectType;
import de.fraunhofer.aisec.cpg.graph.type.PointerType;
import de.fraunhofer.aisec.cpg.graph.type.ReferenceType;
import de.fraunhofer.aisec.cpg.graph.type.Type;
import de.fraunhofer.aisec.cpg.graph.type.UnknownType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TypeParser {
    public static final String UNKNOWN_TYPE_STRING = "UNKNOWN";
    private static final List<String> primitives = List.of("byte", "short", "int", "long", "float", "double", "boolean", "char");
    private static final Pattern functionPtrRegex = Pattern.compile("(?:(?<functionptr>(\\h|\\()+[a-zA-Z0-9_$.<>:]*\\*\\h*[a-zA-Z0-9_$.<>:]*(\\h|\\))+)\\h*)(?<args>\\(+[a-zA-Z0-9_$.<>,\\*\\&\\h]*\\))");
    private static Supplier<TypeManager.Language> languageSupplier = () -> TypeManager.getInstance().getLanguage();
    private static final String VOLATILE_QUALIFIER = "volatile";
    private static final String FINAL_QUALIFIER = "final";
    private static final String CONST_QUALIFIER = "const";
    private static final String RESTRICT_QUALIFIER = "restrict";
    private static final String ATOMIC_QUALIFIER = "atomic";
    private static final String ELABORATED_TYPE_CLASS = "class";
    private static final String ELABORATED_TYPE_STRUCT = "struct";
    private static final String ELABORATED_TYPE_UNION = "union";
    private static final String ELABORATED_TYPE_ENUM = "enum";
    private static final List<String> elaboratedTypes = List.of("class", "struct", "union", "enum");

    private TypeParser() {
        throw new IllegalStateException("Do not instantiate the TypeParser");
    }

    public static void reset() {
        languageSupplier = () -> TypeManager.getInstance().getLanguage();
    }

    public static void setLanguageSupplier(Supplier<TypeManager.Language> languageSupplier) {
        TypeParser.languageSupplier = languageSupplier;
    }

    public static TypeManager.Language getLanguage() {
        return languageSupplier.get();
    }

    public static Type.Qualifier calcQualifier(List<String> typeString, Type.Qualifier old) {
        boolean constantFlag = false;
        boolean volatileFlag = false;
        boolean restrictFlag = false;
        boolean atomicFlag = false;
        if (old != null) {
            constantFlag = old.isConst();
            volatileFlag = old.isVolatile();
            restrictFlag = old.isRestrict();
            atomicFlag = old.isAtomic();
        }
        Iterator<String> iterator = typeString.iterator();
        while (iterator.hasNext()) {
            String part;
            switch (part = iterator.next()) {
                case "final": 
                case "const": {
                    constantFlag = true;
                    break;
                }
                case "volatile": {
                    volatileFlag = true;
                    break;
                }
                case "restrict": {
                    restrictFlag = true;
                    break;
                }
                case "atomic": {
                    atomicFlag = true;
                    break;
                }
            }
        }
        return new Type.Qualifier(constantFlag, volatileFlag, restrictFlag, atomicFlag);
    }

    public static Type.Storage calcStorage(List<String> typeString) {
        for (String part : typeString) {
            try {
                return Type.Storage.valueOf(part.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        return Type.Storage.AUTO;
    }

    public static boolean isStorageSpecifier(String specifier) {
        if (TypeParser.getLanguage() == TypeManager.Language.CXX) {
            return specifier.equalsIgnoreCase("STATIC");
        }
        try {
            Type.Storage.valueOf(specifier.toUpperCase());
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    protected static boolean isQualifierSpecifier(String qualifier) {
        if (TypeParser.getLanguage() == TypeManager.Language.JAVA) {
            return qualifier.equals(FINAL_QUALIFIER) || qualifier.equals(VOLATILE_QUALIFIER);
        }
        return qualifier.equals(CONST_QUALIFIER) || qualifier.equals(VOLATILE_QUALIFIER) || qualifier.equals(RESTRICT_QUALIFIER) || qualifier.equals(ATOMIC_QUALIFIER);
    }

    public static boolean isElaboratedTypeSpecifier(String specifier) {
        if (TypeParser.getLanguage() == TypeManager.Language.CXX) {
            return specifier.equals(ELABORATED_TYPE_CLASS) || specifier.equals(ELABORATED_TYPE_STRUCT) || specifier.equals(ELABORATED_TYPE_UNION) || specifier.equals(ELABORATED_TYPE_ENUM);
        }
        return false;
    }

    public static boolean isKnownSpecifier(String specifier) {
        return TypeParser.isQualifierSpecifier(specifier) || TypeParser.isStorageSpecifier(specifier);
    }

    private static int findMatching(char openBracket, char closeBracket, String string) {
        int counter = 1;
        int i = 0;
        while (counter != 0) {
            if (i >= string.length()) {
                return string.length();
            }
            char actualChar = string.charAt(i);
            if (actualChar == openBracket) {
                ++counter;
            } else if (actualChar == closeBracket) {
                --counter;
            }
            ++i;
        }
        return i;
    }

    private static @Nullable Matcher getFunctionPtrMatcher(@NonNull List<String> type) {
        StringBuilder typeStringBuilder = new StringBuilder();
        for (String typePart : type) {
            typeStringBuilder.append(typePart);
        }
        String typeString = typeStringBuilder.toString().trim();
        Matcher matcher = functionPtrRegex.matcher(typeString);
        if (matcher.find()) {
            return matcher;
        }
        return null;
    }

    private static boolean isIncompleteType(String typeName) {
        return typeName.trim().equals("void");
    }

    private static boolean isUnknownType(String typeName) {
        return typeName.equals(UNKNOWN_TYPE_STRING);
    }

    private static @NonNull String fixGenerics(@NonNull String type) {
        if (((String)type).contains("<") && ((String)type).contains(">") && TypeParser.getLanguage() == TypeManager.Language.CXX) {
            String generics = ((String)type).substring(((String)type).indexOf(60) + 1, ((String)type).lastIndexOf(62));
            for (String elaborate : elaboratedTypes) {
                generics = generics.replaceAll("(^|(?<=[\\h,<]))\\h*(?<main>" + elaborate + "\\h+)", "");
            }
            type = ((String)type).substring(0, ((String)type).indexOf(60) + 1) + generics.trim() + ((String)type).substring(((String)type).lastIndexOf(62));
        }
        StringBuilder out = new StringBuilder();
        int bracketCount = 0;
        block6: for (int iterator = 0; iterator < ((String)type).length(); ++iterator) {
            switch (((String)type).charAt(iterator)) {
                case '<': {
                    ++bracketCount;
                    out.append(((String)type).charAt(iterator));
                    continue block6;
                }
                case '>': {
                    out.append('>');
                    --bracketCount;
                    continue block6;
                }
                case ' ': {
                    if (bracketCount != 0) continue block6;
                    out.append(((String)type).charAt(iterator));
                    continue block6;
                }
                default: {
                    out.append(((String)type).charAt(iterator));
                }
            }
        }
        String[] splitted = out.toString().split("\\<");
        StringBuilder out2 = new StringBuilder();
        for (String s2 : splitted) {
            if (out2.length() > 0) {
                out2.append('<');
            }
            out2.append(s2.trim());
        }
        return out2.toString();
    }

    private static void processBlockUntilLastSplit(@NonNull String type, int lastSplit, int newPosition, @NonNull List<String> typeBlocks) {
        String substr = type.substring(lastSplit, newPosition);
        if (substr.length() != 0) {
            typeBlocks.add(substr);
        }
    }

    public static @NonNull List<String> separate(@NonNull String type) {
        type = type.replace("::", ".");
        type = type.split("=")[0];
        CharSequence[] typeSubpart = type.split(" ");
        type = String.join((CharSequence)" ", typeSubpart).trim();
        ArrayList<String> typeBlocks = new ArrayList<String>();
        int lastSplit = 0;
        int finishPosition = 0;
        String substr = "";
        block7: for (int i = 0; i < type.length(); ++i) {
            char ch = type.charAt(i);
            switch (ch) {
                case ' ': {
                    TypeParser.processBlockUntilLastSplit(type, lastSplit, i, typeBlocks);
                    lastSplit = i + 1;
                    continue block7;
                }
                case '(': {
                    TypeParser.processBlockUntilLastSplit(type, lastSplit, i, typeBlocks);
                    finishPosition = TypeParser.findMatching('(', ')', type.substring(i + 1));
                    typeBlocks.add(type.substring(i, i + finishPosition + 1));
                    i = finishPosition + i;
                    lastSplit = i + 1;
                    continue block7;
                }
                case '[': {
                    TypeParser.processBlockUntilLastSplit(type, lastSplit, i, typeBlocks);
                    finishPosition = TypeParser.findMatching('[', ']', type.substring(i + 1));
                    typeBlocks.add("[]");
                    i = finishPosition + i;
                    lastSplit = i + 1;
                    continue block7;
                }
                case '*': {
                    TypeParser.processBlockUntilLastSplit(type, lastSplit, i, typeBlocks);
                    typeBlocks.add("*");
                    lastSplit = i + 1;
                    continue block7;
                }
                case '&': {
                    TypeParser.processBlockUntilLastSplit(type, lastSplit, i, typeBlocks);
                    typeBlocks.add("&");
                    lastSplit = i + 1;
                    continue block7;
                }
                default: {
                    substr = type.substring(lastSplit, type.length());
                    if (substr.length() == 0 || i != type.length() - 1) continue block7;
                    typeBlocks.add(substr);
                }
            }
        }
        return typeBlocks;
    }

    private static List<Type> getParameterList(String parameterList) {
        String[] parametersSplit;
        if (parameterList.startsWith("(") && parameterList.endsWith(")")) {
            parameterList = parameterList.trim().substring(1, parameterList.trim().length() - 1);
        }
        ArrayList<Type> parameters = new ArrayList<Type>();
        for (String parameter : parametersSplit = parameterList.split(",")) {
            if (parameter.length() <= 0) continue;
            parameters.add(TypeParser.createFrom(parameter.trim(), true));
        }
        return parameters;
    }

    private static List<Type> getGenerics(String typeName) {
        if (typeName.contains("<") && typeName.contains(">")) {
            String[] parametersSplit;
            String generics = typeName.substring(typeName.indexOf(60) + 1, typeName.lastIndexOf(62));
            ArrayList<Type> genericList = new ArrayList<Type>();
            for (String parameter : parametersSplit = generics.split(",")) {
                genericList.add(TypeParser.createFrom(parameter.trim(), true));
            }
            return genericList;
        }
        return new ArrayList<Type>();
    }

    private static Type performBracketContentAction(Type finalType, String part) {
        if (part.equals("*")) {
            return finalType.reference(PointerType.PointerOrigin.POINTER);
        }
        if (part.equals("&")) {
            return finalType.dereference();
        }
        if (part.startsWith("[") && part.endsWith("]")) {
            return finalType.reference(PointerType.PointerOrigin.ARRAY);
        }
        if (part.startsWith("(") && part.endsWith(")")) {
            ArrayList<String> subBracketExpression = new ArrayList<String>();
            subBracketExpression.add(part);
            return TypeParser.resolveBracketExpression(finalType, subBracketExpression);
        }
        if (TypeParser.isStorageSpecifier(part)) {
            ArrayList<String> specifiers = new ArrayList<String>();
            specifiers.add(part);
            finalType.setStorage(TypeParser.calcStorage(specifiers));
            return finalType;
        }
        if (TypeParser.isQualifierSpecifier(part)) {
            ArrayList<String> qualifiers = new ArrayList<String>();
            qualifiers.add(part);
            finalType.setQualifier(TypeParser.calcQualifier(qualifiers, finalType.getQualifier()));
            return finalType;
        }
        return finalType;
    }

    private static Type resolveBracketExpression(@NonNull Type finalType, @NonNull List<String> bracketExpressions) {
        for (String bracketExpression : bracketExpressions) {
            List<String> splitExpression = TypeParser.separate(bracketExpression.substring(1, bracketExpression.length() - 1));
            for (String part : splitExpression) {
                finalType = TypeParser.performBracketContentAction(finalType, part);
            }
        }
        return finalType;
    }

    private static String clear(@NonNull String type) {
        return type.replaceAll("public|private|protected", "").trim();
    }

    private static boolean isPrimitiveType(@NonNull List<String> stringList) {
        for (String s2 : stringList) {
            if (!primitives.contains(s2)) continue;
            return true;
        }
        return false;
    }

    private static @NonNull List<String> joinPrimitive(@NonNull List<String> typeBlocks) {
        ArrayList<String> joinedTypeBlocks = new ArrayList<String>();
        StringBuilder primitiveType = new StringBuilder();
        boolean foundPrimitive = false;
        for (String s2 : typeBlocks) {
            if (!primitives.contains(s2)) continue;
            if (primitiveType.length() > 0) {
                primitiveType.append(" ");
            }
            primitiveType.append(s2);
        }
        for (String s2 : typeBlocks) {
            if (primitives.contains(s2) && !foundPrimitive) {
                joinedTypeBlocks.add(primitiveType.toString());
                foundPrimitive = true;
                continue;
            }
            if (primitives.contains(s2)) continue;
            joinedTypeBlocks.add(s2);
        }
        return joinedTypeBlocks;
    }

    public static @NonNull Type reWrapType(@NonNull Type oldChain, @NonNull Type newRoot) {
        if (oldChain.isFirstOrderType()) {
            newRoot.setTypeOrigin(oldChain.getTypeOrigin());
        }
        if (!newRoot.isFirstOrderType()) {
            return newRoot;
        }
        if (oldChain instanceof ObjectType && newRoot instanceof ObjectType) {
            ((ObjectType)newRoot.getRoot()).setGenerics(((ObjectType)oldChain).getGenerics());
            return newRoot;
        }
        if (oldChain instanceof ReferenceType) {
            Type reference = TypeParser.reWrapType(((ReferenceType)oldChain).getElementType(), newRoot);
            ReferenceType newChain = (ReferenceType)oldChain.duplicate();
            newChain.setElementType(reference);
            newChain.refreshName();
            return newChain;
        }
        if (oldChain instanceof PointerType) {
            PointerType newChain = (PointerType)oldChain.duplicate();
            newChain.setRoot(TypeParser.reWrapType(oldChain.getRoot(), newRoot));
            newChain.refreshNames();
            return newChain;
        }
        return newRoot;
    }

    public static @NonNull Type createIgnoringAlias(@NonNull String string) {
        return TypeParser.createFrom(string, false);
    }

    private static @NonNull Type postTypeParsing(@NonNull List<String> subPart, @NonNull Type finalType, @NonNull List<String> bracketExpressions) {
        for (String part : subPart) {
            if (part.equals("*")) {
                finalType = finalType.reference(PointerType.PointerOrigin.POINTER);
            }
            if (part.equals("&")) {
                Type.Qualifier oldQualifier = finalType.getQualifier();
                Type.Storage oldStorage = finalType.getStorage();
                finalType.setQualifier(new Type.Qualifier());
                finalType.setStorage(Type.Storage.AUTO);
                finalType = new ReferenceType(finalType);
                finalType.setStorage(oldStorage);
                finalType.setQualifier(oldQualifier);
            }
            if (part.startsWith("[") && part.endsWith("]")) {
                finalType = finalType.reference(PointerType.PointerOrigin.ARRAY);
            }
            if (part.startsWith("(") && part.endsWith(")")) {
                bracketExpressions.add(part);
            }
            if (TypeParser.isStorageSpecifier(part)) {
                ArrayList<String> specifiers = new ArrayList<String>();
                specifiers.add(part);
                finalType.setStorage(TypeParser.calcStorage(specifiers));
            }
            if (!TypeParser.isQualifierSpecifier(part)) continue;
            ArrayList<String> qualifiers = new ArrayList<String>();
            qualifiers.add(part);
            finalType.setQualifier(TypeParser.calcQualifier(qualifiers, finalType.getQualifier()));
        }
        return finalType;
    }

    private static String removeGenerics(String typeName) {
        if (typeName.contains("<") && typeName.contains(">")) {
            typeName = typeName.substring(0, typeName.indexOf(60));
        }
        return typeName;
    }

    private static ObjectType.Modifier determineModifier(List<String> typeBlocks, boolean primitiveType) {
        ObjectType.Modifier modifier = ObjectType.Modifier.NOT_APPLICABLE;
        if (primitiveType) {
            if (typeBlocks.contains("unsigned")) {
                modifier = ObjectType.Modifier.UNSIGNED;
                typeBlocks.remove("unsigned");
            } else {
                modifier = ObjectType.Modifier.SIGNED;
                typeBlocks.remove("signed");
            }
        }
        return modifier;
    }

    public static @NonNull Type createFrom(@NonNull String type, boolean resolveAlias) {
        Type finalType;
        Matcher funcptr;
        if (type.contains("?") || type.contains("org.eclipse.cdt.internal.core.dom.parser.ProblemType@") || type.trim().length() == 0) {
            return UnknownType.getUnknownType();
        }
        type = TypeParser.clear(type);
        type = TypeParser.fixGenerics(type);
        List<String> typeBlocks = TypeParser.separate(type);
        boolean primitiveType = TypeParser.isPrimitiveType(typeBlocks);
        ObjectType.Modifier modifier = TypeParser.determineModifier(typeBlocks, primitiveType);
        typeBlocks = TypeParser.joinPrimitive(typeBlocks);
        ArrayList<String> qualifierList = new ArrayList<String>();
        ArrayList<String> storageList = new ArrayList<String>();
        int counter = 0;
        for (String part : typeBlocks) {
            if (TypeParser.isQualifierSpecifier(part)) {
                qualifierList.add(part);
                ++counter;
                continue;
            }
            if (TypeParser.isStorageSpecifier(part)) {
                storageList.add(part);
                ++counter;
                continue;
            }
            if (!TypeParser.isElaboratedTypeSpecifier(part)) break;
            ++counter;
        }
        Type.Storage storageValue = TypeParser.calcStorage(storageList);
        Type.Qualifier qualifier = TypeParser.calcQualifier(qualifierList, null);
        if (counter >= typeBlocks.size()) {
            return UnknownType.getUnknownType();
        }
        String typeName = typeBlocks.get(counter);
        TypeManager typeManager = TypeManager.getInstance();
        if ((funcptr = TypeParser.getFunctionPtrMatcher(typeBlocks.subList(++counter, typeBlocks.size()))) != null) {
            Type returnType = TypeParser.createFrom(typeName, false);
            List<Type> parameterList = TypeParser.getParameterList(funcptr.group("args"));
            return typeManager.registerType(new FunctionPointerType(qualifier, storageValue, parameterList, returnType));
        }
        if (TypeParser.isIncompleteType(typeName)) {
            finalType = new IncompleteType();
        } else if (TypeParser.isUnknownType(typeName)) {
            finalType = new UnknownType(typeName);
        } else {
            List<Type> generics = TypeParser.getGenerics(typeName);
            typeName = TypeParser.removeGenerics(typeName);
            finalType = new ObjectType(typeName, storageValue, qualifier, generics, modifier, primitiveType);
        }
        if (finalType.getTypeName().equals("auto") || type.contains("auto") && !primitiveType) {
            return UnknownType.getUnknownType();
        }
        List<String> subPart = typeBlocks.subList(counter, typeBlocks.size());
        ArrayList<String> bracketExpressions = new ArrayList<String>();
        finalType = TypeParser.postTypeParsing(subPart, finalType, bracketExpressions);
        finalType = TypeParser.resolveBracketExpression(finalType, bracketExpressions);
        finalType = typeManager.registerType(finalType);
        if (resolveAlias) {
            return typeManager.registerType(typeManager.resolvePossibleTypedef(finalType));
        }
        return finalType;
    }
}

