/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph;

import de.fraunhofer.aisec.cpg.graph.Expression;
import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.InitializerListExpression;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.ValueDeclaration;
import de.fraunhofer.aisec.cpg.graph.type.Type;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;

public class VariableDeclaration
extends ValueDeclaration
implements HasType.TypeListener {
    @SubGraph(value={"AST"})
    protected @Nullable Expression initializer;
    private boolean implicitInitializerAllowed = false;
    private boolean isArray = false;

    public boolean isImplicitInitializerAllowed() {
        return this.implicitInitializerAllowed;
    }

    public void setImplicitInitializerAllowed(boolean implicitInitializerAllowed) {
        this.implicitInitializerAllowed = implicitInitializerAllowed;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public void setIsArray(boolean isArray) {
        this.isArray = isArray;
    }

    public @Nullable Expression getInitializer() {
        return this.initializer;
    }

    public <T> @Nullable T getInitializerAs(Class<T> clazz) {
        return clazz.cast(this.getInitializer());
    }

    public void setInitializer(@Nullable Expression initializer) {
        if (this.initializer != null) {
            this.removePrevDFG(this.initializer);
            this.initializer.unregisterTypeListener(this);
            if (this.initializer instanceof HasType.TypeListener) {
                this.unregisterTypeListener((HasType.TypeListener)((Object)this.initializer));
            }
        }
        this.initializer = initializer;
        if (initializer != null) {
            this.addPrevDFG(initializer);
            initializer.registerTypeListener(this);
            if (initializer instanceof HasType.TypeListener) {
                this.registerTypeListener((HasType.TypeListener)((Object)initializer));
            }
        }
    }

    @Override
    public void typeChanged(HasType src, HasType root, Type oldType) {
        Type newType;
        if (!TypeManager.getInstance().isUnknown(this.type) && src.getPropagationType().equals(oldType)) {
            return;
        }
        Type previous = this.type;
        if (src == this.initializer && this.initializer instanceof InitializerListExpression) {
            if (this.isArray) {
                newType = src.getType();
            } else {
                if (!TypeManager.getInstance().isUnknown(this.type)) {
                    return;
                }
                newType = src.getType().dereference();
            }
        } else {
            newType = src.getPropagationType();
        }
        this.setType(newType, root);
        if (!previous.equals(this.type)) {
            this.type.setTypeOrigin(Type.Origin.DATAFLOW);
        }
    }

    @Override
    public void possibleSubTypesChanged(HasType src, HasType root, Set<Type> oldSubTypes) {
        HashSet<Type> subTypes = new HashSet<Type>(this.getPossibleSubTypes());
        subTypes.addAll(src.getPossibleSubTypes());
        this.setPossibleSubTypes(subTypes, root);
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, Node.TO_STRING_STYLE).append("name", this.name).append("location", this.location).append("initializer", this.initializer).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VariableDeclaration)) {
            return false;
        }
        VariableDeclaration that = (VariableDeclaration)o;
        return super.equals(that) && Objects.equals(this.initializer, that.initializer);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

