/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph;

import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.java.JavaLanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.NodeBuilder;
import de.fraunhofer.aisec.cpg.graph.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.TypedefDeclaration;
import de.fraunhofer.aisec.cpg.graph.type.PointerType;
import de.fraunhofer.aisec.cpg.graph.type.ReferenceType;
import de.fraunhofer.aisec.cpg.graph.type.SecondOrderType;
import de.fraunhofer.aisec.cpg.graph.type.Type;
import de.fraunhofer.aisec.cpg.graph.type.TypeParser;
import de.fraunhofer.aisec.cpg.graph.type.UnknownType;
import de.fraunhofer.aisec.cpg.graph.type.WrapState;
import de.fraunhofer.aisec.cpg.helpers.Util;
import de.fraunhofer.aisec.cpg.passes.scopes.RecordScope;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeManager {
    private static final Logger log = LoggerFactory.getLogger(TypeManager.class);
    private static final List<String> primitiveTypeNames = List.of("byte", "short", "int", "long", "float", "double", "boolean", "char");
    private static final Pattern funPointerPattern = Pattern.compile("\\(?\\*(?<alias>[^()]+)\\)?\\(.*\\)");
    private static @NonNull TypeManager INSTANCE = new TypeManager();
    private @NonNull Map<String, RecordDeclaration> typeToRecord = new HashMap<String, RecordDeclaration>();
    private @NonNull Map<Type, List<Type>> typeState = new HashMap<Type, List<Type>>();
    private Set<Type> firstOrderTypes = new HashSet<Type>();
    private Set<Type> secondOrderTypes = new HashSet<Type>();
    private LanguageFrontend frontend;
    private boolean noFrontendWarningIssued = false;

    public static void reset() {
        INSTANCE = new TypeManager();
    }

    public @NonNull Map<Type, List<Type>> getTypeState() {
        return this.typeState;
    }

    public <T extends Type> T registerType(T t) {
        if (t.isFirstOrderType()) {
            this.firstOrderTypes.add(t);
        } else {
            this.secondOrderTypes.add(t);
            this.registerType(((SecondOrderType)((Object)t)).getElementType());
        }
        return t;
    }

    public Set<Type> getFirstOrderTypes() {
        return this.firstOrderTypes;
    }

    public Set<Type> getSecondOrderTypes() {
        return this.secondOrderTypes;
    }

    private TypeManager() {
    }

    public static TypeManager getInstance() {
        return INSTANCE;
    }

    public void setLanguageFrontend(@NonNull LanguageFrontend frontend) {
        this.frontend = frontend;
    }

    public boolean isPrimitive(Type type) {
        return primitiveTypeNames.contains(type.getTypeName());
    }

    public boolean isUnknown(Type type) {
        return type instanceof UnknownType;
    }

    private Optional<Type> rewrapType(Type type, int depth, PointerType.PointerOrigin pointerOrigin, boolean reference, ReferenceType referenceType) {
        if (depth > 0) {
            for (int i = 0; i < depth; ++i) {
                type = type.reference(pointerOrigin);
            }
        }
        if (reference) {
            referenceType.setElementType(type);
            return Optional.of(referenceType);
        }
        return Optional.of(type);
    }

    private Set<Type> unwrapTypes(Collection<Type> types, WrapState wrapState) {
        Type t2;
        HashSet<Type> original = new HashSet<Type>(types);
        HashSet<Type> unwrappedTypes = new HashSet<Type>();
        int depth = 0;
        int counter = 0;
        boolean reference = false;
        PointerType.PointerOrigin pointerOrigin = null;
        ReferenceType referenceType = null;
        Type t1 = types.stream().findAny().orElse(null);
        if (t1 instanceof ReferenceType) {
            for (Type t : types) {
                referenceType = (ReferenceType)t;
                if (!referenceType.isSimilar(t)) {
                    return Collections.emptySet();
                }
                unwrappedTypes.add(((ReferenceType)t).getElementType());
                reference = true;
            }
            types = unwrappedTypes;
        }
        if ((t2 = (Type)types.stream().findAny().orElse(null)) instanceof PointerType) {
            for (Type t : types) {
                if (counter == 0) {
                    depth = t.getReferenceDepth();
                    ++counter;
                }
                if (t.getReferenceDepth() != depth) {
                    return Collections.emptySet();
                }
                unwrappedTypes.add(t.getRoot());
                pointerOrigin = ((PointerType)t).getPointerOrigin();
            }
        }
        wrapState.setDepth(depth);
        wrapState.setPointerOrigin(pointerOrigin);
        wrapState.setReference(reference);
        wrapState.setReferenceType(referenceType);
        if (unwrappedTypes.isEmpty() && !original.isEmpty()) {
            return original;
        }
        return unwrappedTypes;
    }

    public @NonNull Optional<Type> getCommonType(@NonNull Collection<Type> types) {
        boolean sameType;
        boolean bl = sameType = types.stream().map(t -> t.getClass().getCanonicalName()).collect(Collectors.toSet()).size() == 1;
        if (!sameType) {
            return Optional.empty();
        }
        WrapState wrapState = new WrapState();
        if ((types = this.unwrapTypes(types, wrapState)).isEmpty()) {
            return Optional.empty();
        }
        if (types.size() == 1) {
            return this.rewrapType(types.iterator().next(), wrapState.getDepth(), wrapState.getPointerOrigin(), wrapState.isReference(), wrapState.getReferenceType());
        }
        this.typeToRecord = this.frontend.getScopeManager().getUniqueScopesThat(RecordScope.class::isInstance, s2 -> s2.getAstNode().getName()).stream().map(s2 -> (RecordDeclaration)s2.getAstNode()).collect(Collectors.toMap(Node::getName, Function.identity()));
        List allAncestors = types.stream().map(t -> this.typeToRecord.getOrDefault(t.getTypeName(), null)).filter(Objects::nonNull).map(r -> this.getAncestors((RecordDeclaration)r, 0)).collect(Collectors.toList());
        for (Set ancestors : allAncestors) {
            Optional<Ancestor> farthest = ancestors.stream().max(Comparator.comparingInt(Ancestor::getDepth));
            if (!farthest.isPresent()) continue;
            int maxDepth = farthest.get().getDepth();
            ancestors.forEach(a -> a.setDepth(maxDepth - a.getDepth()));
        }
        HashSet commonAncestors = new HashSet();
        for (int i = 0; i < allAncestors.size(); ++i) {
            if (i == 0) {
                commonAncestors.addAll((Collection)allAncestors.get(i));
                continue;
            }
            Set others = (Set)allAncestors.get(i);
            HashSet newCommonAncestors = new HashSet();
            for (Ancestor curr : commonAncestors) {
                Optional<Ancestor> toRetain = others.stream().filter(a -> a.equals(curr)).map(a -> curr.getDepth() >= a.getDepth() ? curr : a).findFirst();
                toRetain.ifPresent(newCommonAncestors::add);
            }
            commonAncestors = newCommonAncestors;
        }
        Optional<Ancestor> lca = commonAncestors.stream().max(Comparator.comparingInt(Ancestor::getDepth));
        Optional<Type> commonType = lca.map(a -> TypeParser.createFrom(a.getRecord().getName(), true));
        if (!commonType.isPresent()) {
            return commonType;
        }
        Type finalType = commonType.get();
        return this.rewrapType(finalType, wrapState.getDepth(), wrapState.getPointerOrigin(), wrapState.isReference(), wrapState.getReferenceType());
    }

    private Set<Ancestor> getAncestors(RecordDeclaration record, int depth) {
        if (record.getSuperTypes().isEmpty()) {
            HashSet<Ancestor> ret = new HashSet<Ancestor>();
            ret.add(new Ancestor(record, depth));
            return ret;
        }
        Set<Ancestor> ancestors = record.getSuperTypes().stream().map(s2 -> this.typeToRecord.getOrDefault(s2.getTypeName(), null)).filter(Objects::nonNull).map(s2 -> this.getAncestors((RecordDeclaration)s2, depth + 1)).flatMap(Collection::stream).collect(Collectors.toSet());
        ancestors.add(new Ancestor(record, depth));
        return ancestors;
    }

    public @NonNull Language getLanguage() {
        if (this.frontend instanceof JavaLanguageFrontend) {
            return Language.JAVA;
        }
        return Language.CXX;
    }

    public @Nullable LanguageFrontend getFrontend() {
        return this.frontend;
    }

    public boolean isSupertypeOf(Type superType, Type subType) {
        if (superType.getReferenceDepth() != subType.getReferenceDepth()) {
            return false;
        }
        if (this.checkArrayAndPointer(superType, subType)) {
            return true;
        }
        Optional<Type> commonType = this.getCommonType(new HashSet<Type>(List.of(superType, subType)));
        if (commonType.isPresent()) {
            return commonType.get().equals(superType);
        }
        try {
            Class<?> superCls = Class.forName(superType.getTypeName());
            Class<?> subCls = Class.forName(subType.getTypeName());
            return superCls.isAssignableFrom(subCls);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public boolean checkArrayAndPointer(Type first, Type second) {
        int secondDepth;
        int firstDepth = first.getReferenceDepth();
        if (firstDepth == (secondDepth = second.getReferenceDepth())) {
            return first.getTypeName().equals(second.getTypeName()) && first.isSimilar(second);
        }
        return false;
    }

    public void cleanup() {
        this.frontend = null;
        this.typeToRecord.clear();
    }

    private Type getTargetType(Type currTarget, String alias) {
        if (alias.contains("(") && alias.contains("*")) {
            return TypeParser.createFrom(currTarget.getName() + " " + alias, true);
        }
        if (alias.endsWith("]")) {
            return currTarget.reference(PointerType.PointerOrigin.ARRAY);
        }
        if (alias.contains("*")) {
            int depth = StringUtils.countMatches((CharSequence)alias, '*');
            for (int i = 0; i < depth; ++i) {
                currTarget = currTarget.reference(PointerType.PointerOrigin.POINTER);
            }
            return currTarget;
        }
        return currTarget;
    }

    private Type getAlias(String alias) {
        if (alias.contains("(") && alias.contains("*")) {
            Matcher matcher = funPointerPattern.matcher(alias);
            if (matcher.find()) {
                return TypeParser.createIgnoringAlias(matcher.group("alias"));
            }
            log.error("Could not find alias name in function pointer typedef: {}", (Object)alias);
            return TypeParser.createIgnoringAlias(alias);
        }
        alias = alias.split("\\[")[0];
        alias = alias.replace("*", "");
        return TypeParser.createIgnoringAlias(alias);
    }

    public void handleTypedef(String rawCode) {
        String cleaned = rawCode.replaceAll("(typedef|;)", "").strip();
        if (cleaned.startsWith("struct")) {
            this.handleStructTypedef(rawCode, cleaned);
        } else if (Util.containsOnOuterLevel(cleaned, ',')) {
            this.handleMultipleAliases(rawCode, cleaned);
        } else {
            List<String> parts = Util.splitLeavingParenthesisContents(cleaned, " \r\n");
            if (parts.size() < 2) {
                log.error("Typedef contains no whitespace to split on: {}", (Object)rawCode);
                return;
            }
            Type target = TypeParser.createFrom(Util.removeRedundantParentheses(String.join((CharSequence)" ", parts.subList(0, parts.size() - 1))), true);
            this.handleSingleAlias(rawCode, target, parts.get(parts.size() - 1));
        }
    }

    private void handleMultipleAliases(String rawCode, String cleaned) {
        List<String> parts = Util.splitLeavingParenthesisContents(cleaned, ",");
        String[] splitFirst = parts.get(0).split("\\s+");
        if (splitFirst.length < 2) {
            log.error("Cannot find out target type for {}", (Object)rawCode);
            return;
        }
        Type target = TypeParser.createFrom(splitFirst[0], true);
        parts.set(0, parts.get(0).substring(splitFirst[0].length()).strip());
        for (String part : parts) {
            this.handleSingleAlias(rawCode, target, part);
        }
    }

    private void handleStructTypedef(String rawCode, String cleaned) {
        int endOfStruct = cleaned.lastIndexOf(125);
        if (endOfStruct + 1 < cleaned.length()) {
            List<String> parts = Util.splitLeavingParenthesisContents(cleaned.substring(endOfStruct + 1), ",");
            Optional<String> name = parts.stream().filter(p -> !p.contains("*") && !p.contains("[")).findFirst();
            if (name.isPresent()) {
                Type target = TypeParser.createIgnoringAlias(name.get());
                for (String part : parts) {
                    if (part.equals(name.get())) continue;
                    this.handleSingleAlias(rawCode, target, part);
                }
            } else {
                log.error("Could not identify struct name: {}", (Object)rawCode);
            }
        } else {
            log.error("No alias found for struct typedef: {}", (Object)rawCode);
        }
    }

    public void handleSingleAlias(String rawCode, Type target, String aliasString) {
        String cleanedPart = Util.removeRedundantParentheses(aliasString);
        Type currTarget = this.getTargetType(target, cleanedPart);
        Type alias = this.getAlias(cleanedPart);
        if (alias instanceof SecondOrderType) {
            Type chain = alias.duplicate();
            chain.setRoot(currTarget);
            currTarget = chain;
            currTarget.refreshNames();
            alias = alias.getRoot();
        }
        TypedefDeclaration typedef = NodeBuilder.newTypedefDeclaration(currTarget, alias, rawCode);
        this.frontend.getScopeManager().addTypedef(typedef);
    }

    public Type resolvePossibleTypedef(Type alias) {
        Type toCheck;
        if (this.frontend == null) {
            if (!this.noFrontendWarningIssued) {
                log.warn("No frontend available. Be aware that typedef resolving cannot currently be done");
                this.noFrontendWarningIssued = true;
            }
            return alias;
        }
        Type finalToCheck = toCheck = alias.getRoot();
        Optional<Type> applicable = this.frontend.getScopeManager().getCurrentTypedefs().stream().filter(t -> t.getAlias().getRoot().equals(finalToCheck)).findAny().map(TypedefDeclaration::getType);
        if (applicable.isEmpty()) {
            return alias;
        }
        return TypeParser.reWrapType(alias, applicable.get());
    }

    private static class Ancestor {
        private RecordDeclaration record;
        private int depth;

        public Ancestor(RecordDeclaration record, int depth) {
            this.record = record;
            this.depth = depth;
        }

        public RecordDeclaration getRecord() {
            return this.record;
        }

        public int getDepth() {
            return this.depth;
        }

        public void setDepth(int depth) {
            this.depth = depth;
        }

        public int hashCode() {
            return Objects.hash(this.record);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Ancestor)) {
                return false;
            }
            Ancestor ancestor = (Ancestor)o;
            return Objects.equals(this.record, ancestor.record);
        }

        public String toString() {
            return new ToStringBuilder(this, Node.TO_STRING_STYLE).append("record", this.record.getName()).append("depth", this.depth).toString();
        }
    }

    public static enum Language {
        JAVA,
        CXX;

    }
}

