/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph;

import de.fraunhofer.aisec.cpg.graph.ConstructorDeclaration;
import de.fraunhofer.aisec.cpg.graph.Declaration;
import de.fraunhofer.aisec.cpg.graph.FieldDeclaration;
import de.fraunhofer.aisec.cpg.graph.MethodDeclaration;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.ValueDeclaration;
import de.fraunhofer.aisec.cpg.graph.type.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.annotation.Transient;

public class RecordDeclaration
extends Declaration {
    private String kind;
    @SubGraph(value={"AST"})
    private List<FieldDeclaration> fields = new ArrayList<FieldDeclaration>();
    @SubGraph(value={"AST"})
    private List<MethodDeclaration> methods = new ArrayList<MethodDeclaration>();
    @SubGraph(value={"AST"})
    private List<ConstructorDeclaration> constructors = new ArrayList<ConstructorDeclaration>();
    @SubGraph(value={"AST"})
    private List<RecordDeclaration> records = new ArrayList<RecordDeclaration>();
    @Transient
    private List<Type> superClasses = new ArrayList<Type>();
    @Transient
    private List<Type> implementedInterfaces = new ArrayList<Type>();
    @Relationship
    private Set<RecordDeclaration> superTypeDeclarations = new HashSet<RecordDeclaration>();
    private List<String> importStatements = new ArrayList<String>();
    @Relationship
    private Set<Declaration> imports = new HashSet<Declaration>();
    private List<String> staticImportStatements = new ArrayList<String>();
    @Relationship
    private Set<ValueDeclaration> staticImports = new HashSet<ValueDeclaration>();

    @Override
    public void setName(@NonNull String name) {
        super.setName(name);
        for (ConstructorDeclaration constructor : this.constructors) {
            constructor.setName(name);
        }
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public List<FieldDeclaration> getFields() {
        return this.fields;
    }

    public @Nullable FieldDeclaration getField(String name) {
        return this.fields.stream().filter(f -> f.name.equals(name)).findFirst().orElse(null);
    }

    public void setFields(List<FieldDeclaration> fields) {
        this.fields = fields;
    }

    public FieldDeclaration getThis() {
        return this.fields.stream().filter(f -> f.getName().equals("this")).findFirst().orElse(null);
    }

    public List<MethodDeclaration> getMethods() {
        return this.methods;
    }

    public void setMethods(List<MethodDeclaration> methods) {
        this.methods = methods;
    }

    public List<ConstructorDeclaration> getConstructors() {
        return this.constructors;
    }

    public void setConstructors(List<ConstructorDeclaration> constructors) {
        this.constructors = constructors;
    }

    public List<RecordDeclaration> getRecords() {
        return this.records;
    }

    public void setRecords(List<RecordDeclaration> records) {
        this.records = records;
    }

    public List<Type> getSuperTypes() {
        return Stream.of(this.superClasses, this.implementedInterfaces).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<Type> getSuperClasses() {
        return this.superClasses;
    }

    public void setSuperClasses(List<Type> superClasses) {
        this.superClasses = superClasses;
    }

    public List<Type> getImplementedInterfaces() {
        return this.implementedInterfaces;
    }

    public void setImplementedInterfaces(List<Type> implementedInterfaces) {
        this.implementedInterfaces = implementedInterfaces;
    }

    public Set<RecordDeclaration> getSuperTypeDeclarations() {
        return this.superTypeDeclarations;
    }

    public void setSuperTypeDeclarations(Set<RecordDeclaration> superTypeDeclarations) {
        this.superTypeDeclarations = superTypeDeclarations;
    }

    public Set<Declaration> getImports() {
        return this.imports;
    }

    public void setImports(Set<Declaration> imports) {
        this.imports = imports;
    }

    public Set<ValueDeclaration> getStaticImports() {
        return this.staticImports;
    }

    public void setStaticImports(Set<ValueDeclaration> staticImports) {
        this.staticImports = staticImports;
    }

    public List<String> getImportStatements() {
        return this.importStatements;
    }

    public void setImportStatements(List<String> importStatements) {
        this.importStatements = importStatements;
    }

    public List<String> getStaticImportStatements() {
        return this.staticImportStatements;
    }

    public void setStaticImportStatements(List<String> staticImportStatements) {
        this.staticImportStatements = staticImportStatements;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, Node.TO_STRING_STYLE).appendSuper(super.toString()).append("name", this.name).append("kind", this.kind).append("superTypeDeclarations", this.superTypeDeclarations).append("fields", this.fields).append("methods", this.methods).append("constructors", this.constructors).append("records", this.records).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RecordDeclaration)) {
            return false;
        }
        RecordDeclaration that = (RecordDeclaration)o;
        return super.equals(that) && Objects.equals(this.kind, that.kind) && Objects.equals(this.fields, that.fields) && Objects.equals(this.methods, that.methods) && Objects.equals(this.constructors, that.constructors) && Objects.equals(this.records, that.records) && Objects.equals(this.superClasses, that.superClasses) && Objects.equals(this.implementedInterfaces, that.implementedInterfaces) && Objects.equals(this.superTypeDeclarations, that.superTypeDeclarations);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

