/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph;

import de.fraunhofer.aisec.cpg.graph.AccessValues;
import de.fraunhofer.aisec.cpg.graph.Expression;
import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.type.Type;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.checkerframework.checker.nullness.qual.NonNull;

public class MemberExpression
extends Expression
implements HasType.TypeListener {
    @SubGraph(value={"AST"})
    protected Node member;
    @SubGraph(value={"AST"})
    private @NonNull Node base;
    private AccessValues access = AccessValues.READ;

    public @NonNull Node getBase() {
        return this.base;
    }

    public void setBase(@NonNull Node base) {
        this.base = base;
    }

    public Node getMember() {
        return this.member;
    }

    public void setMember(Node member) {
        if (this.member instanceof HasType.TypeListener) {
            this.unregisterTypeListener((HasType.TypeListener)((Object)this.member));
        }
        if (this.member instanceof HasType) {
            ((HasType)((Object)this.member)).unregisterTypeListener(this);
        }
        if (this.access == AccessValues.WRITE) {
            this.removeNextDFG(this.member);
        } else if (this.access == AccessValues.READ) {
            this.removePrevDFG(this.member);
        } else {
            this.removeNextDFG(this.member);
            this.removePrevDFG(this.member);
        }
        this.member = member;
        if (member instanceof HasType) {
            ((HasType)((Object)member)).registerTypeListener(this);
        }
        if (member instanceof HasType.TypeListener) {
            this.registerTypeListener((HasType.TypeListener)((Object)member));
        }
        if (this.access == AccessValues.WRITE) {
            this.addNextDFG(this.member);
        } else if (this.access == AccessValues.READ) {
            this.addPrevDFG(this.member);
        } else {
            this.addNextDFG(this.member);
            this.addPrevDFG(this.member);
        }
    }

    @Override
    public void typeChanged(HasType src, HasType root, Type oldType) {
        Type previous = this.type;
        this.setType(src.getPropagationType(), root);
        if (!previous.equals(this.type)) {
            this.type.setTypeOrigin(Type.Origin.DATAFLOW);
        }
    }

    @Override
    public void possibleSubTypesChanged(HasType src, HasType root, Set<Type> oldSubTypes) {
        HashSet<Type> subTypes = new HashSet<Type>(this.getPossibleSubTypes());
        subTypes.addAll(src.getPossibleSubTypes());
        this.setPossibleSubTypes(subTypes, root);
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, Node.TO_STRING_STYLE).appendSuper(super.toString()).append("base", this.base.getName()).append("member", this.member).toString();
    }

    public void setAccess(AccessValues access) {
        if (this.access == AccessValues.WRITE) {
            this.removeNextDFG(this.member);
        } else if (this.access == AccessValues.READ) {
            this.removePrevDFG(this.member);
        } else {
            this.removeNextDFG(this.member);
            this.removePrevDFG(this.member);
        }
        this.access = access;
        if (this.access == AccessValues.WRITE) {
            this.addNextDFG(this.member);
        } else if (this.access == AccessValues.READ) {
            this.addPrevDFG(this.member);
        } else {
            this.addNextDFG(this.member);
            this.addPrevDFG(this.member);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MemberExpression)) {
            return false;
        }
        MemberExpression that = (MemberExpression)o;
        return super.equals(that) && Objects.equals(this.member, that.member) && Objects.equals(this.base, that.base);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

