/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph;

import de.fraunhofer.aisec.cpg.graph.CompoundStatement;
import de.fraunhofer.aisec.cpg.graph.DeclarationStatement;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.ParamVariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.ReturnStatement;
import de.fraunhofer.aisec.cpg.graph.Statement;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.ValueDeclaration;
import de.fraunhofer.aisec.cpg.graph.VariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.type.Type;
import de.fraunhofer.aisec.cpg.graph.type.UnknownType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.neo4j.ogm.annotation.Relationship;

public class FunctionDeclaration
extends ValueDeclaration {
    private static final String WHITESPACE = " ";
    private static final String BRACKET_LEFT = "(";
    private static final String COMMA = ",";
    private static final String BRACKET_RIGHT = ")";
    @SubGraph(value={"AST"})
    protected Statement body;
    @SubGraph(value={"AST"})
    protected List<ParamVariableDeclaration> parameters = new ArrayList<ParamVariableDeclaration>();
    protected List<Type> throwsTypes = new ArrayList<Type>();
    @Relationship(value="OVERRIDES", direction="INCOMING")
    private List<FunctionDeclaration> overriddenBy = new ArrayList<FunctionDeclaration>();
    @Relationship(value="OVERRIDES", direction="OUTGOING")
    private List<FunctionDeclaration> overrides = new ArrayList<FunctionDeclaration>();
    private boolean isDefinition;
    @Relationship(value="DEFINES")
    private FunctionDeclaration definition;

    public boolean hasBody() {
        return this.body != null;
    }

    public String getSignature() {
        return this.name + BRACKET_LEFT + this.parameters.stream().map(x -> x.getType().getTypeName()).collect(Collectors.joining(", ")) + BRACKET_RIGHT + ((Type)Objects.requireNonNullElse(this.type, UnknownType.getUnknownType())).getTypeName();
    }

    public boolean hasSignature(List<Type> targetSignature) {
        List signature = this.parameters.stream().sorted(Comparator.comparingInt(Node::getArgumentIndex)).collect(Collectors.toList());
        if (targetSignature.size() < signature.size()) {
            return false;
        }
        for (int i = 0; i < signature.size(); ++i) {
            ParamVariableDeclaration declared = (ParamVariableDeclaration)signature.get(i);
            if (declared.isVariadic() && targetSignature.size() >= signature.size()) {
                return true;
            }
            Type provided = targetSignature.get(i);
            if (TypeManager.getInstance().isSupertypeOf(declared.getType(), provided)) continue;
            return false;
        }
        return targetSignature.size() == signature.size();
    }

    public boolean isOverrideCandidate(FunctionDeclaration other) {
        return other.getName().equals(this.name) && other.getType().equals(this.type) && other.getSignature().equals(this.getSignature());
    }

    public List<FunctionDeclaration> getOverriddenBy() {
        return this.overriddenBy;
    }

    public List<FunctionDeclaration> getOverrides() {
        return this.overrides;
    }

    public List<Type> getThrowsTypes() {
        return this.throwsTypes;
    }

    public void setThrowsTypes(List<Type> throwsTypes) {
        this.throwsTypes = throwsTypes;
    }

    public Statement getBody() {
        return this.body;
    }

    public <T> @Nullable T getBodyStatementAs(int i, Class<T> clazz) {
        if (this.body instanceof CompoundStatement) {
            Statement statement = ((CompoundStatement)this.body).getStatements().get(i);
            if (statement == null) {
                return null;
            }
            return statement.getClass().isAssignableFrom(clazz) ? (T)clazz.cast(statement) : null;
        }
        return null;
    }

    public void setBody(Statement body) {
        if (this.body instanceof ReturnStatement) {
            this.removePrevDFG(this.body);
        } else if (this.body instanceof CompoundStatement) {
            ((CompoundStatement)this.body).getStatements().stream().filter(ReturnStatement.class::isInstance).forEach(this::removePrevDFG);
        }
        this.body = body;
        if (body instanceof ReturnStatement) {
            this.addPrevDFG(body);
        } else if (body instanceof CompoundStatement) {
            ((CompoundStatement)body).getStatements().stream().filter(ReturnStatement.class::isInstance).forEach(this::addPrevDFG);
        }
    }

    public List<ParamVariableDeclaration> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<ParamVariableDeclaration> parameters) {
        this.parameters = parameters;
    }

    public Optional<VariableDeclaration> getVariableDeclarationByName(String name) {
        if (this.body instanceof CompoundStatement) {
            return ((CompoundStatement)this.body).getStatements().stream().filter(statement -> statement instanceof DeclarationStatement).map(DeclarationStatement.class::cast).flatMap(declarationStatement -> declarationStatement.getDeclarations().stream()).filter(declaration -> declaration instanceof VariableDeclaration).map(VariableDeclaration.class::cast).filter(declaration -> Objects.equals(declaration.getName(), name)).findFirst();
        }
        return Optional.empty();
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, Node.TO_STRING_STYLE).appendSuper(super.toString()).append("type", this.type).append("parameters", this.parameters.stream().map(Node::getName)).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FunctionDeclaration)) {
            return false;
        }
        FunctionDeclaration that = (FunctionDeclaration)o;
        return super.equals(that) && Objects.equals(this.body, that.body) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.throwsTypes, that.throwsTypes) && Objects.equals(this.overriddenBy, that.overriddenBy) && Objects.equals(this.overrides, that.overrides);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public FunctionDeclaration getDefinition() {
        return this.isDefinition ? this : this.definition;
    }

    public boolean isDefinition() {
        return this.isDefinition;
    }

    public void setIsDefinition(boolean definition) {
        this.isDefinition = definition;
    }

    public void setDefinition(FunctionDeclaration definition) {
        this.definition = definition;
    }
}

