/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph;

import de.fraunhofer.aisec.cpg.graph.Expression;
import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.InitializerListExpression;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.ValueDeclaration;
import de.fraunhofer.aisec.cpg.graph.VariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.type.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FieldDeclaration
extends ValueDeclaration
implements HasType.TypeListener {
    @SubGraph(value={"AST"})
    private @Nullable Expression initializer;
    private boolean implicitInitializerAllowed = false;
    private boolean isArray = false;
    private List<String> modifiers = new ArrayList<String>();

    public boolean isImplicitInitializerAllowed() {
        return this.implicitInitializerAllowed;
    }

    public void setImplicitInitializerAllowed(boolean implicitInitializerAllowed) {
        this.implicitInitializerAllowed = implicitInitializerAllowed;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public void setIsArray(boolean isArray) {
        this.isArray = isArray;
    }

    public FieldDeclaration() {
    }

    private FieldDeclaration(VariableDeclaration declaration) {
        this.name = declaration.getName();
        this.code = declaration.getCode();
        this.location = declaration.getLocation();
        this.type = declaration.getType();
        this.initializer = declaration.getInitializer();
        this.annotations = declaration.getAnnotations();
    }

    public static FieldDeclaration from(VariableDeclaration declaration) {
        return new FieldDeclaration(declaration);
    }

    public @Nullable Expression getInitializer() {
        return this.initializer;
    }

    public void setInitializer(Expression initializer) {
        if (this.initializer != null) {
            this.initializer.unregisterTypeListener(this);
            this.removePrevDFG(this.initializer);
            if (this.initializer instanceof HasType.TypeListener) {
                this.unregisterTypeListener((HasType.TypeListener)((Object)this.initializer));
            }
        }
        this.initializer = initializer;
        if (initializer != null) {
            initializer.registerTypeListener(this);
            this.addPrevDFG(initializer);
            if (initializer instanceof HasType.TypeListener) {
                this.registerTypeListener((HasType.TypeListener)((Object)initializer));
            }
        }
    }

    public List<String> getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(List<String> modifiers) {
        this.modifiers = modifiers;
    }

    @Override
    public void typeChanged(HasType src, HasType root, Type oldType) {
        Type newType;
        if (!TypeManager.getInstance().isUnknown(this.type) && src.getPropagationType().equals(oldType)) {
            return;
        }
        Type previous = this.type;
        if (src == this.initializer && this.initializer instanceof InitializerListExpression) {
            if (this.isArray) {
                newType = src.getType();
            } else {
                if (!TypeManager.getInstance().isUnknown(this.type)) {
                    return;
                }
                newType = src.getType().dereference();
            }
        } else {
            newType = src.getPropagationType();
        }
        this.setType(newType, root);
        if (!previous.equals(this.type)) {
            this.type.setTypeOrigin(Type.Origin.DATAFLOW);
        }
    }

    @Override
    public void possibleSubTypesChanged(HasType src, HasType root, Set<Type> oldSubTypes) {
        HashSet<Type> subTypes = new HashSet<Type>(this.getPossibleSubTypes());
        subTypes.addAll(src.getPossibleSubTypes());
        this.setPossibleSubTypes(subTypes, root);
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, Node.TO_STRING_STYLE).appendSuper(super.toString()).append("initializer", this.initializer).append("modifiers", this.modifiers).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldDeclaration)) {
            return false;
        }
        FieldDeclaration that = (FieldDeclaration)o;
        return super.equals(that) && Objects.equals(this.initializer, that.initializer) && Objects.equals(this.modifiers, that.modifiers);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

