/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph;

import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.Statement;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.type.FunctionPointerType;
import de.fraunhofer.aisec.cpg.graph.type.ReferenceType;
import de.fraunhofer.aisec.cpg.graph.type.Type;
import de.fraunhofer.aisec.cpg.graph.type.UnknownType;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.neo4j.ogm.annotation.Transient;

public class Expression
extends Statement
implements HasType {
    protected Type type = UnknownType.getUnknownType();
    @Transient
    private Set<HasType.TypeListener> typeListeners = new HashSet<HasType.TypeListener>();
    private Set<Type> possibleSubTypes = new HashSet<Type>();

    @Override
    public Type getType() {
        return this.type != null ? this.type : UnknownType.getUnknownType();
    }

    @Override
    public Type getPropagationType() {
        if (this.type instanceof ReferenceType) {
            return ((ReferenceType)this.type).getElementType();
        }
        return this.getType();
    }

    @Override
    public void updateType(Type type) {
        this.type = type;
    }

    @Override
    public void updatePossibleSubtypes(Set<Type> types) {
        this.possibleSubTypes = types;
    }

    @Override
    public void setType(Type type, HasType root) {
        if (type == null || root == this) {
            return;
        }
        if (this.type instanceof FunctionPointerType && !(type instanceof FunctionPointerType)) {
            return;
        }
        Type oldType = this.type;
        if (TypeManager.getInstance().isUnknown(type)) {
            return;
        }
        Set<Type> subTypes = new HashSet<Type>();
        for (Type t : this.getPossibleSubTypes()) {
            if (t.isSimilar(type)) continue;
            subTypes.add(t);
        }
        subTypes.add(type);
        this.type = TypeManager.getInstance().registerType(TypeManager.getInstance().getCommonType(subTypes).orElse(type));
        subTypes = subTypes.stream().filter(s2 -> TypeManager.getInstance().isSupertypeOf(this.type, (Type)s2)).collect(Collectors.toSet());
        subTypes = subTypes.stream().map(s2 -> TypeManager.getInstance().registerType(s2)).collect(Collectors.toSet());
        this.setPossibleSubTypes(subTypes);
        if (!Objects.equals(oldType, type)) {
            this.typeListeners.stream().filter(l -> !l.equals(this)).forEach(l -> l.typeChanged(this, root == null ? this : root, oldType));
        }
    }

    @Override
    public Set<Type> getPossibleSubTypes() {
        return this.possibleSubTypes;
    }

    @Override
    public void setPossibleSubTypes(Set<Type> possibleSubTypes, HasType root) {
        if (root == this) {
            return;
        }
        if (possibleSubTypes.stream().allMatch(TypeManager.getInstance()::isPrimitive) && !this.possibleSubTypes.isEmpty()) {
            return;
        }
        Set<Type> oldSubTypes = this.possibleSubTypes;
        this.possibleSubTypes = new HashSet<Type>(possibleSubTypes);
        if (!this.getPossibleSubTypes().equals(oldSubTypes)) {
            this.typeListeners.stream().filter(l -> !l.equals(this)).forEach(l -> l.possibleSubTypesChanged(this, root == null ? this : root, oldSubTypes));
        }
    }

    @Override
    public void resetTypes(Type type) {
        HashSet<Type> oldSubTypes = new HashSet<Type>(this.getPossibleSubTypes());
        Type oldType = this.type;
        this.type = type;
        this.possibleSubTypes = new HashSet<Type>();
        if (!Objects.equals(oldType, type)) {
            this.typeListeners.stream().filter(l -> !l.equals(this)).forEach(l -> l.typeChanged(this, this, oldType));
        }
        if (oldSubTypes.size() != 1 || !oldSubTypes.contains(type)) {
            this.typeListeners.stream().filter(l -> !l.equals(this)).forEach(l -> l.possibleSubTypesChanged(this, this, oldSubTypes));
        }
    }

    @Override
    public void registerTypeListener(HasType.TypeListener listener) {
        this.typeListeners.add(listener);
        listener.typeChanged(this, this, this.type);
        listener.possibleSubTypesChanged(this, this, this.possibleSubTypes);
    }

    @Override
    public void unregisterTypeListener(HasType.TypeListener listener) {
        this.typeListeners.remove(listener);
    }

    @Override
    public Set<HasType.TypeListener> getTypeListeners() {
        return this.typeListeners;
    }

    @Override
    public void refreshType() {
        this.typeListeners.forEach(l -> {
            l.typeChanged(this, this, this.type);
            l.possibleSubTypesChanged(this, this, this.possibleSubTypes);
        });
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, Node.TO_STRING_STYLE).appendSuper(super.toString()).append("type", this.type).append("possibleSubTypes", this.possibleSubTypes).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Expression)) {
            return false;
        }
        Expression that = (Expression)o;
        return super.equals(that) && Objects.equals(this.type, that.type) && Objects.equals(this.possibleSubTypes, that.possibleSubTypes);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

