/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph;

import de.fraunhofer.aisec.cpg.graph.AccessValues;
import de.fraunhofer.aisec.cpg.graph.Expression;
import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.ValueDeclaration;
import de.fraunhofer.aisec.cpg.graph.type.Type;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DeclaredReferenceExpression
extends Expression
implements HasType.TypeListener {
    private Set<ValueDeclaration> refersTo = new HashSet<ValueDeclaration>();
    private AccessValues access = AccessValues.READ;

    public Set<ValueDeclaration> getRefersTo() {
        return this.refersTo;
    }

    public void setRefersTo(@NonNull ValueDeclaration refersTo) {
        HashSet<ValueDeclaration> n = new HashSet<ValueDeclaration>();
        n.add(refersTo);
        this.setRefersTo(n);
    }

    public void setRefersTo(@NonNull Set<ValueDeclaration> refersTo) {
        this.refersTo.forEach(r -> {
            if (this.access == AccessValues.WRITE) {
                this.removeNextDFG((Node)r);
            } else if (this.access == AccessValues.READ) {
                this.removePrevDFG((Node)r);
            } else {
                this.removeNextDFG((Node)r);
                this.removePrevDFG((Node)r);
            }
            r.unregisterTypeListener(this);
            if (r instanceof HasType.TypeListener) {
                this.unregisterTypeListener((HasType.TypeListener)((Object)r));
            }
        });
        this.refersTo.clear();
        this.refersTo.addAll(refersTo);
        refersTo.forEach(r -> {
            if (this.access == AccessValues.WRITE) {
                this.addNextDFG((Node)r);
            } else if (this.access == AccessValues.READ) {
                this.addPrevDFG((Node)r);
            } else {
                this.addNextDFG((Node)r);
                this.addPrevDFG((Node)r);
            }
            r.registerTypeListener(this);
            if (r instanceof HasType.TypeListener) {
                this.registerTypeListener((HasType.TypeListener)((Object)r));
            }
        });
    }

    @Override
    public void typeChanged(HasType src, HasType root, Type oldType) {
        Type previous = this.type;
        this.setType(src.getPropagationType(), root);
        if (!previous.equals(this.type)) {
            this.type.setTypeOrigin(Type.Origin.DATAFLOW);
        }
    }

    @Override
    public void possibleSubTypesChanged(HasType src, HasType root, Set<Type> oldSubTypes) {
        HashSet<Type> subTypes = new HashSet<Type>(this.getPossibleSubTypes());
        subTypes.addAll(src.getPossibleSubTypes());
        this.setPossibleSubTypes(subTypes, root);
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, Node.TO_STRING_STYLE).append("name", this.name).append("type", this.type).append("location", this.location).append("refersTo", this.refersTo).toString();
    }

    public void setAccess(AccessValues access) {
        this.refersTo.forEach(r -> {
            if (this.access == AccessValues.WRITE) {
                this.removeNextDFG((Node)r);
            } else if (this.access == AccessValues.READ) {
                this.removePrevDFG((Node)r);
            } else {
                this.removeNextDFG((Node)r);
                this.removePrevDFG((Node)r);
            }
        });
        this.access = access;
        this.refersTo.forEach(r -> {
            if (this.access == AccessValues.WRITE) {
                this.addNextDFG((Node)r);
            } else if (this.access == AccessValues.READ) {
                this.addPrevDFG((Node)r);
            } else {
                this.addNextDFG((Node)r);
                this.addPrevDFG((Node)r);
            }
        });
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeclaredReferenceExpression)) {
            return false;
        }
        DeclaredReferenceExpression that = (DeclaredReferenceExpression)o;
        return super.equals(that) && Objects.equals(this.refersTo, that.refersTo);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

