/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph;

import de.fraunhofer.aisec.cpg.graph.Declaration;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.Statement;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class DeclarationStatement
extends Statement {
    @SubGraph(value={"AST"})
    private List<Declaration> declarations = new ArrayList<Declaration>();

    public Declaration getSingleDeclaration() {
        return this.isSingleDeclaration() ? this.declarations.get(0) : null;
    }

    public boolean isSingleDeclaration() {
        return this.declarations.size() == 1;
    }

    public void setSingleDeclaration(Declaration declaration) {
        this.declarations.clear();
        this.declarations.add(declaration);
    }

    public <T extends Declaration> T getSingleDeclarationAs(Class<T> clazz) {
        return (T)((Declaration)clazz.cast(this.getSingleDeclaration()));
    }

    public List<Declaration> getDeclarations() {
        return this.declarations;
    }

    public void setDeclarations(List<Declaration> declarations) {
        this.declarations = declarations;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, Node.TO_STRING_STYLE).appendSuper(super.toString()).append("declarations", this.declarations).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeclarationStatement)) {
            return false;
        }
        DeclarationStatement that = (DeclarationStatement)o;
        return super.equals(that) && Objects.equals(this.declarations, that.declarations);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

