/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.cpp;

import de.fraunhofer.aisec.cpg.frontends.Handler;
import de.fraunhofer.aisec.cpg.frontends.cpp.CXXLanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.ArraySubscriptionExpression;
import de.fraunhofer.aisec.cpg.graph.BinaryOperator;
import de.fraunhofer.aisec.cpg.graph.CallExpression;
import de.fraunhofer.aisec.cpg.graph.CastExpression;
import de.fraunhofer.aisec.cpg.graph.CompoundStatementExpression;
import de.fraunhofer.aisec.cpg.graph.ConditionalExpression;
import de.fraunhofer.aisec.cpg.graph.Declaration;
import de.fraunhofer.aisec.cpg.graph.DeclaredReferenceExpression;
import de.fraunhofer.aisec.cpg.graph.DeleteExpression;
import de.fraunhofer.aisec.cpg.graph.DesignatedInitializerExpression;
import de.fraunhofer.aisec.cpg.graph.Expression;
import de.fraunhofer.aisec.cpg.graph.ExpressionList;
import de.fraunhofer.aisec.cpg.graph.InitializerListExpression;
import de.fraunhofer.aisec.cpg.graph.Literal;
import de.fraunhofer.aisec.cpg.graph.MemberExpression;
import de.fraunhofer.aisec.cpg.graph.NewExpression;
import de.fraunhofer.aisec.cpg.graph.NodeBuilder;
import de.fraunhofer.aisec.cpg.graph.Statement;
import de.fraunhofer.aisec.cpg.graph.TypeIdExpression;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.UnaryOperator;
import de.fraunhofer.aisec.cpg.graph.ValueDeclaration;
import de.fraunhofer.aisec.cpg.graph.type.PointerType;
import de.fraunhofer.aisec.cpg.graph.type.SecondOrderType;
import de.fraunhofer.aisec.cpg.graph.type.Type;
import de.fraunhofer.aisec.cpg.graph.type.TypeParser;
import de.fraunhofer.aisec.cpg.graph.type.UnknownType;
import de.fraunhofer.aisec.cpg.helpers.Util;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Objects;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTImplicitDestructorName;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemType;
import org.eclipse.cdt.core.dom.ast.IQualifierType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDesignator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTInitializerClause;
import org.eclipse.cdt.internal.core.dom.parser.CStringValue;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTArrayDesignator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTArrayRangeDesignator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTArraySubscriptExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTBinaryExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTCastExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTCompoundStatementExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTConditionalExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTDeleteExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTDesignatedInitializer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTExpressionList;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFieldDesignator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFieldReference;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFunctionCallExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTIdExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTInitializerList;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTLiteralExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTNamedTypeSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTNewExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTSimpleTypeConstructorExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTTypeIdExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTUnaryExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPPointerType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPScope;

class ExpressionHandler
extends Handler<Expression, IASTInitializerClause, CXXLanguageFrontend> {
    ExpressionHandler(CXXLanguageFrontend lang) {
        super(Expression::new, lang);
        this.map.put(CPPASTLiteralExpression.class, ctx -> this.handleLiteralExpression((CPPASTLiteralExpression)ctx));
        this.map.put(CPPASTBinaryExpression.class, ctx -> this.handleBinaryExpression((CPPASTBinaryExpression)ctx));
        this.map.put(CPPASTUnaryExpression.class, ctx -> this.handleUnaryExpression((CPPASTUnaryExpression)ctx));
        this.map.put(CPPASTConditionalExpression.class, ctx -> this.handleConditionalExpression((CPPASTConditionalExpression)ctx));
        this.map.put(CPPASTIdExpression.class, ctx -> this.handleIdExpression((CPPASTIdExpression)ctx));
        this.map.put(CPPASTFieldReference.class, ctx -> this.handleFieldReference((CPPASTFieldReference)ctx));
        this.map.put(CPPASTFunctionCallExpression.class, ctx -> this.handleFunctionCallExpression((CPPASTFunctionCallExpression)ctx));
        this.map.put(CPPASTCastExpression.class, ctx -> this.handleCastExpression((CPPASTCastExpression)ctx));
        this.map.put(CPPASTSimpleTypeConstructorExpression.class, ctx -> this.handleSimpleTypeConstructorExpression((CPPASTSimpleTypeConstructorExpression)ctx));
        this.map.put(CPPASTNewExpression.class, ctx -> this.handleNewExpression((CPPASTNewExpression)ctx));
        this.map.put(CPPASTInitializerList.class, ctx -> this.handleInitializerList((CPPASTInitializerList)ctx));
        this.map.put(CPPASTDesignatedInitializer.class, ctx -> this.handleDesignatedInitializer((CPPASTDesignatedInitializer)ctx));
        this.map.put(CPPASTExpressionList.class, ctx -> this.handleExpressionList((CPPASTExpressionList)ctx));
        this.map.put(CPPASTDeleteExpression.class, ctx -> this.handleDeleteExpression((CPPASTDeleteExpression)ctx));
        this.map.put(CPPASTArraySubscriptExpression.class, ctx -> this.handleArraySubscriptExpression((CPPASTArraySubscriptExpression)ctx));
        this.map.put(CPPASTTypeIdExpression.class, ctx -> this.handleTypeIdExpression((CPPASTTypeIdExpression)ctx));
        this.map.put(CPPASTCompoundStatementExpression.class, ctx -> this.handleCompoundStatementExpression((CPPASTCompoundStatementExpression)ctx));
    }

    private IType expressionTypeProxy(ICPPASTExpression expression) {
        IType expressionType = ProblemType.UNKNOWN_FOR_EXPRESSION;
        try {
            expressionType = expression.getExpressionType();
        }
        catch (AssertionError e) {
            String codeFromRawNode = ((CXXLanguageFrontend)this.lang).getCodeFromRawNode(expression);
            Util.warnWithFileLocation(this.lang, expression, log, "Unknown Expression Type: {}", codeFromRawNode);
        }
        return expressionType;
    }

    private Expression handleCompoundStatementExpression(CPPASTCompoundStatementExpression ctx) {
        CompoundStatementExpression cse = NodeBuilder.newCompoundStatementExpression(ctx.getRawSignature());
        cse.setStatement((Statement)((CXXLanguageFrontend)this.lang).getStatementHandler().handle(ctx.getCompoundStatement()));
        return cse;
    }

    private TypeIdExpression handleTypeIdExpression(CPPASTTypeIdExpression ctx) {
        String operatorCode = "";
        Type type = UnknownType.getUnknownType();
        switch (ctx.getOperator()) {
            case 0: {
                operatorCode = "sizeof";
                type = TypeParser.createFrom("std::size_t", true);
                break;
            }
            case 1: {
                operatorCode = "typeid";
                type = TypeParser.createFrom("const std::type_info&", true);
                break;
            }
            case 2: {
                operatorCode = "alignof";
                type = TypeParser.createFrom("std::size_t", true);
                break;
            }
            case 3: {
                operatorCode = "typeof";
                break;
            }
            default: {
                log.debug("Unknown typeid operator code: {}", (Object)ctx.getOperator());
            }
        }
        Type referencedType = TypeParser.createFrom(ctx.getTypeId().getDeclSpecifier().toString(), true);
        return NodeBuilder.newTypeIdExpression(operatorCode, type, referencedType, ctx.getRawSignature());
    }

    private Expression handleArraySubscriptExpression(CPPASTArraySubscriptExpression ctx) {
        ArraySubscriptionExpression arraySubsExpression = NodeBuilder.newArraySubscriptionExpression(ctx.getRawSignature());
        arraySubsExpression.setArrayExpression((Expression)this.handle(ctx.getArrayExpression()));
        arraySubsExpression.setSubscriptExpression((Expression)this.handle(ctx.getArgument()));
        return arraySubsExpression;
    }

    private NewExpression handleNewExpression(CPPASTNewExpression ctx) {
        IASTInitializer init;
        String name = ctx.getTypeId().getDeclSpecifier().toString();
        String code = ctx.getRawSignature();
        Type t = TypeParser.createFrom(this.expressionTypeProxy(ctx).toString(), true);
        t.reference(PointerType.PointerOrigin.ARRAY);
        NewExpression newExpression = NodeBuilder.newNewExpression(code, t);
        IASTDeclSpecifier declSpecifier = ctx.getTypeId().getDeclSpecifier();
        if (declSpecifier instanceof CPPASTNamedTypeSpecifier) {
            IBinding binding = ((CPPASTNamedTypeSpecifier)declSpecifier).getName().resolveBinding();
            if (binding != null && !(binding instanceof CPPScope.CPPScopeProblem)) {
                newExpression.setType(TypeParser.createFrom(binding.getName(), true));
            } else {
                log.debug("Could not resolve binding of type {} for {}, it is probably defined somewhere externally", (Object)name, (Object)newExpression);
            }
        }
        if ((init = ctx.getInitializer()) != null) {
            newExpression.setInitializer((Expression)((CXXLanguageFrontend)this.lang).getInitializerHandler().handle(init));
        }
        return newExpression;
    }

    private ConditionalExpression handleConditionalExpression(CPPASTConditionalExpression ctx) {
        Expression condition = (Expression)this.handle(ctx.getLogicalConditionExpression());
        return NodeBuilder.newConditionalExpression(condition, ctx.getPositiveResultExpression() != null ? (Expression)this.handle(ctx.getPositiveResultExpression()) : condition, (Expression)this.handle(ctx.getNegativeResultExpression()), TypeParser.createFrom(this.expressionTypeProxy(ctx).toString(), true));
    }

    private DeleteExpression handleDeleteExpression(CPPASTDeleteExpression ctx) {
        DeleteExpression deleteExpression = NodeBuilder.newDeleteExpression(ctx.getRawSignature());
        for (IASTImplicitDestructorName name : ctx.getImplicitDestructorNames()) {
            log.debug("Implicit constructor name {}", (Object)name);
        }
        deleteExpression.setOperand((Expression)this.handle(ctx.getOperand()));
        return deleteExpression;
    }

    private Expression handleCastExpression(CPPASTCastExpression ctx) {
        CPPPointerType pointerType;
        CastExpression castExpression = NodeBuilder.newCastExpression(ctx.getRawSignature());
        castExpression.setExpression((Expression)this.handle(ctx.getOperand()));
        castExpression.setCastOperator(ctx.getOperator());
        IType iType = this.expressionTypeProxy(ctx);
        Type castType = iType instanceof CPPPointerType ? ((pointerType = (CPPPointerType)iType).getType() instanceof IProblemType ? TypeParser.createFrom(ctx.getTypeId().getDeclSpecifier().toString() + "*", true) : TypeParser.createFrom(pointerType.getType().toString() + "*", true)) : (iType instanceof IProblemType ? TypeParser.createFrom(ctx.getTypeId().getDeclSpecifier().toString(), true) : TypeParser.createFrom(this.expressionTypeProxy(ctx).toString(), true));
        castExpression.setCastType(castType);
        if (TypeManager.getInstance().isPrimitive(castExpression.getCastType()) || ctx.getOperator() == 4) {
            castExpression.setType(castExpression.getCastType());
        } else {
            castExpression.getExpression().registerTypeListener(castExpression);
        }
        return castExpression;
    }

    private Expression handleSimpleTypeConstructorExpression(CPPASTSimpleTypeConstructorExpression ctx) {
        Type castType;
        CastExpression castExpression = NodeBuilder.newCastExpression(ctx.getRawSignature());
        castExpression.setExpression((Expression)((CXXLanguageFrontend)this.lang).getInitializerHandler().handle(ctx.getInitializer()));
        castExpression.setCastOperator(0);
        if (this.expressionTypeProxy(ctx) instanceof CPPPointerType) {
            CPPPointerType pointerType = (CPPPointerType)this.expressionTypeProxy(ctx);
            castType = TypeParser.createFrom(pointerType.getType().toString() + "*", true);
        } else {
            castType = TypeParser.createFrom(this.expressionTypeProxy(ctx).toString(), true);
        }
        castExpression.setCastType(castType);
        if (TypeManager.getInstance().isPrimitive(castExpression.getCastType())) {
            castExpression.setType(castExpression.getCastType());
        } else {
            castExpression.getExpression().registerTypeListener(castExpression);
        }
        return castExpression;
    }

    private Expression handleFieldReference(CPPASTFieldReference ctx) {
        Expression base = (Expression)this.handle(ctx.getFieldOwner());
        String identifierName = ctx.getFieldName().toString();
        DeclaredReferenceExpression member = NodeBuilder.newDeclaredReferenceExpression(identifierName, UnknownType.getUnknownType(), ctx.getFieldName().getRawSignature());
        MemberExpression memberExpression = NodeBuilder.newMemberExpression(base, member, ctx.getRawSignature());
        ((CXXLanguageFrontend)this.lang).expressionRefersToDeclaration(memberExpression, ctx);
        return memberExpression;
    }

    private Expression handleUnaryExpression(CPPASTUnaryExpression ctx) {
        Expression input = null;
        if (ctx.getOperand() != null) {
            input = (Expression)this.handle(ctx.getOperand());
        }
        String operatorCode = "";
        switch (ctx.getOperator()) {
            case 0: 
            case 9: {
                operatorCode = "++";
                break;
            }
            case 1: 
            case 10: {
                operatorCode = "--";
                break;
            }
            case 2: {
                operatorCode = "+";
                break;
            }
            case 3: {
                operatorCode = "-";
                break;
            }
            case 4: {
                operatorCode = "*";
                break;
            }
            case 5: {
                operatorCode = "&";
                break;
            }
            case 6: {
                operatorCode = "~";
                break;
            }
            case 7: {
                operatorCode = "!";
                break;
            }
            case 8: {
                operatorCode = "sizeof";
                break;
            }
            case 11: {
                return input;
            }
            case 12: {
                operatorCode = "throw";
                break;
            }
            case 13: {
                operatorCode = "typeid";
                break;
            }
            case 15: {
                operatorCode = "alignof";
                break;
            }
            case 16: {
                operatorCode = "sizeof...";
                break;
            }
            case 17: {
                operatorCode = "noexcept";
                break;
            }
            case 18: {
                operatorCode = "";
                break;
            }
            default: {
                Util.errorWithFileLocation(this.lang, ctx, log, "unknown operator {}", ctx.getOperator());
            }
        }
        UnaryOperator unaryOperator = NodeBuilder.newUnaryOperator(operatorCode, ctx.isPostfixOperator(), !ctx.isPostfixOperator(), ctx.getRawSignature());
        if (input != null) {
            unaryOperator.setInput(input);
        }
        return unaryOperator;
    }

    private CallExpression handleFunctionCallExpression(CPPASTFunctionCallExpression ctx) {
        CallExpression callExpression;
        Expression reference = (Expression)this.handle(ctx.getFunctionNameExpression());
        if (reference instanceof MemberExpression) {
            Type baseType = ((Expression)((MemberExpression)reference).getBase()).getType().getRoot();
            assert (!(baseType instanceof SecondOrderType));
            String baseTypename = baseType.getTypeName();
            callExpression = NodeBuilder.newMemberCallExpression(((MemberExpression)reference).getMember().getName(), baseTypename + "." + ((MemberExpression)reference).getMember().getName(), ((MemberExpression)reference).getBase(), ((MemberExpression)reference).getMember(), ctx.getRawSignature());
        } else if (reference instanceof BinaryOperator && ((BinaryOperator)reference).getOperatorCode().equals(".")) {
            callExpression = NodeBuilder.newMemberCallExpression(reference.getCode(), "", ((BinaryOperator)reference).getLhs(), ((BinaryOperator)reference).getRhs(), reference.getCode());
        } else if (reference instanceof UnaryOperator && ((UnaryOperator)reference).getOperatorCode().equals("*")) {
            callExpression = NodeBuilder.newMemberCallExpression(reference.getCode(), "", null, ((UnaryOperator)reference).getInput(), reference.getCode());
        } else {
            String fqn = reference.getName();
            String name = fqn;
            if (name.contains("::")) {
                name = name.substring(name.lastIndexOf("::") + 2);
            }
            fqn = fqn.replace("::", ".");
            callExpression = NodeBuilder.newCallExpression(name, fqn, ctx.getRawSignature());
        }
        int i = 0;
        for (IASTInitializerClause argument : ctx.getArguments()) {
            Expression arg = (Expression)this.handle(argument);
            arg.setArgumentIndex(i);
            callExpression.getArguments().add(arg);
            ++i;
        }
        reference.disconnectFromGraph();
        return callExpression;
    }

    private DeclaredReferenceExpression handleIdExpression(CPPASTIdExpression ctx) {
        DeclaredReferenceExpression declaredReferenceExpression = NodeBuilder.newDeclaredReferenceExpression(ctx.getName().toString(), UnknownType.getUnknownType(), ctx.getRawSignature());
        if (this.expressionTypeProxy(ctx) instanceof ProblemType || this.expressionTypeProxy(ctx) instanceof IQualifierType && ((IQualifierType)this.expressionTypeProxy(ctx)).getType() instanceof ProblemType) {
            log.debug("CDT could not deduce type. Trying manually");
            IBinding binding = ctx.getName().resolveBinding();
            Declaration declaration = ((CXXLanguageFrontend)this.lang).getCachedDeclaration(binding);
            if (declaration != null) {
                if (declaration instanceof ValueDeclaration) {
                    declaredReferenceExpression.setType(((ValueDeclaration)declaration).getType());
                } else {
                    log.debug("Unknown declaration type, setting to UNKNOWN");
                    declaredReferenceExpression.setType(UnknownType.getUnknownType());
                }
            } else {
                log.debug("Could not deduce type manually, setting to UNKNOWN");
                declaredReferenceExpression.setType(UnknownType.getUnknownType());
            }
        } else {
            declaredReferenceExpression.setType(TypeParser.createFrom(this.expressionTypeProxy(ctx).toString(), true));
        }
        ((CXXLanguageFrontend)this.lang).expressionRefersToDeclaration(declaredReferenceExpression, ctx);
        return declaredReferenceExpression;
    }

    private ExpressionList handleExpressionList(CPPASTExpressionList exprList) {
        ExpressionList expressionList = NodeBuilder.newExpressionList(exprList.getRawSignature());
        for (IASTExpression expr : exprList.getExpressions()) {
            expressionList.getExpressions().add((Statement)this.handle(expr));
        }
        return expressionList;
    }

    private BinaryOperator handleBinaryExpression(CPPASTBinaryExpression ctx) {
        String operatorCode = "";
        switch (ctx.getOperator()) {
            case 1: {
                operatorCode = "*";
                break;
            }
            case 2: {
                operatorCode = "/";
                break;
            }
            case 3: {
                operatorCode = "%";
                break;
            }
            case 4: {
                operatorCode = "+";
                break;
            }
            case 5: {
                operatorCode = "-";
                break;
            }
            case 6: {
                operatorCode = "<<";
                break;
            }
            case 7: {
                operatorCode = ">>";
                break;
            }
            case 8: {
                operatorCode = "<";
                break;
            }
            case 9: {
                operatorCode = ">";
                break;
            }
            case 10: {
                operatorCode = "<=";
                break;
            }
            case 11: {
                operatorCode = ">=";
                break;
            }
            case 12: {
                operatorCode = "&";
                break;
            }
            case 13: {
                operatorCode = "^";
                break;
            }
            case 14: {
                operatorCode = "|";
                break;
            }
            case 15: {
                operatorCode = "&&";
                break;
            }
            case 16: {
                operatorCode = "||";
                break;
            }
            case 17: {
                operatorCode = "=";
                break;
            }
            case 18: {
                operatorCode = "*=";
                break;
            }
            case 19: {
                operatorCode = "/=";
                break;
            }
            case 20: {
                operatorCode = "%=";
                break;
            }
            case 21: {
                operatorCode = "+=";
                break;
            }
            case 22: {
                operatorCode = "-=";
                break;
            }
            case 23: {
                operatorCode = "<<=";
                break;
            }
            case 24: {
                operatorCode = ">>=";
                break;
            }
            case 25: {
                operatorCode = "&=";
                break;
            }
            case 26: {
                operatorCode = "^=";
                break;
            }
            case 27: {
                operatorCode = "|=";
                break;
            }
            case 28: {
                operatorCode = "==";
                break;
            }
            case 29: {
                operatorCode = "!=";
                break;
            }
            case 30: {
                operatorCode = ".";
                break;
            }
            case 31: {
                operatorCode = "->";
                break;
            }
            case 32: {
                operatorCode = ">?";
                break;
            }
            case 33: {
                operatorCode = "?<";
                break;
            }
            case 34: {
                operatorCode = "...";
                break;
            }
            default: {
                Util.errorWithFileLocation(this.lang, ctx, log, "unknown operator {}", ctx.getOperator());
            }
        }
        BinaryOperator binaryOperator = NodeBuilder.newBinaryOperator(operatorCode, ctx.getRawSignature());
        Expression lhs = (Expression)this.handle(ctx.getOperand1());
        Expression rhs = ctx.getOperand2() != null ? (Expression)this.handle(ctx.getOperand2()) : (Expression)this.handle(ctx.getInitOperand2());
        binaryOperator.setLhs(lhs);
        binaryOperator.setRhs(rhs);
        IType expressionType = this.expressionTypeProxy(ctx);
        if (expressionType == null || expressionType instanceof ProblemType || expressionType instanceof ProblemBinding) {
            log.debug("CDT could not deduce type. Type is set to null");
        } else {
            binaryOperator.setType(TypeParser.createFrom(this.expressionTypeProxy(ctx).toString(), true));
        }
        return binaryOperator;
    }

    private Literal handleLiteralExpression(CPPASTLiteralExpression ctx) {
        IType type = this.expressionTypeProxy(ctx);
        IValue value = ctx.getEvaluation().getValue();
        Type generatedType = TypeParser.createFrom(type.toString(), true);
        if (value.numberValue() == null && !(value instanceof CStringValue)) {
            return NodeBuilder.newLiteral(value.toString(), generatedType, ctx.getRawSignature());
        }
        if (type instanceof CPPBasicType && ((CPPBasicType)type).getKind() == IBasicType.Kind.eInt) {
            return this.handleIntegerLiteral(ctx);
        }
        if (type.isSameType(CPPBasicType.BOOLEAN)) {
            return NodeBuilder.newLiteral(value.numberValue().intValue() == 1, generatedType, ctx.getRawSignature());
        }
        if (value instanceof CStringValue) {
            return NodeBuilder.newLiteral(((CStringValue)value).cStringValue(), generatedType, ctx.getRawSignature());
        }
        if (type instanceof CPPBasicType && ((CPPBasicType)type).getKind() == IBasicType.Kind.eFloat) {
            return NodeBuilder.newLiteral(Float.valueOf(value.numberValue().floatValue()), generatedType, ctx.getRawSignature());
        }
        if (type instanceof CPPBasicType && ((CPPBasicType)type).getKind() == IBasicType.Kind.eDouble) {
            return NodeBuilder.newLiteral(value.numberValue().doubleValue(), generatedType, ctx.getRawSignature());
        }
        if (type instanceof CPPBasicType && ((CPPBasicType)type).getKind() == IBasicType.Kind.eChar) {
            return NodeBuilder.newLiteral(Character.valueOf((char)value.numberValue().intValue()), generatedType, ctx.getRawSignature());
        }
        return NodeBuilder.newLiteral(value.toString(), generatedType, ctx.getRawSignature());
    }

    private InitializerListExpression handleInitializerList(CPPASTInitializerList ctx) {
        InitializerListExpression expression = NodeBuilder.newInitializerListExpression(ctx.getRawSignature());
        ArrayList<Expression> initializers = new ArrayList<Expression>();
        for (ICPPASTInitializerClause clause : ctx.getClauses()) {
            initializers.add((Expression)this.handle(clause));
        }
        expression.setInitializers(initializers);
        return expression;
    }

    private DesignatedInitializerExpression handleDesignatedInitializer(CPPASTDesignatedInitializer ctx) {
        Expression rhs = (Expression)this.handle(ctx.getOperand());
        ArrayList<Expression> lhs = new ArrayList<Expression>();
        if (ctx.getDesignators().length == 0) {
            Util.errorWithFileLocation(this.lang, ctx, log, "no designator found", new Object[0]);
        } else {
            for (ICPPASTDesignator des : ctx.getDesignators()) {
                Expression oneLhs = null;
                if (des instanceof CPPASTArrayDesignator) {
                    oneLhs = (Expression)this.handle(((CPPASTArrayDesignator)des).getSubscriptExpression());
                } else if (des instanceof CPPASTFieldDesignator) {
                    oneLhs = NodeBuilder.newDeclaredReferenceExpression(((CPPASTFieldDesignator)des).getName().toString(), UnknownType.getUnknownType(), des.getRawSignature());
                } else if (des instanceof CPPASTArrayRangeDesignator) {
                    oneLhs = NodeBuilder.newArrayRangeExpression((Expression)this.handle(((CPPASTArrayRangeDesignator)des).getRangeFloor()), (Expression)this.handle(((CPPASTArrayRangeDesignator)des).getRangeCeiling()), des.getRawSignature());
                } else {
                    Util.errorWithFileLocation(this.lang, ctx, log, "Unknown designated lhs {}", des.getClass().toGenericString());
                }
                if (oneLhs == null) continue;
                lhs.add(oneLhs);
            }
        }
        DesignatedInitializerExpression die = NodeBuilder.newDesignatedInitializerExpression(ctx.getRawSignature());
        die.setLhs(lhs);
        die.setRhs(rhs);
        return die;
    }

    private Literal handleIntegerLiteral(CPPASTLiteralExpression ctx) {
        Number numberValue;
        String value = new String(ctx.getValue()).toLowerCase();
        String suffix = this.getSuffix(value);
        String strippedValue = value.substring(0, value.length() - suffix.length());
        int radix = 10;
        int offset = 0;
        if (value.startsWith("0b")) {
            radix = 2;
            offset = 2;
        } else if (value.startsWith("0x")) {
            radix = 16;
            offset = 2;
        } else if (value.startsWith("0") && strippedValue.length() > 1) {
            radix = 8;
            offset = 1;
        }
        strippedValue = strippedValue.substring(offset);
        BigInteger bigValue = new BigInteger(strippedValue, radix);
        if (Objects.equals("ull", suffix) || Objects.equals("ul", suffix)) {
            numberValue = bigValue;
        } else if (Objects.equals("ll", suffix) || Objects.equals("l", suffix)) {
            if (bigValue.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0) {
                numberValue = bigValue;
                Util.warnWithFileLocation(this.lang, ctx, log, "Integer literal {} is too large to represented in a signed type, interpreting it as unsigned.", ctx);
            } else {
                numberValue = bigValue.longValue();
            }
        } else if (bigValue.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0) {
            numberValue = bigValue;
            Util.warnWithFileLocation(this.lang, ctx, log, "Integer literal {} is too large to represented in a signed type, interpreting it as unsigned.", ctx);
        } else {
            numberValue = bigValue.longValue() > Integer.MAX_VALUE ? (Number)bigValue.longValue() : (Number)bigValue.intValue();
        }
        Type type = numberValue instanceof BigInteger ? (Objects.equals("ul", suffix) ? TypeParser.createFrom("unsigned long", true) : TypeParser.createFrom("unsigned long long", true)) : (numberValue instanceof Long ? (Objects.equals("ll", suffix) ? TypeParser.createFrom("long long", true) : TypeParser.createFrom("long", true)) : TypeParser.createFrom("int", true));
        return NodeBuilder.newLiteral(numberValue, type, ctx.getRawSignature());
    }

    private String getSuffix(String value) {
        String digit;
        String suffix = "";
        for (int i = 1; i <= 3 && (digit = value.substring(Math.max(0, value.length() - i))).chars().allMatch(character -> character == 117 || character == 108); ++i) {
            suffix = digit;
        }
        return suffix;
    }
}

