/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.cpp;

import de.fraunhofer.aisec.cpg.frontends.Handler;
import de.fraunhofer.aisec.cpg.frontends.cpp.CXXLanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.ConstructorDeclaration;
import de.fraunhofer.aisec.cpg.graph.Declaration;
import de.fraunhofer.aisec.cpg.graph.Expression;
import de.fraunhofer.aisec.cpg.graph.FieldDeclaration;
import de.fraunhofer.aisec.cpg.graph.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.MethodDeclaration;
import de.fraunhofer.aisec.cpg.graph.NodeBuilder;
import de.fraunhofer.aisec.cpg.graph.ParamVariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.ProblemDeclaration;
import de.fraunhofer.aisec.cpg.graph.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.ValueDeclaration;
import de.fraunhofer.aisec.cpg.graph.VariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.type.Type;
import de.fraunhofer.aisec.cpg.graph.type.TypeParser;
import de.fraunhofer.aisec.cpg.graph.type.UnknownType;
import de.fraunhofer.aisec.cpg.passes.scopes.RecordScope;
import java.util.Arrays;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTNameOwner;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTArrayDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFieldDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFunctionDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTSimpleDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTVisibilityLabel;

class DeclaratorHandler
extends Handler<Declaration, IASTNameOwner, CXXLanguageFrontend> {
    DeclaratorHandler(CXXLanguageFrontend lang) {
        super(Declaration::new, lang);
        this.map.put(CPPASTDeclarator.class, ctx -> this.handleDeclarator((CPPASTDeclarator)ctx));
        this.map.put(CPPASTArrayDeclarator.class, ctx -> this.handleDeclarator((CPPASTDeclarator)ctx));
        this.map.put(CPPASTFieldDeclarator.class, ctx -> this.handleFieldDeclarator((CPPASTDeclarator)ctx));
        this.map.put(CPPASTFunctionDeclarator.class, ctx -> this.handleFunctionDeclarator((CPPASTFunctionDeclarator)ctx));
        this.map.put(CPPASTCompositeTypeSpecifier.class, ctx -> this.handleCompositeTypeSpecifier((CPPASTCompositeTypeSpecifier)ctx));
    }

    private Declaration handleDeclarator(CPPASTDeclarator ctx) {
        if (ctx.getInitializer() == null && ctx.getNestedDeclarator() instanceof CPPASTDeclarator) {
            return (Declaration)this.handle(ctx.getNestedDeclarator());
        }
        VariableDeclaration declaration = NodeBuilder.newVariableDeclaration(ctx.getName().toString(), UnknownType.getUnknownType(), ctx.getRawSignature(), true);
        IASTInitializer init = ctx.getInitializer();
        if (init != null) {
            declaration.setInitializer((Expression)((CXXLanguageFrontend)this.lang).getInitializerHandler().handle(init));
        }
        ((CXXLanguageFrontend)this.lang).getScopeManager().addValueDeclaration(declaration);
        return declaration;
    }

    private FieldDeclaration handleFieldDeclarator(CPPASTDeclarator ctx) {
        IASTInitializer init = ctx.getInitializer();
        Expression initializer = null;
        if (init != null) {
            initializer = (Expression)((CXXLanguageFrontend)this.lang).getInitializerHandler().handle(init);
        }
        FieldDeclaration declaration = NodeBuilder.newFieldDeclaration(ctx.getName().toString(), UnknownType.getUnknownType(), Collections.emptyList(), ctx.getRawSignature(), ((CXXLanguageFrontend)this.lang).getLocationFromRawNode(ctx), initializer, true);
        ((CXXLanguageFrontend)this.lang).getScopeManager().addValueDeclaration(declaration);
        return declaration;
    }

    private ValueDeclaration handleFunctionDeclarator(CPPASTFunctionDeclarator ctx) {
        FunctionDeclaration declaration;
        if (ctx.getName().toString().isEmpty()) {
            return this.handleFunctionPointer(ctx);
        }
        String name = ctx.getName().toString();
        if (name.startsWith("operator")) {
            name = name.replace(" ", "");
        }
        RecordDeclaration recordDeclaration = null;
        if (name.contains("::")) {
            String[] rr = name.split("::");
            ICPPASTParameterDeclaration[] recordName = rr[0];
            String methodName = rr[1];
            recordDeclaration = ((CXXLanguageFrontend)this.lang).getRecordForName((String)recordName).orElse(null);
            if (recordDeclaration != null) {
                ((CXXLanguageFrontend)this.lang).getScopeManager().enterScope(recordDeclaration);
            }
            declaration = NodeBuilder.newMethodDeclaration(methodName, ctx.getRawSignature(), false, recordDeclaration);
        } else {
            declaration = NodeBuilder.newFunctionDeclaration(name, ctx.getRawSignature());
        }
        ((CXXLanguageFrontend)this.lang).getScopeManager().enterScope(declaration);
        int i = 0;
        for (ICPPASTParameterDeclaration param : ctx.getParameters()) {
            ParamVariableDeclaration arg = (ParamVariableDeclaration)((CXXLanguageFrontend)this.lang).getParameterDeclarationHandler().handle(param);
            IBinding binding = ctx.getParameters()[i].getDeclarator().getName().resolveBinding();
            if (binding != null) {
                ((CXXLanguageFrontend)this.lang).cacheDeclaration(binding, arg);
            }
            arg.setArgumentIndex(i);
            ((CXXLanguageFrontend)this.lang).getScopeManager().addValueDeclaration(arg);
            ++i;
        }
        if (ctx.takesVarArgs()) {
            ParamVariableDeclaration varargs = NodeBuilder.newMethodParameterIn("va_args", UnknownType.getUnknownType(), true, "");
            varargs.setArgumentIndex(i);
            ((CXXLanguageFrontend)this.lang).getScopeManager().addValueDeclaration(varargs);
        }
        ((CXXLanguageFrontend)this.lang).getScopeManager().leaveScope(declaration);
        if (recordDeclaration != null) {
            ((CXXLanguageFrontend)this.lang).getScopeManager().enterScope(recordDeclaration);
        }
        return declaration;
    }

    private ValueDeclaration handleFunctionPointer(CPPASTFunctionDeclarator ctx) {
        IASTNode parent;
        ValueDeclaration result;
        Expression initializer = ctx.getInitializer() == null ? null : (Expression)((CXXLanguageFrontend)this.lang).getInitializerHandler().handle(ctx.getInitializer());
        RecordDeclaration recordDeclaration = ((CXXLanguageFrontend)this.lang).getScopeManager().getCurrentRecord();
        if (recordDeclaration == null) {
            result = NodeBuilder.newVariableDeclaration(ctx.getNestedDeclarator().getName().toString(), UnknownType.getUnknownType(), ctx.getRawSignature(), true);
            ((VariableDeclaration)result).setInitializer(initializer);
        } else {
            String code = ctx.getRawSignature();
            Pattern namePattern = Pattern.compile("\\((\\*|.+\\*)(?<name>[^)]*)");
            Matcher matcher = namePattern.matcher(code);
            String name = "";
            if (matcher.find()) {
                name = matcher.group("name").strip();
            }
            result = NodeBuilder.newFieldDeclaration(name, UnknownType.getUnknownType(), Collections.emptyList(), code, ((CXXLanguageFrontend)this.lang).getLocationFromRawNode(ctx), initializer, true);
        }
        for (parent = ctx.getParent(); parent != null && !(parent instanceof CPPASTSimpleDeclaration); parent = parent.getParent()) {
        }
        if (parent != null) {
            result.setType(TypeParser.createFrom(parent.getRawSignature(), true));
            result.refreshType();
        } else {
            log.warn("Could not find suitable parent ast node for function pointer node: {}", (Object)this);
        }
        result.setLocation(((CXXLanguageFrontend)this.lang).getLocationFromRawNode(ctx));
        return result;
    }

    private RecordDeclaration handleCompositeTypeSpecifier(CPPASTCompositeTypeSpecifier ctx) {
        String kind;
        switch (ctx.getKey()) {
            default: {
                kind = "struct";
                break;
            }
            case 2: {
                kind = "union";
                break;
            }
            case 3: {
                kind = "class";
            }
        }
        RecordDeclaration recordDeclaration = NodeBuilder.newRecordDeclaration(((CXXLanguageFrontend)this.lang).getScopeManager().getCurrentNamePrefixWithDelimiter() + ctx.getName().toString(), kind, ctx.getRawSignature());
        recordDeclaration.setSuperClasses(Arrays.stream(ctx.getBaseSpecifiers()).map(b -> TypeParser.createFrom(b.getNameSpecifier().toString(), true)).collect(Collectors.toList()));
        ((CXXLanguageFrontend)this.lang).addRecord(recordDeclaration);
        ((CXXLanguageFrontend)this.lang).getScopeManager().enterScope(recordDeclaration);
        ((CXXLanguageFrontend)this.lang).getScopeManager().addValueDeclaration(recordDeclaration.getThis());
        this.processMembers(ctx, recordDeclaration);
        if (recordDeclaration.getConstructors().isEmpty()) {
            ConstructorDeclaration constructorDeclaration = NodeBuilder.newConstructorDeclaration(recordDeclaration.getName(), recordDeclaration.getName(), recordDeclaration);
            constructorDeclaration.setImplicit(true);
            constructorDeclaration.setType(TypeParser.createFrom(recordDeclaration.getName(), true));
            recordDeclaration.getConstructors().add(constructorDeclaration);
            ((CXXLanguageFrontend)this.lang).getScopeManager().addValueDeclaration(constructorDeclaration);
        }
        ((CXXLanguageFrontend)this.lang).getScopeManager().leaveScope(recordDeclaration);
        return recordDeclaration;
    }

    private void processMembers(CPPASTCompositeTypeSpecifier ctx, RecordDeclaration recordDeclaration) {
        for (IASTDeclaration member : ctx.getMembers()) {
            if (member instanceof CPPASTVisibilityLabel) continue;
            Declaration declaration = (Declaration)((CXXLanguageFrontend)this.lang).getDeclarationHandler().handle(member);
            if (declaration instanceof FunctionDeclaration) {
                MethodDeclaration method = MethodDeclaration.from((FunctionDeclaration)declaration, recordDeclaration);
                declaration.disconnectFromGraph();
                if (declaration.getName().equals(recordDeclaration.getName())) {
                    ConstructorDeclaration constructor = ConstructorDeclaration.from(method);
                    Type type = TypeParser.createFrom(((CXXLanguageFrontend)this.lang).getScopeManager().getFirstScopeThat(RecordScope.class::isInstance).getAstNode().getName(), true);
                    constructor.setType(type);
                    recordDeclaration.getConstructors().add(constructor);
                    ((CXXLanguageFrontend)this.lang).getScopeManager().replaceNode(constructor, declaration);
                    continue;
                }
                recordDeclaration.getMethods().add(method);
                ((CXXLanguageFrontend)this.lang).getScopeManager().replaceNode(method, declaration);
                continue;
            }
            if (declaration instanceof VariableDeclaration) {
                FieldDeclaration fieldDeclaration = FieldDeclaration.from((VariableDeclaration)declaration);
                recordDeclaration.getFields().add(fieldDeclaration);
                ((CXXLanguageFrontend)this.lang).replaceDeclarationInExpression(fieldDeclaration, declaration);
                continue;
            }
            if (declaration instanceof FieldDeclaration) {
                recordDeclaration.getFields().add((FieldDeclaration)declaration);
                continue;
            }
            if (declaration instanceof RecordDeclaration) {
                recordDeclaration.getRecords().add((RecordDeclaration)declaration);
                continue;
            }
            if (!(declaration instanceof ProblemDeclaration)) continue;
            ((CXXLanguageFrontend)this.lang).getCurrentTU().add(declaration);
        }
    }
}

