/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.cpp;

import de.fraunhofer.aisec.cpg.frontends.Handler;
import de.fraunhofer.aisec.cpg.frontends.cpp.CXXLanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.CompoundStatement;
import de.fraunhofer.aisec.cpg.graph.ConstructorDeclaration;
import de.fraunhofer.aisec.cpg.graph.Declaration;
import de.fraunhofer.aisec.cpg.graph.DeclarationSequence;
import de.fraunhofer.aisec.cpg.graph.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.IncludeDeclaration;
import de.fraunhofer.aisec.cpg.graph.MethodDeclaration;
import de.fraunhofer.aisec.cpg.graph.NamespaceDeclaration;
import de.fraunhofer.aisec.cpg.graph.NodeBuilder;
import de.fraunhofer.aisec.cpg.graph.ProblemDeclaration;
import de.fraunhofer.aisec.cpg.graph.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.ReturnStatement;
import de.fraunhofer.aisec.cpg.graph.Statement;
import de.fraunhofer.aisec.cpg.graph.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.ValueDeclaration;
import de.fraunhofer.aisec.cpg.graph.VariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.type.Type;
import de.fraunhofer.aisec.cpg.graph.type.TypeParser;
import de.fraunhofer.aisec.cpg.helpers.Util;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTElaboratedTypeSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFunctionDefinition;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTLinkageSpecification;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTNamespaceDefinition;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTProblemDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTSimpleDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTTemplateDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTUsingDirective;

public class DeclarationHandler
extends Handler<Declaration, IASTDeclaration, CXXLanguageFrontend> {
    public DeclarationHandler(CXXLanguageFrontend lang) {
        super(Declaration::new, lang);
        this.map.put(CPPASTTemplateDeclaration.class, ctx -> this.handleTemplateDeclaration((CPPASTTemplateDeclaration)ctx));
        this.map.put(CPPASTSimpleDeclaration.class, ctx -> this.handleSimpleDeclaration((CPPASTSimpleDeclaration)ctx));
        this.map.put(CPPASTFunctionDefinition.class, ctx -> this.handleFunctionDefinition((CPPASTFunctionDefinition)ctx));
        this.map.put(CPPASTProblemDeclaration.class, ctx -> this.handleProblem((CPPASTProblemDeclaration)ctx));
        this.map.put(CPPASTNamespaceDefinition.class, ctx -> this.handleNamespace((CPPASTNamespaceDefinition)ctx));
        this.map.put(CPPASTUsingDirective.class, ctx -> this.handleUsingDirective((CPPASTUsingDirective)ctx));
    }

    private Declaration handleUsingDirective(CPPASTUsingDirective using) {
        return NodeBuilder.newUsingDirective(using.getRawSignature(), using.getQualifiedName().toString());
    }

    private Declaration handleNamespace(CPPASTNamespaceDefinition ctx) {
        NamespaceDeclaration declaration = NodeBuilder.newNamespaceDeclaration(ctx.getName().toString());
        ((CXXLanguageFrontend)this.lang).getScopeManager().enterScope(declaration);
        for (IASTNode child : ctx.getChildren()) {
            if (child instanceof IASTDeclaration) {
                declaration.add((Declaration)((CXXLanguageFrontend)this.lang).getDeclarationHandler().handle((IASTDeclaration)child));
                continue;
            }
            if (child instanceof CPPASTName) continue;
            Util.errorWithFileLocation(this.lang, ctx, log, "Unknown child in namespace: {}", child.getClass());
        }
        ((CXXLanguageFrontend)this.lang).getScopeManager().leaveScope(declaration);
        return declaration;
    }

    private Declaration handleProblem(CPPASTProblemDeclaration ctx) {
        return NodeBuilder.newProblemDeclaration(ctx.getContainingFilename(), ctx.getProblem().getMessage(), ctx.getProblem().getFileLocation().toString());
    }

    private FunctionDeclaration handleFunctionDefinition(CPPASTFunctionDefinition ctx) {
        Statement bodyStatement;
        RecordDeclaration recordDeclaration;
        FunctionDeclaration functionDeclaration = (FunctionDeclaration)((CXXLanguageFrontend)this.lang).getDeclaratorHandler().handle(ctx.getDeclarator());
        String typeString = DeclarationHandler.getTypeStringFromDeclarator(ctx.getDeclarator(), ctx.getDeclSpecifier());
        functionDeclaration.setIsDefinition(true);
        if (functionDeclaration instanceof MethodDeclaration && typeString.isEmpty()) {
            ConstructorDeclaration constructorDeclaration = ConstructorDeclaration.from((MethodDeclaration)functionDeclaration);
            ((CXXLanguageFrontend)this.lang).getScopeManager().replaceNode(constructorDeclaration, functionDeclaration);
            functionDeclaration = constructorDeclaration;
        }
        functionDeclaration.setType(TypeParser.createFrom(typeString, true));
        RecordDeclaration recordDeclaration2 = recordDeclaration = functionDeclaration instanceof MethodDeclaration ? ((MethodDeclaration)functionDeclaration).getRecordDeclaration() : null;
        if (recordDeclaration != null) {
            ((CXXLanguageFrontend)this.lang).getScopeManager().enterScope(recordDeclaration);
            List<MethodDeclaration> candidates = functionDeclaration instanceof ConstructorDeclaration ? recordDeclaration.getConstructors() : recordDeclaration.getMethods();
            FunctionDeclaration finalFunctionDeclaration = functionDeclaration;
            candidates = candidates.stream().filter(m3 -> m3.getSignature().equals(finalFunctionDeclaration.getSignature())).collect(Collectors.toList());
            if (candidates.isEmpty()) {
                log.warn("Could not find declaration of method {} in record {}", (Object)functionDeclaration.getName(), (Object)recordDeclaration.getName());
            } else if (candidates.size() > 1) {
                log.warn("Found more than one candidate to connect definition of method {} in record {} to its declaration. We will comply, but this is suspicious.", (Object)functionDeclaration.getName(), (Object)recordDeclaration.getName());
            }
            for (MethodDeclaration candidate : candidates) {
                candidate.setDefinition(functionDeclaration);
            }
        }
        ((CXXLanguageFrontend)this.lang).getScopeManager().enterScope(functionDeclaration);
        functionDeclaration.setType(TypeParser.createFrom(typeString, true));
        if (ctx.getBody() != null && (bodyStatement = (Statement)((CXXLanguageFrontend)this.lang).getStatementHandler().handle(ctx.getBody())) instanceof CompoundStatement) {
            CompoundStatement body = (CompoundStatement)bodyStatement;
            List<Statement> statements = body.getStatements();
            Statement lastStatement = null;
            if (!statements.isEmpty()) {
                lastStatement = statements.get(statements.size() - 1);
            }
            if (!(lastStatement instanceof ReturnStatement)) {
                ReturnStatement returnStatement = NodeBuilder.newReturnStatement("return;");
                returnStatement.setImplicit(true);
                statements.add(returnStatement);
            }
            functionDeclaration.setBody(body);
        }
        ((CXXLanguageFrontend)this.lang).processAttributes(functionDeclaration, ctx);
        ((CXXLanguageFrontend)this.lang).getScopeManager().leaveScope(functionDeclaration);
        if (recordDeclaration != null) {
            ((CXXLanguageFrontend)this.lang).getScopeManager().leaveScope(recordDeclaration);
        }
        return functionDeclaration;
    }

    private boolean isTypedef(CPPASTSimpleDeclaration ctx) {
        if (ctx.getRawSignature().contains("typedef")) {
            if (ctx.getDeclSpecifier() instanceof CPPASTCompositeTypeSpecifier) {
                return ctx.getDeclSpecifier().toString().equals("struct") && ctx.getRawSignature().strip().startsWith("typedef");
            }
            return true;
        }
        return false;
    }

    private Declaration handleTemplateDeclaration(CPPASTTemplateDeclaration ctx) {
        Util.warnWithFileLocation(this.lang, ctx, log, "Parsing template declarations is not supported (yet). Will ignore template and parse inner declaration", new Object[0]);
        return (Declaration)this.handle(ctx.getDeclaration());
    }

    private Declaration handleSimpleDeclaration(CPPASTSimpleDeclaration ctx) {
        if (this.isTypedef(ctx)) {
            TypeManager.getInstance().handleTypedef(ctx.getRawSignature());
        }
        DeclarationSequence sequence = new DeclarationSequence();
        IASTDeclSpecifier declSpecifier = ctx.getDeclSpecifier();
        if (declSpecifier instanceof CPPASTCompositeTypeSpecifier) {
            int endOfDeclaration;
            Declaration declaration = (Declaration)((CXXLanguageFrontend)this.lang).getDeclaratorHandler().handle((CPPASTCompositeTypeSpecifier)ctx.getDeclSpecifier());
            if (declaration.getName().isEmpty() && ctx.getRawSignature().strip().startsWith("typedef") && (endOfDeclaration = ctx.getRawSignature().lastIndexOf(125)) + 1 < ctx.getRawSignature().length()) {
                List<String> parts = Util.splitLeavingParenthesisContents(ctx.getRawSignature().substring(endOfDeclaration + 1), ",");
                Optional<String> name = parts.stream().filter(p -> !p.contains("*") && !p.contains("[")).findFirst();
                name.ifPresent(s2 -> declaration.setName(s2.replace(";", "")));
            }
            ((CXXLanguageFrontend)this.lang).processAttributes(declaration, ctx);
            sequence.add(declaration);
        } else if (declSpecifier instanceof CPPASTElaboratedTypeSpecifier) {
            Util.warnWithFileLocation(this.lang, ctx, log, "Parsing elaborated type specifiers is not supported (yet)", declSpecifier.getClass());
        }
        for (IASTDeclarator declarator : ctx.getDeclarators()) {
            ValueDeclaration declaration = (ValueDeclaration)((CXXLanguageFrontend)this.lang).getDeclaratorHandler().handle(declarator);
            String typeString = declaration instanceof FunctionDeclaration || declaration instanceof VariableDeclaration ? DeclarationHandler.getTypeStringFromDeclarator(declarator, ctx.getDeclSpecifier()) : ctx.getRawSignature();
            Type result = TypeParser.createFrom(typeString, true);
            declaration.setType(result);
            ((CXXLanguageFrontend)this.lang).cacheDeclaration(declarator.getName().resolveBinding(), declaration);
            ((CXXLanguageFrontend)this.lang).processAttributes(declaration, ctx);
            sequence.add(declaration);
        }
        if (sequence.isSingle()) {
            return sequence.first();
        }
        return sequence;
    }

    private void parseInclusions(IASTTranslationUnit.IDependencyTree.IASTInclusionNode[] includes, HashMap<String, HashSet<String>> allIncludes) {
        if (includes != null) {
            for (IASTTranslationUnit.IDependencyTree.IASTInclusionNode n : includes) {
                HashSet strings = allIncludes.computeIfAbsent(n.getIncludeDirective().getContainingFilename(), k -> new HashSet());
                strings.add(n.getIncludeDirective().getPath());
                this.parseInclusions(n.getNestedInclusions(), allIncludes);
            }
        }
    }

    TranslationUnitDeclaration handleTranslationUnit(CPPASTTranslationUnit translationUnit) {
        TranslationUnitDeclaration node = NodeBuilder.newTranslationUnitDeclaration(translationUnit.getFilePath(), translationUnit.getRawSignature());
        ((CXXLanguageFrontend)this.lang).getScopeManager().resetToGlobal();
        ((CXXLanguageFrontend)this.lang).setCurrentTU(node);
        HashMap<String, HashSet> problematicIncludes = new HashMap<String, HashSet>();
        for (IASTDeclaration declaration : translationUnit.getDeclarations()) {
            Declaration decl;
            if (declaration instanceof CPPASTLinkageSpecification || (decl = (Declaration)this.handle(declaration)) == null) continue;
            if (decl instanceof ProblemDeclaration) {
                HashSet problems = problematicIncludes.computeIfAbsent(((ProblemDeclaration)decl).getFilename(), k -> new HashSet());
                problems.add((ProblemDeclaration)decl);
                continue;
            }
            node.add(decl);
        }
        boolean addIncludesToGraph = true;
        if (addIncludesToGraph) {
            IASTTranslationUnit.IDependencyTree dependencyTree = translationUnit.getDependencyTree();
            HashMap<String, HashSet<String>> allIncludes = new HashMap<String, HashSet<String>>();
            this.parseInclusions(dependencyTree.getInclusions(), allIncludes);
            if (allIncludes.size() > 0) {
                HashSet includesStrings = new HashSet();
                HashMap<String, IncludeDeclaration> includeMap = new HashMap<String, IncludeDeclaration>();
                allIncludes.values().forEach(includesStrings::addAll);
                for (String string : includesStrings) {
                    HashSet problems = (HashSet)problematicIncludes.get(string);
                    IncludeDeclaration includeDeclaration = NodeBuilder.newIncludeDeclaration(string);
                    if (problems != null) {
                        includeDeclaration.getProblems().addAll(problems);
                    }
                    includeMap.put(string, includeDeclaration);
                }
                for (String string : allIncludes.get(translationUnit.getFilePath())) {
                    node.add((Declaration)includeMap.get(string));
                }
                allIncludes.remove(translationUnit.getFilePath());
                for (Map.Entry entry : allIncludes.entrySet()) {
                    IncludeDeclaration includeDeclaration = (IncludeDeclaration)includeMap.get(entry.getKey());
                    for (String s2 : (HashSet)entry.getValue()) {
                        includeDeclaration.getIncludes().add((IncludeDeclaration)includeMap.get(s2));
                    }
                }
            }
        }
        return node;
    }

    static String getTypeStringFromDeclarator(IASTDeclarator declarator, IASTDeclSpecifier declSpecifier) {
        StringBuilder typeString = new StringBuilder(declSpecifier.toString());
        for (IASTNode node : declarator.getChildren()) {
            if (!(node instanceof IASTPointerOperator) && !(node instanceof IASTArrayModifier)) continue;
            typeString.append(node.getRawSignature());
        }
        return typeString.toString();
    }
}

