/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.cpp;

import de.fraunhofer.aisec.cpg.TranslationConfiguration;
import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.frontends.TranslationException;
import de.fraunhofer.aisec.cpg.frontends.cpp.DeclarationHandler;
import de.fraunhofer.aisec.cpg.frontends.cpp.DeclaratorHandler;
import de.fraunhofer.aisec.cpg.frontends.cpp.ExpressionHandler;
import de.fraunhofer.aisec.cpg.frontends.cpp.InitializerHandler;
import de.fraunhofer.aisec.cpg.frontends.cpp.ParameterDeclarationHandler;
import de.fraunhofer.aisec.cpg.frontends.cpp.StatementHandler;
import de.fraunhofer.aisec.cpg.graph.Annotation;
import de.fraunhofer.aisec.cpg.graph.Declaration;
import de.fraunhofer.aisec.cpg.graph.DeclaredReferenceExpression;
import de.fraunhofer.aisec.cpg.graph.Expression;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.NodeBuilder;
import de.fraunhofer.aisec.cpg.graph.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.ValueDeclaration;
import de.fraunhofer.aisec.cpg.graph.type.TypeParser;
import de.fraunhofer.aisec.cpg.graph.type.UnknownType;
import de.fraunhofer.aisec.cpg.helpers.Benchmark;
import de.fraunhofer.aisec.cpg.passes.scopes.ScopeManager;
import de.fraunhofer.aisec.cpg.sarif.PhysicalLocation;
import de.fraunhofer.aisec.cpg.sarif.Region;
import java.io.File;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.cdt.core.dom.ast.IASTAttribute;
import org.eclipse.cdt.core.dom.ast.IASTAttributeOwner;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTToken;
import org.eclipse.cdt.core.dom.ast.IASTTokenList;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.GPPLanguage;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.parser.DefaultLogService;
import org.eclipse.cdt.core.parser.FileContent;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IncludeFileContentProvider;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTIdExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTTranslationUnit;
import org.eclipse.cdt.internal.core.parser.IMacroDictionary;
import org.eclipse.cdt.internal.core.parser.scanner.AbstractCharArray;
import org.eclipse.cdt.internal.core.parser.scanner.CharArray;
import org.eclipse.cdt.internal.core.parser.scanner.InternalFileContent;
import org.eclipse.cdt.internal.core.parser.scanner.InternalFileContentProvider;
import org.eclipse.core.runtime.CoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CXXLanguageFrontend
extends LanguageFrontend {
    private static final Logger LOGGER = LoggerFactory.getLogger(CXXLanguageFrontend.class);
    private final IncludeFileContentProvider includeFileContentProvider = new InternalFileContentProvider(){

        private @Nullable InternalFileContent getContentUncached(String path) {
            if (!this.getInclusionExists(path)) {
                LOGGER.debug("Include file not found: {}", (Object)path);
                return null;
            }
            if (this.absoluteOrRelativePathIsInList(path, ((CXXLanguageFrontend)CXXLanguageFrontend.this).config.includeBlacklist)) {
                LOGGER.debug("Blacklisting include file: {}", (Object)path);
                return null;
            }
            if (this.hasIncludeWhitelist() && !this.absoluteOrRelativePathIsInList(path, ((CXXLanguageFrontend)CXXLanguageFrontend.this).config.includeWhitelist)) {
                LOGGER.debug("Include file {} not on the whitelist. Ignoring.", (Object)path);
                return null;
            }
            LOGGER.debug("Loading include file {}", (Object)path);
            FileContent content = FileContent.createForExternalFileLocation(path);
            return (InternalFileContent)content;
        }

        private boolean hasIncludeWhitelist() {
            return ((CXXLanguageFrontend)CXXLanguageFrontend.this).config.includeWhitelist != null && !((CXXLanguageFrontend)CXXLanguageFrontend.this).config.includeWhitelist.isEmpty();
        }

        private boolean absoluteOrRelativePathIsInList(String path, List<String> list) {
            if (list == null || list.isEmpty()) {
                return false;
            }
            if (list.contains(path)) {
                return true;
            }
            ArrayList<Path> includeLocations = new ArrayList<Path>();
            File topLevel = CXXLanguageFrontend.this.config.getTopLevel();
            if (topLevel != null) {
                includeLocations.add(topLevel.toPath().toAbsolutePath());
            }
            includeLocations.addAll(Arrays.stream(((CXXLanguageFrontend)CXXLanguageFrontend.this).config.includePaths).map(s2 -> Path.of(s2, new String[0]).toAbsolutePath()).collect(Collectors.toList()));
            for (Path includeLocation : includeLocations) {
                Path includeFile;
                Path relative = includeLocation.relativize(includeFile = Path.of(path, new String[0]));
                if (!list.contains(relative.toString())) continue;
                return true;
            }
            return false;
        }

        @Override
        public @Nullable InternalFileContent getContentForInclusion(String path, IMacroDictionary macroDictionary) {
            return this.getContentUncached(path);
        }

        @Override
        public @Nullable InternalFileContent getContentForInclusion(IIndexFileLocation ifl, String astPath) {
            return this.getContentUncached(astPath);
        }
    };
    private DeclarationHandler declarationHandler = new DeclarationHandler(this);
    private DeclaratorHandler declaratorHandler = new DeclaratorHandler(this);
    private ExpressionHandler expressionHandler = new ExpressionHandler(this);
    private InitializerHandler initializerHandler = new InitializerHandler(this);
    private ParameterDeclarationHandler parameterDeclarationHandler = new ParameterDeclarationHandler(this);
    private StatementHandler statementHandler = new StatementHandler(this);
    private HashMap<IBinding, Declaration> cachedDeclarations = new HashMap();
    private HashMap<IBinding, List<Expression>> cachedExpressions = new HashMap();
    private HashMap<Integer, String> comments = new HashMap();

    public CXXLanguageFrontend(@NonNull TranslationConfiguration config, ScopeManager scopeManager) {
        super(config, scopeManager, "::");
    }

    private static int getEndColumnIndex(AbstractCharArray posPrefix, int end) {
        int column = 1;
        try {
            if (end - 1 >= posPrefix.getLength() || posPrefix.get(end - 1) == '\n') {
                end = Math.min(end - 1, posPrefix.getLength() - 1);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            log.error("could not update end ", e);
        }
        for (int i = end - 1; i > 1 && posPrefix.get(i) != '\n'; --i) {
            ++column;
        }
        return column;
    }

    private static void explore(IASTNode node, int indent) {
        IASTNode[] children = node.getChildren();
        StringBuilder s2 = new StringBuilder();
        s2.append(" ".repeat(indent));
        log.trace("{}{} -> {}", s2, node.getClass().getSimpleName(), node.getRawSignature().replace('\n', '\\').replace('\t', ' '));
        for (IASTNode iastNode : children) {
            CXXLanguageFrontend.explore(iastNode, indent + 2);
        }
    }

    @Override
    public TranslationUnitDeclaration parse(File file) throws TranslationException {
        TypeManager.getInstance().setLanguageFrontend(this);
        FileContent content = FileContent.createForExternalFileLocation(file.getAbsolutePath());
        ArrayList<String> includePaths = new ArrayList<String>();
        if (this.config.getTopLevel() != null) {
            includePaths.add(this.config.getTopLevel().toPath().toAbsolutePath().toString());
        }
        includePaths.addAll(Arrays.asList(this.config.includePaths));
        ScannerInfo scannerInfo = new ScannerInfo(this.config.symbols, includePaths.toArray(new String[0]));
        DefaultLogService log = new DefaultLogService();
        int opts = 32;
        try {
            Benchmark bench = new Benchmark(this.getClass(), "Parsing sourcefile");
            IASTTranslationUnit translationUnit = GPPLanguage.getDefault().getASTTranslationUnit(content, (IScannerInfo)scannerInfo, this.includeFileContentProvider, null, opts, (IParserLogService)log);
            bench.stop();
            bench = new Benchmark(this.getClass(), "Transform to CPG");
            if (this.config.debugParser) {
                CXXLanguageFrontend.explore(translationUnit, 0);
            }
            for (IASTComment c : translationUnit.getComments()) {
                this.comments.put(c.getFileLocation().getStartingLineNumber(), c.getRawSignature());
            }
            TranslationUnitDeclaration translationUnitDeclaration = this.declarationHandler.handleTranslationUnit((CPPASTTranslationUnit)translationUnit);
            bench.stop();
            return translationUnitDeclaration;
        }
        catch (CoreException ex) {
            throw new TranslationException(ex);
        }
    }

    @Override
    public <T> @Nullable String getCodeFromRawNode(T astNode) {
        if (astNode instanceof ASTNode) {
            ASTNode node = (ASTNode)astNode;
            return node.getRawSignature();
        }
        return null;
    }

    @Override
    public <T> @Nullable PhysicalLocation getLocationFromRawNode(T astNode) {
        ASTNode node;
        IASTFileLocation fLocation;
        if (astNode instanceof ASTNode && (fLocation = (node = (ASTNode)astNode).getFileLocation()) != null) {
            AbstractCharArray translationUnitRawSignature = new CharArray("");
            try {
                Field fLoc = this.getField(fLocation.getClass(), "fLocationCtx");
                fLoc.setAccessible(true);
                Object locCtx = fLoc.get(fLocation);
                Field fSource = this.getField(locCtx.getClass(), "fSource");
                fSource.setAccessible(true);
                translationUnitRawSignature = (AbstractCharArray)fSource.get(locCtx);
            }
            catch (ClassCastException | NullPointerException | ReflectiveOperationException e) {
                LOGGER.warn("Reflective retrieval of AST node source failed. Cannot reliably determine content of the file that contains the node");
                return null;
            }
            int startColumn = 1;
            for (int i = node.getFileLocation().getNodeOffset() - 1; i > 1; --i) {
                if (i >= translationUnitRawSignature.getLength()) {
                    LOGGER.warn("Requested index {} exceeds length of translation unit code ({})", (Object)i, (Object)translationUnitRawSignature.getLength());
                    return null;
                }
                if (translationUnitRawSignature.get(i) == '\n') break;
                ++startColumn;
            }
            int endColumn = CXXLanguageFrontend.getEndColumnIndex(translationUnitRawSignature, node.getFileLocation().getNodeOffset() + node.getLength());
            Region region = new Region(fLocation.getStartingLineNumber(), startColumn, fLocation.getEndingLineNumber(), endColumn);
            return new PhysicalLocation(Path.of(node.getContainingFilename(), new String[0]).toUri(), region);
        }
        return null;
    }

    public void processAttributes(@NonNull Node node, @NonNull IASTAttributeOwner owner) {
        if (this.config.processAnnotations) {
            node.addAnnotations(this.handleAttributes(owner));
        }
    }

    private List<Annotation> handleAttributes(IASTAttributeOwner owner) {
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        for (IASTAttribute attribute : owner.getAttributes()) {
            Annotation annotation = NodeBuilder.newAnnotation(new String(attribute.getName()), attribute.getRawSignature());
            if (attribute.getArgumentClause() instanceof IASTTokenList) {
                List<Expression> values = this.handleTokenList((IASTTokenList)attribute.getArgumentClause());
                annotation.setValues(values);
            }
            list.add(annotation);
        }
        return list;
    }

    private List<Expression> handleTokenList(IASTTokenList tokenList) {
        ArrayList<Expression> list = new ArrayList<Expression>();
        for (IASTToken token : tokenList.getTokens()) {
            if (token.getTokenType() == 6) continue;
            list.add(this.handleToken(token));
        }
        return list;
    }

    private Expression handleToken(IASTToken token) {
        String code = new String(token.getTokenCharImage());
        switch (token.getTokenType()) {
            case 1: {
                return NodeBuilder.newDeclaredReferenceExpression(code, UnknownType.getUnknownType(), code);
            }
            case 2: {
                return NodeBuilder.newLiteral(Integer.parseInt(code), TypeParser.createFrom("int", true), code);
            }
            case 130: {
                return NodeBuilder.newLiteral(code.length() >= 2 ? code.substring(1, code.length() - 1) : "", TypeParser.createFrom("const char*", false), code);
            }
        }
        return NodeBuilder.newLiteral(code, TypeParser.createFrom("const char*", false), code);
    }

    private Field getField(Class<?> type, String fieldName) throws NoSuchFieldException {
        try {
            return type.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            if (type.getSuperclass() != null) {
                return this.getField(type.getSuperclass(), fieldName);
            }
            throw e;
        }
    }

    private void addCachedExpression(IBinding binding, Expression expression) {
        if (this.cachedExpressions.containsKey(binding)) {
            this.cachedExpressions.get(binding).add(expression);
        } else {
            ArrayList<Expression> expressions = new ArrayList<Expression>();
            expressions.add(expression);
            this.cachedExpressions.put(binding, expressions);
        }
    }

    public void replaceDeclarationInExpression(Declaration newDeclaration, Declaration oldDeclaration) {
        IBinding binding = this.cachedDeclarations.entrySet().stream().filter(d -> ((Declaration)d.getValue()).equals(oldDeclaration)).map(Map.Entry::getKey).findFirst().orElse(null);
        if (binding != null && this.cachedExpressions.containsKey(binding)) {
            List<Expression> expressions = this.cachedExpressions.get(binding);
            for (Expression expression : expressions) {
                ((DeclaredReferenceExpression)expression).setRefersTo((ValueDeclaration)newDeclaration);
            }
        }
        if (binding != null) {
            this.cachedDeclarations.remove(binding);
            this.cachedDeclarations.put(binding, newDeclaration);
        }
    }

    public void expressionRefersToDeclaration(Expression expression, IASTExpression iastExpression) {
        if (expression instanceof DeclaredReferenceExpression && iastExpression instanceof CPPASTIdExpression) {
            IBinding binding = ((CPPASTIdExpression)iastExpression).getName().resolveBinding();
            Declaration declaration = this.cachedDeclarations.get(binding);
            if (declaration != null) {
                LOGGER.debug("Connecting {} to {}", (Object)expression, (Object)declaration);
                ((DeclaredReferenceExpression)expression).setRefersTo((ValueDeclaration)declaration);
            }
            this.addCachedExpression(binding, expression);
        } else if (expression == null) {
            LOGGER.warn("Cannot connect, from is NULL, to is {}", (Object)iastExpression.getClass().toGenericString());
        } else if (iastExpression == null) {
            LOGGER.warn("Cannot connect, to is NULL, from is {}", (Object)expression.getClass().toGenericString());
        } else {
            LOGGER.debug("Cannot connect {} to {}", (Object)expression.getClass(), (Object)iastExpression.getClass());
        }
    }

    public @Nullable Declaration cacheDeclaration(IBinding binding, Declaration declaration) {
        if (this.cachedExpressions.containsKey(binding)) {
            List<Expression> expressionList = this.cachedExpressions.get(binding);
            for (Expression expression : expressionList) {
                ((DeclaredReferenceExpression)expression).setRefersTo((ValueDeclaration)declaration);
            }
        }
        return this.cachedDeclarations.put(binding, declaration);
    }

    public Declaration getCachedDeclaration(IBinding binding) {
        return this.cachedDeclarations.get(binding);
    }

    public List<Expression> getCachedExpression(IBinding binding) {
        if (this.cachedExpressions.containsKey(binding)) {
            return this.cachedExpressions.get(binding);
        }
        return new ArrayList<Expression>();
    }

    public Map<IBinding, Declaration> getCachedDeclarations() {
        return this.cachedDeclarations;
    }

    @Override
    public void cleanup() {
        super.cleanup();
    }

    @Override
    public <S, T> void setComment(S s2, T ctx) {
        Node cpgNode;
        if (ctx instanceof ASTNode && s2 instanceof Node && this.comments.containsKey((cpgNode = (Node)s2).getLocation().getRegion().getEndLine())) {
            cpgNode.setComment(this.comments.get(cpgNode.getLocation().getRegion().getEndLine()));
        }
    }

    public DeclarationHandler getDeclarationHandler() {
        return this.declarationHandler;
    }

    public DeclaratorHandler getDeclaratorHandler() {
        return this.declaratorHandler;
    }

    public ExpressionHandler getExpressionHandler() {
        return this.expressionHandler;
    }

    public InitializerHandler getInitializerHandler() {
        return this.initializerHandler;
    }

    public ParameterDeclarationHandler getParameterDeclarationHandler() {
        return this.parameterDeclarationHandler;
    }

    public StatementHandler getStatementHandler() {
        return this.statementHandler;
    }
}

