/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg;

import de.fraunhofer.aisec.cpg.passes.CallResolver;
import de.fraunhofer.aisec.cpg.passes.EvaluationOrderGraphPass;
import de.fraunhofer.aisec.cpg.passes.FilenameMapper;
import de.fraunhofer.aisec.cpg.passes.ImportResolver;
import de.fraunhofer.aisec.cpg.passes.JavaExternalTypeHierarchyResolver;
import de.fraunhofer.aisec.cpg.passes.Pass;
import de.fraunhofer.aisec.cpg.passes.TypeHierarchyResolver;
import de.fraunhofer.aisec.cpg.passes.TypeResolver;
import de.fraunhofer.aisec.cpg.passes.VariableUsageResolver;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

public class TranslationConfiguration {
    public final boolean debugParser;
    public final boolean loadIncludes;
    public final String[] includePaths;
    public final List<String> includeWhitelist;
    public final List<String> includeBlacklist;
    public boolean disableCleanup = false;
    public final boolean codeInNodes;
    public final boolean processAnnotations;
    final boolean failOnError;
    public final Map<String, String> symbols;
    private final List<File> sourceLocations;
    private final File topLevel;
    private final @NonNull List<Pass> passes;

    private TranslationConfiguration(Map<String, String> symbols, List<File> sourceLocations, File topLevel, boolean debugParser, boolean failOnError, boolean loadIncludes, String[] includePaths, List<String> includeWhitelist, List<String> includeBlacklist, List<Pass> passes, boolean codeInNodes, boolean processAnnotations, boolean disableCleanup) {
        this.symbols = symbols;
        this.sourceLocations = sourceLocations;
        this.topLevel = topLevel;
        this.debugParser = debugParser;
        this.failOnError = failOnError;
        this.loadIncludes = loadIncludes;
        this.includePaths = includePaths;
        this.includeWhitelist = includeWhitelist;
        this.includeBlacklist = includeBlacklist;
        this.passes = passes != null ? passes : new ArrayList();
        this.codeInNodes = codeInNodes;
        this.processAnnotations = processAnnotations;
        this.disableCleanup = disableCleanup;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Map<String, String> getSymbols() {
        return this.symbols;
    }

    public List<File> getSourceLocations() {
        return this.sourceLocations;
    }

    public File getTopLevel() {
        return this.topLevel;
    }

    public List<Pass> getRegisteredPasses() {
        return this.passes;
    }

    public static class Builder {
        private List<File> sourceLocations = new ArrayList<File>();
        private File topLevel = null;
        private boolean debugParser = false;
        private boolean failOnError = false;
        private boolean loadIncludes = false;
        private Map<String, String> symbols = new HashMap<String, String>();
        private final List<String> includePaths = new ArrayList<String>();
        private final List<String> includeWhitelist = new ArrayList<String>();
        private final List<String> includeBlacklist = new ArrayList<String>();
        private final List<Pass> passes = new ArrayList<Pass>();
        private boolean codeInNodes = true;
        private boolean processAnnotations = false;
        private boolean disableCleanup = false;

        public Builder symbols(Map<String, String> symbols) {
            this.symbols = symbols;
            return this;
        }

        public Builder sourceLocations(File ... sourceLocations) {
            this.sourceLocations = Arrays.asList(sourceLocations);
            return this;
        }

        public Builder sourceLocations(List<File> sourceLocations) {
            this.sourceLocations = sourceLocations;
            return this;
        }

        public Builder topLevel(File topLevel) {
            this.topLevel = topLevel;
            return this;
        }

        public Builder debugParser(boolean debugParser) {
            this.debugParser = debugParser;
            return this;
        }

        public Builder failOnError(boolean failOnError) {
            this.failOnError = failOnError;
            return this;
        }

        public Builder loadIncludes(boolean loadIncludes) {
            this.loadIncludes = loadIncludes;
            return this;
        }

        public Builder includePath(String includePath) {
            this.includePaths.add(includePath);
            return this;
        }

        public Builder includeWhitelist(String includeFile) {
            this.includeWhitelist.add(includeFile);
            return this;
        }

        public Builder disableCleanup() {
            this.disableCleanup = true;
            return this;
        }

        public Builder includeBlacklist(String includeFile) {
            this.includeBlacklist.add(includeFile);
            return this;
        }

        public Builder registerPass(@NonNull Pass pass) {
            this.passes.add(pass);
            return this;
        }

        public Builder defaultPasses() {
            this.registerPass(new FilenameMapper());
            this.registerPass(new TypeHierarchyResolver());
            this.registerPass(new JavaExternalTypeHierarchyResolver());
            this.registerPass(new ImportResolver());
            this.registerPass(new VariableUsageResolver());
            this.registerPass(new CallResolver());
            this.registerPass(new EvaluationOrderGraphPass());
            this.registerPass(new TypeResolver());
            return this;
        }

        public Builder codeInNodes(boolean b) {
            this.codeInNodes = b;
            return this;
        }

        public Builder processAnnotations(boolean b) {
            this.processAnnotations = b;
            return this;
        }

        public TranslationConfiguration build() {
            return new TranslationConfiguration(this.symbols, this.sourceLocations, this.topLevel, this.debugParser, this.failOnError, this.loadIncludes, this.includePaths.toArray(new String[0]), this.includeWhitelist, this.includeBlacklist, this.passes, this.codeInNodes, this.processAnnotations, this.disableCleanup);
        }
    }
}

