/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.sarif;

import de.fraunhofer.aisec.cpg.sarif.Region;
import java.net.URI;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PhysicalLocation {
    private @NonNull ArtifactLocation artifactLocation;
    private @NonNull Region region;

    public static @NonNull String locationLink(@Nullable PhysicalLocation location) {
        if (location != null) {
            return location.getArtifactLocation().getUri() + ":" + location.getRegion().getStartLine();
        }
        return "unknown";
    }

    public PhysicalLocation(URI uri, @NonNull Region region) {
        this.artifactLocation = new ArtifactLocation(uri);
        this.region = region;
    }

    public void setRegion(@NonNull Region region) {
        this.region = region;
    }

    public @NonNull Region getRegion() {
        return this.region;
    }

    public @NonNull ArtifactLocation getArtifactLocation() {
        return this.artifactLocation;
    }

    public static class ArtifactLocation {
        private @NonNull URI uri;

        public ArtifactLocation(@NonNull URI uri) {
            this.uri = uri;
        }

        public @NonNull URI getUri() {
            return this.uri;
        }
    }
}

