/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes;

import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.graph.Declaration;
import de.fraunhofer.aisec.cpg.graph.DeclaredReferenceExpression;
import de.fraunhofer.aisec.cpg.graph.EnumDeclaration;
import de.fraunhofer.aisec.cpg.graph.FieldDeclaration;
import de.fraunhofer.aisec.cpg.graph.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.MemberExpression;
import de.fraunhofer.aisec.cpg.graph.MethodDeclaration;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.NodeBuilder;
import de.fraunhofer.aisec.cpg.graph.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.StaticReferenceExpression;
import de.fraunhofer.aisec.cpg.graph.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.Type;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.ValueDeclaration;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import de.fraunhofer.aisec.cpg.helpers.Util;
import de.fraunhofer.aisec.cpg.passes.Pass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariableUsageResolver
extends Pass {
    private static final Logger log = LoggerFactory.getLogger(VariableUsageResolver.class);
    private Map<Type, List<Type>> superTypesMap = new HashMap<Type, List<Type>>();
    private Map<Type, RecordDeclaration> recordMap = new HashMap<Type, RecordDeclaration>();
    private Map<Type, EnumDeclaration> enumMap = new HashMap<Type, EnumDeclaration>();
    private TranslationUnitDeclaration currTu;
    private SubgraphWalker.ScopedWalker walker;

    @Override
    public void cleanup() {
        this.superTypesMap.clear();
        if (this.recordMap != null) {
            this.recordMap.clear();
        }
        this.enumMap.clear();
    }

    @Override
    public void accept(TranslationResult result) {
        this.walker = new SubgraphWalker.ScopedWalker();
        Iterator<TranslationUnitDeclaration> iterator = result.getTranslationUnits().iterator();
        while (iterator.hasNext()) {
            TranslationUnitDeclaration tu;
            this.currTu = tu = iterator.next();
            this.walker.clearCallbacks();
            this.walker.registerHandler((currClass, parent, currNode) -> this.walker.collectDeclarations((Node)currNode));
            this.walker.registerHandler(this::findRecordsAndEnums);
            this.walker.iterate(this.currTu);
        }
        Map<Type, List> currSuperTypes = this.recordMap.values().stream().collect(Collectors.toMap(r -> new Type(r.getName()), RecordDeclaration::getSuperTypes));
        this.superTypesMap.putAll(currSuperTypes);
        for (TranslationUnitDeclaration tu : result.getTranslationUnits()) {
            this.walker.clearCallbacks();
            this.walker.registerHandler(this::resolveFieldUsages);
            this.walker.iterate(tu);
        }
        for (TranslationUnitDeclaration tu : result.getTranslationUnits()) {
            this.walker.clearCallbacks();
            this.walker.registerHandler(this::resolveLocalVarUsage);
            this.walker.iterate(tu);
        }
    }

    private void findRecordsAndEnums(Node node, RecordDeclaration curClass) {
        if (node instanceof RecordDeclaration) {
            Type type = new Type(node.getName());
            this.recordMap.putIfAbsent(type, (RecordDeclaration)node);
        } else if (node instanceof EnumDeclaration) {
            Type type = new Type(node.getName());
            this.enumMap.putIfAbsent(type, (EnumDeclaration)node);
        }
    }

    private Set<ValueDeclaration> resolveFunctionPtr(Type containingClass, DeclaredReferenceExpression reference) {
        Set<ValueDeclaration> targets = new HashSet<ValueDeclaration>();
        String functionName = reference.getName();
        Matcher matcher = Pattern.compile("(?:(?<class>.*)(?:\\.|::))?(?<function>.*)").matcher(reference.getName());
        if (matcher.matches()) {
            String cls = matcher.group("class");
            String finalFunctionName = functionName = matcher.group("function");
            if (cls == null) {
                targets = this.walker.getAllDeclarationsForScope(reference).stream().filter(FunctionDeclaration.class::isInstance).filter(d -> d.getName().equals(finalFunctionName)).collect(Collectors.toCollection(HashSet::new));
            } else {
                containingClass = new Type(cls);
                if (this.recordMap.containsKey(containingClass)) {
                    targets = this.recordMap.get(containingClass).getMethods().stream().filter(f -> f.getName().equals(finalFunctionName)).map(ValueDeclaration.class::cast).collect(Collectors.toCollection(HashSet::new));
                }
            }
        }
        if (targets.isEmpty()) {
            if (containingClass == null) {
                HashSet<ValueDeclaration> unknownMethod = new HashSet<ValueDeclaration>();
                unknownMethod.add(this.handleUnknownMethod(functionName, reference.getType()));
                return unknownMethod;
            }
            HashSet<ValueDeclaration> unknownClass = new HashSet<ValueDeclaration>();
            unknownClass.add(this.handleUnknownClassMethod(containingClass, functionName, reference.getType()));
            return unknownClass;
        }
        return targets;
    }

    private void resolveLocalVarUsage(RecordDeclaration currentClass, Node parent, Node current) {
        block7: {
            Type recordDeclType;
            Set<ValueDeclaration> refersTo;
            DeclaredReferenceExpression ref;
            block8: {
                block9: {
                    if (!(current instanceof DeclaredReferenceExpression)) break block7;
                    ref = (DeclaredReferenceExpression)current;
                    refersTo = this.walker.getDeclarationForScope(parent, ref.getName()).map(d -> {
                        HashSet<ValueDeclaration> set = new HashSet<ValueDeclaration>();
                        set.add((ValueDeclaration)d);
                        return set;
                    }).orElse(new HashSet());
                    recordDeclType = null;
                    if (currentClass != null) {
                        recordDeclType = new Type(currentClass.getName());
                    }
                    if (!ref.getType().isFunctionPtr()) break block8;
                    if (refersTo.isEmpty()) break block9;
                    if (!refersTo.stream().anyMatch(FunctionDeclaration.class::isInstance)) break block8;
                }
                refersTo = this.resolveFunctionPtr(recordDeclType, ref);
            }
            if (refersTo.isEmpty() && !(current instanceof StaticReferenceExpression) && recordDeclType != null && this.recordMap.containsKey(recordDeclType)) {
                HashSet<ValueDeclaration> resolvedMember = new HashSet<ValueDeclaration>();
                resolvedMember.add(this.resolveMember(recordDeclType, (DeclaredReferenceExpression)current));
                refersTo = resolvedMember;
            }
            if (!refersTo.isEmpty()) {
                ref.setRefersTo(refersTo);
            } else {
                Util.warnWithFileLocation(current, log, "Did not find a declaration for {}", new Object[0]);
            }
        }
    }

    private void resolveFieldUsages(Node current, RecordDeclaration curClass) {
        if (current instanceof MemberExpression) {
            MemberExpression memberExpression = (MemberExpression)current;
            Node base = memberExpression.getBase();
            Node member = memberExpression.getMember();
            if (base instanceof DeclaredReferenceExpression) {
                base = this.resolveBase((DeclaredReferenceExpression)memberExpression.getBase());
            }
            if (member instanceof DeclaredReferenceExpression) {
                if (base instanceof EnumDeclaration) {
                    String name = member.getName();
                    member = ((EnumDeclaration)base).getEntries().stream().filter(e -> e.getName().equals(name)).findFirst().orElse(null);
                } else {
                    Type baseType = Type.getUnknown();
                    if (base instanceof HasType) {
                        baseType = ((HasType)((Object)base)).getType();
                    }
                    if (base instanceof RecordDeclaration) {
                        baseType = new Type(base.getName());
                    }
                    Node node = member = base == null ? null : this.resolveMember(baseType, (DeclaredReferenceExpression)memberExpression.getMember());
                    if (member != null) {
                        HasType typedMember = (HasType)((Object)member);
                        typedMember.setType(memberExpression.getType());
                        HashSet<Type> subTypes = new HashSet<Type>(typedMember.getPossibleSubTypes());
                        subTypes.addAll(memberExpression.getPossibleSubTypes());
                        typedMember.setPossibleSubTypes(subTypes);
                    }
                }
            }
            if (base != null && member != null) {
                if (base != memberExpression.getBase()) {
                    memberExpression.getBase().disconnectFromGraph();
                }
                if (member != memberExpression.getMember()) {
                    memberExpression.getMember().disconnectFromGraph();
                }
                memberExpression.setBase(base);
                memberExpression.setMember(member);
            } else {
                log.warn("Unexpected: null base or member in field usage: {}", (Object)current);
            }
        }
    }

    private Declaration resolveBase(DeclaredReferenceExpression reference) {
        if (this.enumMap.containsKey(reference.getType())) {
            return this.enumMap.get(reference.getType());
        }
        if (this.recordMap.containsKey(reference.getType())) {
            RecordDeclaration recordDeclaration = this.recordMap.get(reference.getType());
            if (reference instanceof StaticReferenceExpression) {
                return recordDeclaration;
            }
            if (recordDeclaration.getThis() != null) {
                return recordDeclaration.getThis();
            }
            return recordDeclaration;
        }
        log.info("Type declaration for {} not found in graph, using dummy to collect all usages", (Object)reference.getType());
        return this.handleUnknownField(reference.getType(), reference);
    }

    private ValueDeclaration resolveMember(Type containingClass, DeclaredReferenceExpression reference) {
        Optional<FieldDeclaration> member = Optional.empty();
        if (!TypeManager.getInstance().isUnknown(containingClass) && this.recordMap.containsKey(containingClass)) {
            member = this.recordMap.get(containingClass).getFields().stream().filter(f -> f.getName().equals(reference.getName())).findFirst();
        }
        if (member.isEmpty()) {
            member = this.superTypesMap.getOrDefault(containingClass, Collections.emptyList()).stream().map(this.recordMap::get).filter(Objects::nonNull).flatMap(r -> r.getFields().stream()).filter(f -> f.getName().equals(reference.getName())).findFirst();
        }
        return member.orElseGet(() -> this.handleUnknownField(containingClass, reference));
    }

    private FieldDeclaration handleUnknownField(Type base, DeclaredReferenceExpression reference) {
        this.recordMap.putIfAbsent(base, NodeBuilder.newRecordDeclaration(base.getTypeName(), new ArrayList<Type>(), "UNKNOWN", "UNKNOWN"));
        List<FieldDeclaration> declarations = this.recordMap.get(base).getFields();
        Optional<FieldDeclaration> target = declarations.stream().filter(f -> f.getName().equals(reference.getName())).findFirst();
        if (target.isEmpty()) {
            FieldDeclaration declaration = NodeBuilder.newFieldDeclaration(reference.getName(), reference.getType(), Collections.emptyList(), "", null, null);
            declarations.add(declaration);
            declaration.setImplicit(true);
            return declaration;
        }
        return target.get();
    }

    private MethodDeclaration handleUnknownClassMethod(Type base, String name, Type type) {
        this.recordMap.putIfAbsent(base, NodeBuilder.newRecordDeclaration(base.getTypeName(), new ArrayList<Type>(), "UNKNOWN", "UNKNOWN"));
        RecordDeclaration containingRecord = this.recordMap.get(base);
        List<MethodDeclaration> declarations = containingRecord.getMethods();
        Optional<MethodDeclaration> target = declarations.stream().filter(f -> f.getName().equals(name)).findFirst();
        if (target.isEmpty()) {
            MethodDeclaration declaration = NodeBuilder.newMethodDeclaration(name, "", false, containingRecord);
            declaration.setType(type);
            declarations.add(declaration);
            declaration.setImplicit(true);
            return declaration;
        }
        return target.get();
    }

    private FunctionDeclaration handleUnknownMethod(String name, Type type) {
        Optional<FunctionDeclaration> target = this.currTu.getDeclarations().stream().filter(FunctionDeclaration.class::isInstance).map(FunctionDeclaration.class::cast).filter(f -> f.getName().equals(name)).findFirst();
        if (target.isEmpty()) {
            FunctionDeclaration declaration = NodeBuilder.newFunctionDeclaration(name, "");
            declaration.setType(type);
            this.currTu.getDeclarations().add(declaration);
            declaration.setImplicit(true);
            return declaration;
        }
        return target.get();
    }
}

