/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes;

import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.graph.ArrayCreationExpression;
import de.fraunhofer.aisec.cpg.graph.ArraySubscriptionExpression;
import de.fraunhofer.aisec.cpg.graph.AssertStatement;
import de.fraunhofer.aisec.cpg.graph.BinaryOperator;
import de.fraunhofer.aisec.cpg.graph.BreakStatement;
import de.fraunhofer.aisec.cpg.graph.CallExpression;
import de.fraunhofer.aisec.cpg.graph.CaseStatement;
import de.fraunhofer.aisec.cpg.graph.CastExpression;
import de.fraunhofer.aisec.cpg.graph.CatchClause;
import de.fraunhofer.aisec.cpg.graph.CompoundStatement;
import de.fraunhofer.aisec.cpg.graph.CompoundStatementExpression;
import de.fraunhofer.aisec.cpg.graph.ConditionalExpression;
import de.fraunhofer.aisec.cpg.graph.ConstructExpression;
import de.fraunhofer.aisec.cpg.graph.ConstructorDeclaration;
import de.fraunhofer.aisec.cpg.graph.ContinueStatement;
import de.fraunhofer.aisec.cpg.graph.Declaration;
import de.fraunhofer.aisec.cpg.graph.DeclarationStatement;
import de.fraunhofer.aisec.cpg.graph.DeclaredReferenceExpression;
import de.fraunhofer.aisec.cpg.graph.DefaultStatement;
import de.fraunhofer.aisec.cpg.graph.DeleteExpression;
import de.fraunhofer.aisec.cpg.graph.DoStatement;
import de.fraunhofer.aisec.cpg.graph.EmptyStatement;
import de.fraunhofer.aisec.cpg.graph.Expression;
import de.fraunhofer.aisec.cpg.graph.ExpressionList;
import de.fraunhofer.aisec.cpg.graph.ForEachStatement;
import de.fraunhofer.aisec.cpg.graph.ForStatement;
import de.fraunhofer.aisec.cpg.graph.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.GotoStatement;
import de.fraunhofer.aisec.cpg.graph.IfStatement;
import de.fraunhofer.aisec.cpg.graph.InitializerListExpression;
import de.fraunhofer.aisec.cpg.graph.LabelStatement;
import de.fraunhofer.aisec.cpg.graph.Literal;
import de.fraunhofer.aisec.cpg.graph.MemberCallExpression;
import de.fraunhofer.aisec.cpg.graph.MemberExpression;
import de.fraunhofer.aisec.cpg.graph.MethodDeclaration;
import de.fraunhofer.aisec.cpg.graph.NewExpression;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.ReturnStatement;
import de.fraunhofer.aisec.cpg.graph.Statement;
import de.fraunhofer.aisec.cpg.graph.SwitchStatement;
import de.fraunhofer.aisec.cpg.graph.SynchronizedStatement;
import de.fraunhofer.aisec.cpg.graph.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.TryStatement;
import de.fraunhofer.aisec.cpg.graph.Type;
import de.fraunhofer.aisec.cpg.graph.TypeIdExpression;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.UnaryOperator;
import de.fraunhofer.aisec.cpg.graph.VariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.WhileStatement;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import de.fraunhofer.aisec.cpg.passes.Pass;
import de.fraunhofer.aisec.cpg.passes.scopes.DeclarationScope;
import de.fraunhofer.aisec.cpg.passes.scopes.FunctionScope;
import de.fraunhofer.aisec.cpg.passes.scopes.LoopScope;
import de.fraunhofer.aisec.cpg.passes.scopes.Scope;
import de.fraunhofer.aisec.cpg.passes.scopes.SwitchScope;
import de.fraunhofer.aisec.cpg.passes.scopes.TryScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluationOrderGraphPass
extends Pass {
    private static final Logger LOGGER = LoggerFactory.getLogger(EvaluationOrderGraphPass.class);
    private List<Node> currentEOG = new ArrayList<Node>();
    private List<Node> intermediateNodes = new ArrayList<Node>();

    private static boolean reachableFromValidEOGRoot(@NonNull Node node) {
        HashSet<Node> passedBy = new HashSet<Node>();
        ArrayList<Node> workList = new ArrayList<Node>(node.getPrevEOG());
        while (!workList.isEmpty()) {
            Node toProcess = (Node)workList.get(0);
            workList.remove(toProcess);
            passedBy.add(toProcess);
            if (toProcess instanceof FunctionDeclaration) {
                return true;
            }
            for (Node pred : toProcess.getPrevEOG()) {
                if (passedBy.contains(pred) || workList.contains(pred)) continue;
                workList.add(pred);
            }
        }
        return false;
    }

    @Override
    public void cleanup() {
        this.intermediateNodes.clear();
        this.currentEOG.clear();
    }

    @Override
    public void accept(TranslationResult result) {
        for (TranslationUnitDeclaration tu : result.getTranslationUnits()) {
            this.handleDeclaration(tu);
            this.removeUnreachableEOGEdges(tu);
        }
    }

    private void truncateLooseEdges(@NonNull List<Node> eogSources) {
        for (Node eogSourceNode : eogSources) {
            if (eogSourceNode instanceof FunctionDeclaration) continue;
            ArrayList<Node> nextNodes = new ArrayList<Node>(eogSourceNode.getNextEOG());
            eogSourceNode.getNextEOG().clear();
            nextNodes.forEach(node -> node.getPrevEOG().remove(eogSourceNode));
            this.truncateLooseEdges(nextNodes.stream().filter(node -> node.getPrevEOG().isEmpty() && !node.getNextEOG().isEmpty()).collect(Collectors.toList()));
        }
    }

    private void removeUnreachableEOGEdges(@NonNull TranslationUnitDeclaration tu) {
        List eognodes = SubgraphWalker.flattenAST(tu).stream().filter(node -> !node.getPrevEOG().isEmpty() || !node.getNextEOG().isEmpty()).collect(Collectors.toList());
        Set validStarts = eognodes.stream().filter(node -> node instanceof FunctionDeclaration).collect(Collectors.toSet());
        while (!validStarts.isEmpty()) {
            eognodes.removeAll(validStarts);
            validStarts = validStarts.stream().flatMap(node -> node.getNextEOG().stream()).filter(eognodes::contains).collect(Collectors.toSet());
        }
        for (Node unvisitedNode : eognodes) {
            unvisitedNode.getNextEOG().forEach(next -> next.getPrevEOG().remove(unvisitedNode));
            unvisitedNode.getNextEOG().clear();
        }
    }

    private void handleDeclaration(@Nullable Declaration declaration) {
        if (declaration == null) {
            return;
        }
        if (this.lang == null) {
            LOGGER.warn("Will not handle declaration - no information about frontend available.");
            return;
        }
        this.intermediateNodes.add(declaration);
        if (declaration instanceof TranslationUnitDeclaration) {
            for (Declaration child : ((TranslationUnitDeclaration)declaration).getDeclarations()) {
                this.handleDeclaration(child);
            }
            this.lang.clearProcessed();
        } else if (declaration instanceof RecordDeclaration) {
            this.lang.getScopeManager().enterScope(declaration);
            this.currentEOG.clear();
            for (ConstructorDeclaration constructor : ((RecordDeclaration)declaration).getConstructors()) {
                this.handleDeclaration(constructor);
            }
            for (MethodDeclaration method : ((RecordDeclaration)declaration).getMethods()) {
                this.handleDeclaration(method);
            }
            this.lang.getScopeManager().leaveScope(declaration);
        } else if (declaration instanceof FunctionDeclaration) {
            FunctionDeclaration funcDecl = (FunctionDeclaration)declaration;
            this.currentEOG.clear();
            this.lang.getScopeManager().enterScope(declaration);
            this.pushToEOG(declaration);
            if (funcDecl.hasBody()) {
                this.createEOG(((FunctionDeclaration)declaration).getBody());
            }
            FunctionScope scope = (FunctionScope)this.lang.getScopeManager().getCurrentScope();
            List<Node> uncaughtEOGThrows = scope.getCatchesOrRelays().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            this.addMultipleIncomingEOGEdges(uncaughtEOGThrows, funcDecl.getBody());
            this.lang.getScopeManager().leaveScope(declaration);
        } else if (declaration instanceof VariableDeclaration) {
            this.createEOG(((VariableDeclaration)declaration).getInitializer());
            this.pushToEOG(declaration);
        } else {
            this.pushToEOG(declaration);
        }
    }

    private void createEOG(@Nullable Statement statement) {
        if (statement == null) {
            return;
        }
        if (this.lang == null) {
            LOGGER.warn("Skipping EOG construction - no information about frontend available.");
            return;
        }
        this.intermediateNodes.add(statement);
        if (statement instanceof CallExpression) {
            CallExpression callExpression = (CallExpression)statement;
            if (callExpression instanceof MemberCallExpression && ((MemberCallExpression)callExpression).getBase() instanceof Statement) {
                this.createEOG((Statement)((MemberCallExpression)callExpression).getBase());
            }
            for (Expression arg : callExpression.getArguments()) {
                this.createEOG(arg);
            }
            this.pushToEOG(statement);
        } else if (statement instanceof MemberExpression) {
            if (((MemberExpression)statement).getBase() instanceof Statement) {
                this.createEOG((Statement)((MemberExpression)statement).getBase());
            }
            if (((MemberExpression)statement).getMember() instanceof Statement) {
                this.createEOG((Statement)((MemberExpression)statement).getMember());
            }
            this.pushToEOG(statement);
        } else if (statement instanceof ArraySubscriptionExpression) {
            ArraySubscriptionExpression arraySubs = (ArraySubscriptionExpression)statement;
            this.createEOG(arraySubs.getArrayExpression());
            this.createEOG(arraySubs.getSubscriptExpression());
            this.pushToEOG(statement);
        } else if (statement instanceof ArrayCreationExpression) {
            ArrayCreationExpression arrayCreate = (ArrayCreationExpression)statement;
            for (Expression dimension : arrayCreate.getDimensions()) {
                if (dimension == null) continue;
                this.createEOG(dimension);
            }
            this.createEOG(arrayCreate.getInitializer());
            this.pushToEOG(statement);
        } else if (statement instanceof DeclarationStatement) {
            for (Declaration declaration : ((DeclarationStatement)statement).getDeclarations()) {
                if (!(declaration instanceof VariableDeclaration)) continue;
                this.handleDeclaration(declaration);
            }
            this.pushToEOG(statement);
        } else if (statement instanceof ReturnStatement) {
            this.createEOG(((ReturnStatement)statement).getReturnValue());
            this.pushToEOG(statement);
            this.currentEOG.clear();
        } else if (statement instanceof BinaryOperator) {
            BinaryOperator binOp = (BinaryOperator)statement;
            this.createEOG(binOp.getLhs());
            ArrayList<Node> shortCircuitNodes = new ArrayList<Node>();
            if (binOp.getOperatorCode().equals("&&") || binOp.getOperatorCode().equals("||")) {
                shortCircuitNodes.addAll(this.currentEOG);
            }
            this.createEOG(binOp.getRhs());
            shortCircuitNodes.addAll(this.currentEOG);
            this.setCurrentEOGs(shortCircuitNodes);
            this.pushToEOG(statement);
        } else if (statement instanceof UnaryOperator) {
            Expression input = ((UnaryOperator)statement).getInput();
            this.createEOG(input);
            if (((UnaryOperator)statement).getOperatorCode().equals("throw")) {
                Type throwType;
                Scope catchingScope = this.lang.getScopeManager().getFirstScopeThat(scope -> scope instanceof TryScope || scope instanceof FunctionScope);
                if (input != null) {
                    throwType = input.getType();
                } else {
                    Scope decl = this.lang.getScopeManager().getFirstScopeThat(scope -> scope.getClass().equals(DeclarationScope.class));
                    if (decl != null && decl.getAstNode() instanceof CatchClause && ((CatchClause)decl.getAstNode()).getParameter() != null) {
                        VariableDeclaration param = ((CatchClause)decl.getAstNode()).getParameter();
                        assert (param != null);
                        throwType = param.getType();
                    } else {
                        LOGGER.info("Unknown throw type, potentially throw; in a method");
                        throwType = new Type("UNKNOWN_THROW_TYPE");
                    }
                }
                this.pushToEOG(statement);
                if (catchingScope instanceof TryScope) {
                    ((TryScope)catchingScope).getCatchesOrRelays().put(throwType, new ArrayList<Node>(this.currentEOG));
                } else if (catchingScope instanceof FunctionScope) {
                    ((FunctionScope)catchingScope).getCatchesOrRelays().put(throwType, new ArrayList<Node>(this.currentEOG));
                }
                this.currentEOG.clear();
            } else {
                this.pushToEOG(statement);
            }
        } else if (statement instanceof CompoundStatement) {
            this.lang.getScopeManager().enterScope(statement);
            for (Statement child : ((CompoundStatement)statement).getStatements()) {
                this.createEOG(child);
            }
            this.lang.getScopeManager().leaveScope(statement);
            this.pushToEOG(statement);
        } else if (statement instanceof CompoundStatementExpression) {
            this.createEOG(((CompoundStatementExpression)statement).getStatement());
            this.pushToEOG(statement);
        } else if (statement instanceof IfStatement) {
            this.handleIfStatement((IfStatement)statement);
        } else if (statement instanceof AssertStatement) {
            AssertStatement ifs = (AssertStatement)statement;
            this.createEOG(ifs.getCondition());
            ArrayList<Node> openConditionEOGs = new ArrayList<Node>(this.currentEOG);
            this.createEOG(ifs.getMessage());
            this.setCurrentEOGs(openConditionEOGs);
            this.pushToEOG(statement);
        } else if (statement instanceof WhileStatement) {
            this.handleWhileStatement((WhileStatement)statement);
        } else if (statement instanceof DoStatement) {
            this.handleDoStatement((DoStatement)statement);
        } else if (statement instanceof ForStatement) {
            this.handleForStatement((ForStatement)statement);
        } else if (statement instanceof ForEachStatement) {
            this.handleForEachStatement((ForEachStatement)statement);
        } else if (statement instanceof TryStatement) {
            Scope scope2;
            this.lang.getScopeManager().enterScope(statement);
            TryScope tryScope = (TryScope)this.lang.getScopeManager().getCurrentScope();
            TryStatement tryStmt = (TryStatement)statement;
            if (tryStmt.getResources() != null) {
                tryStmt.getResources().forEach(this::createEOG);
            }
            this.createEOG(tryStmt.getTryBlock());
            ArrayList<Node> tmpEOGNodes = new ArrayList<Node>(this.currentEOG);
            Map<Type, List<Node>> catchesOrRelays = tryScope.getCatchesOrRelays();
            for (CatchClause catchClause : tryStmt.getCatchClauses()) {
                this.currentEOG.clear();
                HashSet<Type> hashSet = new HashSet<Type>();
                for (Map.Entry<Type, List<Node>> entry2 : catchesOrRelays.entrySet()) {
                    Type throwType = entry2.getKey();
                    List<Node> eogEdges = entry2.getValue();
                    if (catchClause.getParameter() == null) {
                        this.currentEOG.addAll(eogEdges);
                        continue;
                    }
                    if (!TypeManager.getInstance().isSupertypeOf(catchClause.getParameter().getType(), throwType)) continue;
                    this.currentEOG.addAll(eogEdges);
                    hashSet.add(throwType);
                }
                hashSet.forEach(catchesOrRelays::remove);
                this.createEOG(catchClause.getBody());
                tmpEOGNodes.addAll(this.currentEOG);
            }
            boolean canTerminateExceptionfree = tmpEOGNodes.stream().anyMatch(EvaluationOrderGraphPass::reachableFromValidEOGRoot);
            this.currentEOG.clear();
            this.currentEOG.addAll(tmpEOGNodes);
            if (tryStmt.getFinallyBlock() != null) {
                this.currentEOG.addAll(catchesOrRelays.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream()).collect(Collectors.toList()));
                this.createEOG(tryStmt.getFinallyBlock());
                for (Map.Entry<Type, List<Node>> entry2 : catchesOrRelays.entrySet()) {
                    entry2.getValue().clear();
                    entry2.getValue().addAll(this.currentEOG);
                }
            }
            if ((scope2 = this.lang.getScopeManager().getFirstScopeThat(this.lang.getScopeManager().getCurrentScope().getParent(), scope -> scope instanceof TryScope || scope instanceof FunctionScope)) != null) {
                Map<Type, List<Node>> map = scope2 instanceof TryScope ? ((TryScope)scope2).getCatchesOrRelays() : ((FunctionScope)scope2).getCatchesOrRelays();
                for (Map.Entry<Type, List<Node>> entry3 : catchesOrRelays.entrySet()) {
                    List catches = map.getOrDefault(entry3.getKey(), new ArrayList());
                    catches.addAll(entry3.getValue());
                    map.put(entry3.getKey(), catches);
                }
            }
            this.lang.getScopeManager().leaveScope(statement);
            if (!canTerminateExceptionfree) {
                this.currentEOG.clear();
            }
            this.pushToEOG(statement);
        } else if (statement instanceof ContinueStatement) {
            this.pushToEOG(statement);
            this.lang.getScopeManager().addContinueStatement((ContinueStatement)statement);
            this.currentEOG.clear();
        } else if (statement instanceof DeleteExpression) {
            this.createEOG(((DeleteExpression)statement).getOperand());
            this.pushToEOG(statement);
        } else if (statement instanceof BreakStatement) {
            this.pushToEOG(statement);
            this.lang.getScopeManager().addBreakStatement((BreakStatement)statement);
            this.currentEOG.clear();
        } else if (statement instanceof SwitchStatement) {
            this.handleSwitchStatement((SwitchStatement)statement);
        } else if (statement instanceof LabelStatement) {
            this.lang.getScopeManager().addLabelStatement((LabelStatement)statement);
            this.createEOG(((LabelStatement)statement).getSubStatement());
        } else if (statement instanceof GotoStatement) {
            GotoStatement gotoStatement = (GotoStatement)statement;
            this.pushToEOG(gotoStatement);
            if (gotoStatement.getTargetLabel() != null) {
                this.lang.registerObjectListener(gotoStatement.getTargetLabel(), (from, to) -> this.addEOGEdge(gotoStatement, (Node)to));
            }
            this.currentEOG.clear();
        } else if (statement instanceof CaseStatement) {
            this.createEOG(((CaseStatement)statement).getCaseExpression());
            this.pushToEOG(statement);
        } else if (statement instanceof SynchronizedStatement) {
            this.handleSynchronizedStatement((SynchronizedStatement)statement);
        } else if (statement instanceof EmptyStatement) {
            this.pushToEOG(statement);
        } else if (statement instanceof Literal) {
            this.pushToEOG(statement);
        } else if (statement instanceof DefaultStatement) {
            this.pushToEOG(statement);
        } else if (statement instanceof TypeIdExpression) {
            this.pushToEOG(statement);
        } else if (statement instanceof NewExpression) {
            NewExpression newStmt = (NewExpression)statement;
            this.createEOG(newStmt.getInitializer());
            this.pushToEOG(statement);
        } else if (statement instanceof CastExpression) {
            CastExpression castExpr = (CastExpression)statement;
            this.createEOG(castExpr.getExpression());
            this.pushToEOG(castExpr);
        } else if (statement instanceof ExpressionList) {
            ExpressionList exprList = (ExpressionList)statement;
            for (Statement expr : exprList.getExpressions()) {
                this.createEOG(expr);
            }
            this.pushToEOG(statement);
        } else if (statement instanceof ConditionalExpression) {
            this.handleConditionalExpression((ConditionalExpression)statement);
        } else if (statement instanceof InitializerListExpression) {
            InitializerListExpression initList = (InitializerListExpression)statement;
            for (Expression inits : initList.getInitializers()) {
                this.createEOG(inits);
            }
            this.pushToEOG(statement);
        } else if (statement instanceof ConstructExpression) {
            ConstructExpression constructExpr = (ConstructExpression)statement;
            for (Expression arg : constructExpr.getArguments()) {
                this.createEOG(arg);
            }
            this.pushToEOG(statement);
        } else if (statement instanceof DeclaredReferenceExpression) {
            this.pushToEOG(statement);
        } else {
            this.pushToEOG(statement);
        }
    }

    public <T extends Node> void pushToEOG(@NonNull T node) {
        if (this.lang == null) {
            LOGGER.warn("Not pushing to EOG - no information about frontend available.");
            return;
        }
        LOGGER.debug("Pushing {} {} to EOG", (Object)node.getClass().getSimpleName(), node);
        for (Node intermediate : this.intermediateNodes) {
            this.lang.process(intermediate, node);
        }
        this.addMultipleIncomingEOGEdges(this.currentEOG, node);
        this.intermediateNodes.clear();
        this.currentEOG.clear();
        this.currentEOG.add(node);
    }

    public List<Node> getCurrentEOG() {
        return this.currentEOG;
    }

    public void setCurrentEOG(List<Node> currentEOG) {
        this.currentEOG = currentEOG;
    }

    public void setCurrentEOG(Node node) {
        LOGGER.debug("Setting {} to EOG", (Object)node);
        this.currentEOG = new ArrayList<Node>();
        this.currentEOG.add(node);
    }

    public <T extends Node> void setCurrentEOGs(List<T> nodes) {
        LOGGER.debug("Setting {} to EOGs", nodes);
        this.currentEOG = new ArrayList<T>(nodes);
    }

    public void addToCurrentEOG(List<Node> nodes) {
        LOGGER.debug("Adding {} to current EOG", nodes);
        this.currentEOG.addAll(nodes);
    }

    public void exitLoop(@NonNull Statement loopStatement, @NonNull LoopScope loopScope) {
        this.currentEOG.addAll(loopScope.getBreakStatements());
        ArrayList<ContinueStatement> continues = new ArrayList<ContinueStatement>(loopScope.getContinueStatements());
        if (!continues.isEmpty()) {
            Statement condition = loopStatement instanceof DoStatement ? ((DoStatement)loopStatement).getCondition() : (loopStatement instanceof ForStatement ? ((ForStatement)loopStatement).getCondition() : (loopStatement instanceof ForEachStatement ? loopStatement : (loopStatement instanceof AssertStatement ? loopStatement : ((WhileStatement)loopStatement).getCondition())));
            List<Node> conditions = SubgraphWalker.getEOGPathEdges(condition).getEntries();
            conditions.forEach(node -> this.addMultipleIncomingEOGEdges((List<Node>)continues, (Node)node));
        }
    }

    public void connectCurrentToLoopStart() {
        if (this.lang == null) {
            LOGGER.warn("Skipping connection of EOG loop to start - no information about frontend available.");
            return;
        }
        LoopScope loopScope = (LoopScope)this.lang.getScopeManager().getFirstScopeThat(scope -> scope instanceof LoopScope);
        if (loopScope == null) {
            LOGGER.error("I am unexpectedly not in a loop, cannot add edge to loop start");
            return;
        }
        loopScope.starts().forEach(node -> this.addMultipleIncomingEOGEdges(this.currentEOG, (Node)node));
    }

    public void addEOGEdge(Node prev, Node next) {
        prev.getNextEOG().add(next);
        next.getPrevEOG().add(prev);
    }

    public void addMultipleIncomingEOGEdges(List<Node> prevs, Node next) {
        prevs.forEach(prev -> this.addEOGEdge((Node)prev, next));
    }

    private void handleSynchronizedStatement(SynchronizedStatement synch) {
        this.createEOG(synch.getExpression());
        this.pushToEOG(synch);
        this.createEOG(synch.getBlockStatement());
    }

    private void handleConditionalExpression(ConditionalExpression conditionalExpression) {
        ArrayList<Node> openBranchNodes = new ArrayList<Node>();
        this.createEOG(conditionalExpression.getCondition());
        this.pushToEOG(conditionalExpression);
        ArrayList<Node> openConditionEOGs = new ArrayList<Node>(this.currentEOG);
        this.createEOG(conditionalExpression.getThenExpr());
        openBranchNodes.addAll(this.currentEOG);
        this.setCurrentEOGs(openConditionEOGs);
        this.createEOG(conditionalExpression.getElseExpr());
        openBranchNodes.addAll(this.currentEOG);
        this.setCurrentEOGs(openBranchNodes);
    }

    private void handleDoStatement(DoStatement doStatement) {
        this.lang.getScopeManager().enterScope(doStatement);
        this.createEOG(doStatement.getStatement());
        this.createEOG(doStatement.getCondition());
        this.pushToEOG(doStatement);
        this.connectCurrentToLoopStart();
        LoopScope currentLoopScope = (LoopScope)this.lang.getScopeManager().leaveScope(doStatement);
        if (currentLoopScope != null) {
            this.exitLoop(doStatement, currentLoopScope);
        } else {
            LOGGER.error("Trying to exit do loop, but no loop scope: {}", (Object)doStatement.toString());
        }
    }

    private void handleForEachStatement(ForEachStatement forEachStatement) {
        this.lang.getScopeManager().enterScope(forEachStatement);
        this.createEOG(forEachStatement.getIterable());
        this.handleDeclaration(forEachStatement.getVariable());
        this.pushToEOG(forEachStatement);
        ArrayList<Node> tmpEOGNodes = new ArrayList<Node>(this.currentEOG);
        this.createEOG(forEachStatement.getStatement());
        this.connectCurrentToLoopStart();
        this.currentEOG.clear();
        LoopScope currentLoopScope = (LoopScope)this.lang.getScopeManager().leaveScope(forEachStatement);
        if (currentLoopScope != null) {
            this.exitLoop(forEachStatement, currentLoopScope);
        } else {
            LOGGER.error("Trying to exit foreach loop, but not in loop scope: {}", (Object)forEachStatement.toString());
        }
        this.currentEOG.addAll(tmpEOGNodes);
    }

    private void handleForStatement(ForStatement forStatement) {
        this.lang.getScopeManager().enterScope(forStatement);
        ForStatement forStmt = forStatement;
        this.createEOG(forStmt.getInitializerStatement());
        this.handleDeclaration(forStmt.getConditionDeclaration());
        this.createEOG(forStmt.getCondition());
        this.pushToEOG(forStatement);
        ArrayList<Node> tmpEOGNodes = new ArrayList<Node>(this.currentEOG);
        this.createEOG(forStmt.getStatement());
        this.createEOG(forStmt.getIterationExpression());
        this.connectCurrentToLoopStart();
        this.currentEOG.clear();
        LoopScope currentLoopScope = (LoopScope)this.lang.getScopeManager().leaveScope(forStatement);
        if (currentLoopScope != null) {
            this.exitLoop(forStatement, currentLoopScope);
        } else {
            LOGGER.error("Trying to exit for loop, but no loop scope: {}", (Object)forStatement.toString());
        }
        this.currentEOG.addAll(tmpEOGNodes);
    }

    private void handleIfStatement(IfStatement ifStatement) {
        ArrayList<Node> openBranchNodes = new ArrayList<Node>();
        this.lang.getScopeManager().enterScope(ifStatement);
        this.createEOG(ifStatement.getInitializerStatement());
        this.handleDeclaration(ifStatement.getConditionDeclaration());
        this.createEOG(ifStatement.getCondition());
        this.pushToEOG(ifStatement);
        ArrayList<Node> openConditionEOGs = new ArrayList<Node>(this.currentEOG);
        this.createEOG(ifStatement.getThenStatement());
        openBranchNodes.addAll(this.currentEOG);
        if (ifStatement.getElseStatement() != null) {
            this.setCurrentEOGs(openConditionEOGs);
            this.createEOG(ifStatement.getElseStatement());
            openBranchNodes.addAll(this.currentEOG);
        } else {
            openBranchNodes.addAll(openConditionEOGs);
        }
        this.lang.getScopeManager().leaveScope(ifStatement);
        this.setCurrentEOGs(openBranchNodes);
    }

    private void handleSwitchStatement(SwitchStatement switchStatement) {
        CompoundStatement compound;
        this.lang.getScopeManager().enterScope(switchStatement);
        this.createEOG(switchStatement.getInitializerStatement());
        this.handleDeclaration(switchStatement.getSelectorDeclaration());
        this.createEOG(switchStatement.selector);
        this.pushToEOG(switchStatement);
        ArrayList<Node> tmp = new ArrayList<Node>(this.currentEOG);
        if (switchStatement.getStatement() instanceof DoStatement) {
            this.createEOG(switchStatement.getStatement());
            compound = (CompoundStatement)((DoStatement)switchStatement.getStatement()).getStatement();
        } else {
            compound = (CompoundStatement)switchStatement.getStatement();
        }
        this.currentEOG = new ArrayList<Node>();
        for (Statement subStatement : compound.getStatements()) {
            if (subStatement instanceof CaseStatement || subStatement instanceof DefaultStatement) {
                this.currentEOG.addAll(tmp);
            }
            this.createEOG(subStatement);
        }
        this.pushToEOG(compound);
        SwitchScope switchScope = (SwitchScope)this.lang.getScopeManager().leaveScope(switchStatement);
        if (switchScope != null) {
            this.currentEOG.addAll(switchScope.getBreakStatements());
        } else {
            LOGGER.error("Handling switch statement, but not in switch scope: {}", (Object)switchStatement.toString());
        }
    }

    private void handleWhileStatement(WhileStatement whileStatement) {
        this.lang.getScopeManager().enterScope(whileStatement);
        this.handleDeclaration(whileStatement.getConditionDeclaration());
        this.createEOG(whileStatement.getCondition());
        this.pushToEOG(whileStatement);
        ArrayList<Node> tmpEOGNodes = new ArrayList<Node>(this.currentEOG);
        this.createEOG(whileStatement.getStatement());
        this.connectCurrentToLoopStart();
        this.currentEOG.clear();
        LoopScope currentLoopScope = (LoopScope)this.lang.getScopeManager().leaveScope(whileStatement);
        if (currentLoopScope != null) {
            this.exitLoop(whileStatement, currentLoopScope);
        } else {
            LOGGER.error("Trying to exit while loop, but no loop scope: {}", (Object)whileStatement.toString());
        }
        this.currentEOG.addAll(tmpEOGNodes);
    }
}

