/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.passes;

import de.fraunhofer.aisec.cpg.TranslationResult;
import de.fraunhofer.aisec.cpg.graph.CallExpression;
import de.fraunhofer.aisec.cpg.graph.ConstructExpression;
import de.fraunhofer.aisec.cpg.graph.ConstructorDeclaration;
import de.fraunhofer.aisec.cpg.graph.DeclaredReferenceExpression;
import de.fraunhofer.aisec.cpg.graph.ExplicitConstructorInvocation;
import de.fraunhofer.aisec.cpg.graph.Expression;
import de.fraunhofer.aisec.cpg.graph.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.MemberCallExpression;
import de.fraunhofer.aisec.cpg.graph.MethodDeclaration;
import de.fraunhofer.aisec.cpg.graph.NewExpression;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.NodeBuilder;
import de.fraunhofer.aisec.cpg.graph.ParamVariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.StaticCallExpression;
import de.fraunhofer.aisec.cpg.graph.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.Type;
import de.fraunhofer.aisec.cpg.graph.ValueDeclaration;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import de.fraunhofer.aisec.cpg.passes.Pass;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallResolver
extends Pass {
    private static final Logger LOGGER = LoggerFactory.getLogger(CallResolver.class);
    private Map<String, RecordDeclaration> recordMap = new HashMap<String, RecordDeclaration>();
    private Map<FunctionDeclaration, Type> containingType = new HashMap<FunctionDeclaration, Type>();
    private @Nullable TranslationUnitDeclaration currentTU;

    @Override
    public void cleanup() {
        this.containingType.clear();
        this.currentTU = null;
    }

    @Override
    public void accept(@NonNull TranslationResult translationResult) {
        SubgraphWalker.ScopedWalker walker = new SubgraphWalker.ScopedWalker();
        walker.registerHandler(this::findRecords);
        walker.registerHandler(this::registerMethods);
        for (TranslationUnitDeclaration tu : translationResult.getTranslationUnits()) {
            walker.iterate(tu);
        }
        walker.clearCallbacks();
        walker.registerHandler(this::resolve);
        for (TranslationUnitDeclaration tu : translationResult.getTranslationUnits()) {
            walker.iterate(tu);
        }
    }

    private void findRecords(@NonNull Node node, RecordDeclaration curClass) {
        if (node instanceof RecordDeclaration) {
            this.recordMap.putIfAbsent(node.getName(), (RecordDeclaration)node);
        }
    }

    private void registerMethods(RecordDeclaration currentClass, Node parent, @NonNull Node currentNode) {
        if (currentNode instanceof MethodDeclaration && currentClass != null) {
            this.containingType.put((FunctionDeclaration)currentNode, new Type(currentClass.getName()));
        }
    }

    private void resolve(@NonNull Node node, RecordDeclaration curClass) {
        if (node instanceof TranslationUnitDeclaration) {
            this.currentTU = (TranslationUnitDeclaration)node;
        } else if (node instanceof ExplicitConstructorInvocation) {
            ExplicitConstructorInvocation eci = (ExplicitConstructorInvocation)node;
            if (eci.getContainingClass() != null) {
                RecordDeclaration record = this.recordMap.get(eci.getContainingClass());
                List<Type> signature = eci.getArguments().stream().map(Expression::getType).collect(Collectors.toList());
                if (record != null) {
                    ConstructorDeclaration constructor = this.getConstructorDeclaration(signature, record);
                    ArrayList<FunctionDeclaration> invokes = new ArrayList<FunctionDeclaration>();
                    if (constructor != null) {
                        invokes.add(constructor);
                    }
                    eci.setInvokes(invokes);
                }
            }
        } else if (node instanceof CallExpression) {
            Node member;
            CallExpression call = (CallExpression)node;
            if (call instanceof MemberCallExpression && (member = ((MemberCallExpression)call).getMember()) instanceof HasType && ((HasType)((Object)member)).getType().isFunctionPtr()) {
                ArrayList<FunctionDeclaration> invocationCandidates = new ArrayList<FunctionDeclaration>();
                ArrayDeque<Node> worklist = new ArrayDeque<Node>();
                Set seen = Collections.newSetFromMap(new IdentityHashMap());
                worklist.push(member);
                DeclaredReferenceExpression finalReference = null;
                while (!worklist.isEmpty()) {
                    Node curr = (Node)worklist.pop();
                    if (!seen.add(curr)) continue;
                    if (curr instanceof FunctionDeclaration) {
                        if (((FunctionDeclaration)curr).hasSignature(call.getSignature())) {
                            invocationCandidates.add((FunctionDeclaration)curr);
                            continue;
                        }
                        if (!curr.isImplicit()) continue;
                        if (((FunctionDeclaration)curr).hasSignature(call.getSignature())) {
                            invocationCandidates.add((FunctionDeclaration)curr);
                            if (finalReference == null || !finalReference.getRefersTo().contains(curr)) continue;
                            finalReference.setRefersTo((ValueDeclaration)curr);
                            continue;
                        }
                        FunctionDeclaration dummy = this.createDummyWithMatchingSignature((FunctionDeclaration)curr, call.getSignature());
                        invocationCandidates.add(dummy);
                        if (finalReference == null || !finalReference.getRefersTo().contains(curr)) continue;
                        finalReference.setRefersTo(dummy);
                        continue;
                    }
                    if (curr instanceof DeclaredReferenceExpression) {
                        finalReference = (DeclaredReferenceExpression)curr;
                    }
                    curr.getPrevDFG().forEach(worklist::push);
                }
                call.setInvokes(invocationCandidates);
                return;
            }
            if (curClass == null && this.currentTU != null) {
                List<FunctionDeclaration> invocationCandidates = this.currentTU.getDeclarations().stream().filter(FunctionDeclaration.class::isInstance).map(FunctionDeclaration.class::cast).filter(f -> f.getName().equals(call.getName()) && f.hasSignature(call.getSignature())).collect(Collectors.toList());
                call.setInvokes(invocationCandidates);
            } else if (!this.handlePossibleStaticImport(call, curClass)) {
                String[] nameParts;
                Set<Type> possibleContainingTypes = this.getPossibleContainingTypes(node, curClass);
                List<FunctionDeclaration> invocationCandidates = call.getInvokes().stream().map(f -> this.getOverridingCandidates(possibleContainingTypes, (FunctionDeclaration)f)).flatMap(Collection::stream).collect(Collectors.toList());
                if (invocationCandidates.isEmpty() && (nameParts = call.getName().split("\\.")).length > 0) {
                    List<Type> signature = call.getSignature();
                    Set<RecordDeclaration> records = possibleContainingTypes.stream().map(t -> this.recordMap.get(t.getTypeName())).filter(Objects::nonNull).collect(Collectors.toSet());
                    invocationCandidates = this.getInvocationCandidatesFromParents(nameParts[nameParts.length - 1], signature, records);
                }
                if (curClass != null && !(call instanceof MemberCallExpression) && !(call instanceof StaticCallExpression)) {
                    call.setBase(curClass.getThis());
                }
                call.setInvokes(invocationCandidates);
            }
        } else if (node instanceof NewExpression) {
            NewExpression newExpression = (NewExpression)node;
            String typeName = newExpression.getType().getTypeName();
            RecordDeclaration record = this.recordMap.get(typeName);
            newExpression.setInstantiates(record);
            if (newExpression.getInitializer() instanceof ConstructExpression) {
                ConstructExpression initializer = (ConstructExpression)newExpression.getInitializer();
                List<Type> signature = initializer.getSignature();
                if (record != null && record.getCode() != null && !record.getCode().isEmpty()) {
                    ConstructorDeclaration constructor = this.getConstructorDeclaration(signature, record);
                    if (constructor != null) {
                        initializer.setConstructor(constructor);
                    } else {
                        LOGGER.warn("Unexpected: Could not find constructor for {} with signature {}", (Object)record.getName(), signature);
                    }
                }
            }
        }
    }

    private boolean handlePossibleStaticImport(@Nullable CallExpression call, RecordDeclaration curClass) {
        if (call == null || curClass == null) {
            return false;
        }
        String name = call.getName().substring(call.getName().lastIndexOf(46) + 1);
        List nameMatches = curClass.getStaticImports().stream().filter(FunctionDeclaration.class::isInstance).map(FunctionDeclaration.class::cast).filter(m -> m.getName().equals(name) || m.getName().endsWith("." + name)).collect(Collectors.toList());
        if (nameMatches.isEmpty()) {
            return false;
        }
        ArrayList<FunctionDeclaration> invokes = new ArrayList<FunctionDeclaration>();
        FunctionDeclaration target = nameMatches.stream().filter(m -> m.hasSignature(call.getSignature())).findFirst().orElse(null);
        if (target == null) {
            this.generateStaticImportDummies(call, name, invokes, curClass);
        } else {
            invokes.add(target);
        }
        call.setInvokes(invokes);
        return true;
    }

    private void generateStaticImportDummies(@NonNull CallExpression call, @NonNull String name, @NonNull List<FunctionDeclaration> invokes, RecordDeclaration curClass) {
        if (curClass == null) {
            LOGGER.warn("Cannot generate dummies for imports of a null class: {}", (Object)call.toString());
            return;
        }
        List containingRecords = curClass.getStaticImportStatements().stream().filter(i -> i.endsWith("." + name)).map(i -> i.substring(0, i.lastIndexOf(46))).map(c -> this.recordMap.getOrDefault(c, null)).filter(Objects::nonNull).collect(Collectors.toList());
        for (RecordDeclaration record : containingRecords) {
            MethodDeclaration dummy = NodeBuilder.newMethodDeclaration(name, "", true, record);
            dummy.setImplicit(true);
            List<ParamVariableDeclaration> params = this.createParameters(call.getSignature());
            dummy.setParameters(params);
            record.getMethods().add(dummy);
            curClass.getStaticImports().add(dummy);
            invokes.add(dummy);
        }
    }

    private Optional<FunctionDeclaration> checkExistingDummies(FunctionDeclaration template, List<Type> signature) {
        if (template instanceof MethodDeclaration && ((MethodDeclaration)template).getRecordDeclaration() != null) {
            return ((MethodDeclaration)template).getRecordDeclaration().getMethods().stream().filter(m -> m.getName().equals(template.getName()) && m.hasSignature(signature)).map(FunctionDeclaration.class::cast).findFirst();
        }
        if (this.currentTU == null) {
            LOGGER.error("No current translation unit when trying to find matching dummy for {}", (Object)template);
            return Optional.empty();
        }
        return this.currentTU.getDeclarations().stream().filter(FunctionDeclaration.class::isInstance).map(FunctionDeclaration.class::cast).filter(f -> f.getName().equals(template.getName()) && f.hasSignature(signature)).findFirst();
    }

    private FunctionDeclaration createDummyWithMatchingSignature(FunctionDeclaration template, List<Type> signature) {
        Optional<FunctionDeclaration> existing = this.checkExistingDummies(template, signature);
        if (existing.isPresent()) {
            return existing.get();
        }
        List<ParamVariableDeclaration> parameters = this.createParameters(signature);
        if (template instanceof MethodDeclaration) {
            RecordDeclaration containingRecord = ((MethodDeclaration)template).getRecordDeclaration();
            MethodDeclaration dummy = NodeBuilder.newMethodDeclaration(template.getName(), template.getCode(), ((MethodDeclaration)template).isStatic(), containingRecord);
            dummy.setImplicit(true);
            dummy.setParameters(parameters);
            if (containingRecord == null) {
                if (this.currentTU == null) {
                    LOGGER.error("No current translation unit when trying to generate method dummy {}", (Object)dummy.getName());
                } else {
                    this.currentTU.getDeclarations().add(dummy);
                }
            } else {
                containingRecord.getMethods().add(dummy);
            }
            return dummy;
        }
        FunctionDeclaration dummy = NodeBuilder.newFunctionDeclaration(template.getName(), template.getCode());
        dummy.setParameters(parameters);
        dummy.setImplicit(true);
        if (this.currentTU == null) {
            LOGGER.error("No current translation unit when trying to generate function dummy {}", (Object)dummy.getName());
        } else {
            this.currentTU.getDeclarations().add(dummy);
        }
        return dummy;
    }

    private List<ParamVariableDeclaration> createParameters(List<Type> signature) {
        ArrayList<ParamVariableDeclaration> params = new ArrayList<ParamVariableDeclaration>();
        for (int i = 0; i < signature.size(); ++i) {
            Type targetType = signature.get(i);
            String paramName = this.generateParamName(i, targetType);
            ParamVariableDeclaration param = NodeBuilder.newMethodParameterIn(paramName, targetType, false, "");
            param.setImplicit(true);
            param.setArgumentIndex(i);
            params.add(param);
        }
        return params;
    }

    private String generateParamName(int i, @NonNull Type targetType) {
        StringBuilder paramName = new StringBuilder();
        boolean capitalize = false;
        for (int j = 0; j < targetType.toString().length(); ++j) {
            char c = targetType.toString().charAt(j);
            if (c == '.' || c == ':') {
                capitalize = true;
                continue;
            }
            if (c == '*') {
                paramName.append("Ptr");
                continue;
            }
            if (capitalize) {
                paramName.append(String.valueOf(c).toUpperCase());
                capitalize = false;
                continue;
            }
            paramName.append(c);
        }
        paramName.append(i);
        return paramName.toString();
    }

    private Set<Type> getPossibleContainingTypes(Node node, RecordDeclaration curClass) {
        HashSet<Type> possibleTypes = new HashSet<Type>();
        if (node instanceof MemberCallExpression) {
            MemberCallExpression memberCall = (MemberCallExpression)node;
            if (memberCall.getBase() instanceof HasType) {
                HasType base = (HasType)((Object)memberCall.getBase());
                possibleTypes.add(base.getType());
                possibleTypes.addAll(base.getPossibleSubTypes());
            }
        } else if (node instanceof StaticCallExpression) {
            StaticCallExpression staticCall = (StaticCallExpression)node;
            if (staticCall.getTargetRecord() != null) {
                possibleTypes.add(new Type(staticCall.getTargetRecord()));
            }
        } else if (curClass != null) {
            possibleTypes.add(new Type(curClass.getName()));
            possibleTypes.addAll(curClass.getSuperTypes());
        }
        return possibleTypes;
    }

    private List<FunctionDeclaration> getInvocationCandidatesFromRecord(RecordDeclaration record, String name, List<Type> signature) {
        Pattern namePattern = Pattern.compile("(" + Pattern.quote(record.getName()) + "\\.)?" + Pattern.quote(name));
        return record.getMethods().stream().filter(m -> namePattern.matcher(m.getName()).matches() && m.hasSignature(signature)).map(FunctionDeclaration.class::cast).collect(Collectors.toList());
    }

    private List<FunctionDeclaration> getInvocationCandidatesFromParents(String name, List<Type> signature, Set<RecordDeclaration> possibleTypes) {
        if (possibleTypes.isEmpty()) {
            return new ArrayList<FunctionDeclaration>();
        }
        List<FunctionDeclaration> firstLevelCandidates = possibleTypes.stream().map(r -> this.getInvocationCandidatesFromRecord((RecordDeclaration)r, name, signature)).flatMap(Collection::stream).collect(Collectors.toList());
        if (firstLevelCandidates.isEmpty()) {
            return possibleTypes.stream().map(RecordDeclaration::getSuperTypeDeclarations).map(superTypes -> this.getInvocationCandidatesFromParents(name, signature, (Set<RecordDeclaration>)superTypes)).flatMap(Collection::stream).collect(Collectors.toList());
        }
        return firstLevelCandidates;
    }

    private Set<FunctionDeclaration> getOverridingCandidates(Set<Type> possibleSubTypes, FunctionDeclaration declaration) {
        return declaration.getOverriddenBy().stream().filter(f -> possibleSubTypes.contains(this.containingType.get(f))).collect(Collectors.toSet());
    }

    private @Nullable ConstructorDeclaration getConstructorDeclaration(List<Type> signature, RecordDeclaration record) {
        return record.getConstructors().stream().filter(f -> f.hasSignature(signature)).findFirst().orElse(null);
    }
}

