/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.helpers;

import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.helpers.SubgraphWalker;
import de.fraunhofer.aisec.cpg.sarif.PhysicalLocation;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;

public class Util {
    public static <T, S extends T> List<S> filterCast(List<T> genericList, Class<S> specificClass) {
        return genericList.stream().filter(g -> specificClass.isAssignableFrom(g.getClass())).map(specificClass::cast).collect(Collectors.toList());
    }

    public static <S extends Node> List<S> subnodesOfType(Node node, Class<S> specificClass) {
        return Util.filterCast(SubgraphWalker.flattenAST(node), specificClass).stream().filter(Util.distinctByIdentity()).collect(Collectors.toList());
    }

    public static <S extends Node> List<S> subnodesOfType(Collection<? extends Node> roots, Class<S> specificClass) {
        return roots.stream().map(n -> Util.subnodesOfType(n, specificClass)).flatMap(Collection::stream).filter(Util.distinctByIdentity()).collect(Collectors.toList());
    }

    public static List<Node> subnodesOfCode(Node node, String searchCode) {
        return SubgraphWalker.flattenAST(node).stream().filter(n -> n.getCode() != null && n.getCode().equals(searchCode)).collect(Collectors.toList());
    }

    public static boolean eogConnect(Connect cn, Edge en, Node n, Connect cr, Node ... refs) {
        return Util.eogConnect(Quantifier.ALL, cn, en, n, cr, refs);
    }

    public static boolean eogConnect(Quantifier q, Connect cn, Edge en, Node n, Node ... refs) {
        return Util.eogConnect(q, cn, en, n, Connect.SUBTREE, refs);
    }

    public static boolean eogConnect(Quantifier q, Edge en, Node n, Connect cr, Node ... refs) {
        return Util.eogConnect(q, Connect.SUBTREE, en, n, cr, refs);
    }

    public static boolean eogConnect(Connect cn, Edge en, Node n, Node ... refs) {
        return Util.eogConnect(Quantifier.ALL, cn, en, n, Connect.SUBTREE, refs);
    }

    public static boolean eogConnect(Quantifier q, Edge en, Node n, Node ... refs) {
        return Util.eogConnect(q, Connect.SUBTREE, en, n, Connect.SUBTREE, refs);
    }

    public static boolean eogConnect(Edge en, Node n, Connect cr, Node ... refs) {
        return Util.eogConnect(Quantifier.ALL, Connect.SUBTREE, en, n, cr, refs);
    }

    public static boolean eogConnect(Edge en, Node n, Node ... refs) {
        return Util.eogConnect(Quantifier.ALL, Connect.SUBTREE, en, n, Connect.SUBTREE, refs);
    }

    public static boolean eogConnect(Quantifier q, Connect cn, Edge en, Node n, Connect cr, Node ... refs) {
        List<Node> nodeSide = List.of(n);
        Edge er = en == Edge.ENTRIES ? Edge.EXITS : Edge.ENTRIES;
        List<Node> refSide = Arrays.asList(refs);
        if (cn == Connect.SUBTREE) {
            SubgraphWalker.Border border2 = SubgraphWalker.getEOGPathEdges(n);
            nodeSide = en == Edge.ENTRIES ? border2.getEntries().stream().flatMap(r -> r.getPrevEOG().stream()).collect(Collectors.toList()) : border2.getExits();
        } else {
            nodeSide = nodeSide.stream().flatMap(node -> (en == Edge.ENTRIES ? node.getPrevEOG() : List.of(node)).stream()).collect(Collectors.toList());
        }
        if (cr == Connect.SUBTREE) {
            List borders = Arrays.stream(refs).map(SubgraphWalker::getEOGPathEdges).collect(Collectors.toList());
            refSide = borders.stream().flatMap(border -> Edge.ENTRIES == er ? border.getEntries().stream().flatMap(r -> r.getPrevEOG().stream()) : border.getExits().stream()).collect(Collectors.toList());
        } else {
            refSide = refSide.stream().flatMap(node -> (er == Edge.ENTRIES ? node.getPrevEOG() : List.of(node)).stream()).collect(Collectors.toList());
        }
        List<Node> refNodes = refSide;
        return Quantifier.ANY == q ? nodeSide.stream().anyMatch(refNodes::contains) : refNodes.containsAll(nodeSide);
    }

    public static String inputStreamToString(InputStream inputStream) throws IOException {
        try (ByteArrayOutputStream result = new ByteArrayOutputStream();){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            String string = result.toString(StandardCharsets.UTF_8);
            return string;
        }
    }

    public static <T> Predicate<T> distinctByIdentity() {
        IdentityHashMap seen = new IdentityHashMap();
        return t -> {
            if (seen.containsKey(t)) {
                return false;
            }
            seen.put(t, true);
            return true;
        };
    }

    public static <T> Predicate<T> distinctBy(Function<? super T, ?> by) {
        HashSet seen = new HashSet();
        return t -> seen.add(by.apply(t));
    }

    public static String getExtension(@NonNull File file) {
        int pos = file.getName().lastIndexOf(46);
        if (pos > 0) {
            return file.getName().substring(pos).toLowerCase();
        }
        return "";
    }

    public static <S> void warnWithFileLocation(@NonNull LanguageFrontend lang, S astNode, Logger log, String format, Object ... arguments) {
        log.warn(String.format("%s: %s", PhysicalLocation.locationLink(lang.getLocationFromRawNode(astNode)), format), arguments);
    }

    public static <S> void errorWithFileLocation(@NonNull LanguageFrontend lang, S astNode, Logger log, String format, Object ... arguments) {
        log.error(String.format("%s: %s", PhysicalLocation.locationLink(lang.getLocationFromRawNode(astNode)), format), arguments);
    }

    public static void warnWithFileLocation(@NonNull Node node, Logger log, String format, Object ... arguments) {
        log.warn(String.format("%s: %s", PhysicalLocation.locationLink(node.getLocation()), format), arguments);
    }

    public static void errorWithFileLocation(@NonNull Node node, Logger log, String format, Object ... arguments) {
        log.error(String.format("%s: %s", PhysicalLocation.locationLink(node.getLocation()), format), arguments);
    }

    public static enum Edge {
        ENTRIES,
        EXITS;

    }

    public static enum Quantifier {
        ANY,
        ALL;

    }

    public static enum Connect {
        NODE,
        SUBTREE;

    }
}

