/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.helpers;

import de.fraunhofer.aisec.cpg.sarif.PhysicalLocation;
import de.fraunhofer.aisec.cpg.sarif.Region;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.ogm.typeconversion.CompositeAttributeConverter;

public class LocationConverter
implements CompositeAttributeConverter<PhysicalLocation> {
    public Map<String, ?> toGraphProperties(PhysicalLocation value) {
        HashMap<String, Comparable<URI>> properties = new HashMap<String, Comparable<URI>>();
        if (value != null) {
            properties.put("artifact", value.getArtifactLocation().getUri());
            properties.put("startLine", Integer.valueOf(value.getRegion().getStartLine()));
            properties.put("endLine", Integer.valueOf(value.getRegion().getEndLine()));
            properties.put("startColumn", Integer.valueOf(value.getRegion().getStartColumn()));
            properties.put("endColumn", Integer.valueOf(value.getRegion().getEndColumn()));
        }
        return properties;
    }

    public PhysicalLocation toEntityAttribute(Map<String, ?> value) {
        try {
            int startLine = Math.toIntExact(((Integer)value.get("startLine")).intValue());
            int endLine = Math.toIntExact(((Integer)value.get("endLine")).intValue());
            int startColumn = Math.toIntExact(((Integer)value.get("startColumn")).intValue());
            int endColumn = Math.toIntExact(((Integer)value.get("endColumn")).intValue());
            URI uri = (URI)value.get("artifact");
            return new PhysicalLocation(uri, new Region(startLine, startColumn, endLine, endColumn));
        }
        catch (NullPointerException e) {
            return null;
        }
    }
}

