/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph;

import de.fraunhofer.aisec.cpg.frontends.LanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.Type;
import de.fraunhofer.aisec.cpg.passes.scopes.RecordScope;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class TypeManager {
    private static final List<String> primitiveTypeNames = List.of("byte", "short", "int", "long", "float", "double", "boolean", "char");
    private static TypeManager INSTANCE = new TypeManager();
    private Map<String, RecordDeclaration> typeToRecord = new HashMap<String, RecordDeclaration>();
    private LanguageFrontend frontend;

    private TypeManager() {
    }

    public static TypeManager getInstance() {
        return INSTANCE;
    }

    public void setLanguageFrontend(LanguageFrontend frontend) {
        this.frontend = frontend;
    }

    public boolean isPrimitive(Type type) {
        return primitiveTypeNames.contains(type.getTypeName());
    }

    public boolean isUnknown(Type type) {
        return this.isUnknown(type.getTypeName());
    }

    public boolean isUnknown(String type) {
        return type.contains("UNKNOWN") || type.contains("?") || type.equals("var") || type.equals("");
    }

    public Optional<Type> getCommonType(Collection<Type> types) {
        if (types.isEmpty()) {
            return Optional.empty();
        }
        if (types.size() == 1) {
            return Optional.of(types.iterator().next());
        }
        this.typeToRecord = this.frontend.getScopeManager().getUniqueScopesThat(RecordScope.class::isInstance, s -> s.getAstNode().getName()).stream().map(s -> (RecordDeclaration)s.getAstNode()).collect(Collectors.toMap(Node::getName, Function.identity()));
        List allAncestors = types.stream().map(t -> this.typeToRecord.getOrDefault(t.getTypeName(), null)).filter(Objects::nonNull).map(r -> this.getAncestors((RecordDeclaration)r, 0)).collect(Collectors.toList());
        for (Set ancestors : allAncestors) {
            Optional<Ancestor> farthest = ancestors.stream().max(Comparator.comparingInt(Ancestor::getDepth));
            if (!farthest.isPresent()) continue;
            int maxDepth = farthest.get().getDepth();
            ancestors.forEach(a -> a.setDepth(maxDepth - a.getDepth()));
        }
        HashSet commonAncestors = new HashSet();
        for (int i = 0; i < allAncestors.size(); ++i) {
            if (i == 0) {
                commonAncestors.addAll((Collection)allAncestors.get(i));
                continue;
            }
            commonAncestors.retainAll((Collection)allAncestors.get(i));
        }
        Optional<Ancestor> lca = commonAncestors.stream().max(Comparator.comparingInt(Ancestor::getDepth));
        return lca.map(a -> new Type(a.getRecord().getName()));
    }

    private Set<Ancestor> getAncestors(RecordDeclaration record, int depth) {
        if (record.getSuperTypes().isEmpty()) {
            HashSet<Ancestor> ret = new HashSet<Ancestor>();
            ret.add(new Ancestor(record, depth));
            return ret;
        }
        Set<Ancestor> ancestors = record.getSuperTypes().stream().map(s -> this.typeToRecord.getOrDefault(s.getTypeName(), null)).filter(Objects::nonNull).map(s -> this.getAncestors((RecordDeclaration)s, depth + 1)).flatMap(Collection::stream).collect(Collectors.toSet());
        ancestors.add(new Ancestor(record, depth));
        return ancestors;
    }

    public boolean isSupertypeOf(Type superType, Type subType) {
        if (!superType.getTypeAdjustment().equals(subType.getTypeAdjustment())) {
            return false;
        }
        if (this.checkArrayAndPointer(superType, subType) || this.checkArrayAndPointer(subType, superType)) {
            return true;
        }
        Optional<Type> commonType = this.getCommonType(new HashSet<Type>(List.of(superType, subType)));
        if (commonType.isPresent()) {
            return commonType.get().equals(superType);
        }
        try {
            Class<?> superCls = Class.forName(superType.getTypeName());
            Class<?> subCls = Class.forName(subType.getTypeName());
            return superCls.isAssignableFrom(subCls);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private boolean checkArrayAndPointer(Type first, Type second) {
        int firstPointerDepth;
        int secondArrayDepth = StringUtils.countMatches((CharSequence)second.getTypeAdjustment(), (CharSequence)"[]");
        if (secondArrayDepth == (firstPointerDepth = StringUtils.countMatches((CharSequence)first.getTypeAdjustment(), (char)'*'))) {
            return first.getTypeName().equals(second.getTypeName());
        }
        return false;
    }

    public void cleanup() {
        this.frontend = null;
        this.typeToRecord.clear();
    }

    private class Ancestor {
        private RecordDeclaration record;
        private int depth;

        public Ancestor(RecordDeclaration record, int depth) {
            this.record = record;
            this.depth = depth;
        }

        public RecordDeclaration getRecord() {
            return this.record;
        }

        public int getDepth() {
            return this.depth;
        }

        public void setDepth(int depth) {
            this.depth = depth;
        }

        public int hashCode() {
            return Objects.hash(this.record);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Ancestor) {
                return ((Ancestor)obj).getRecord().equals(this.getRecord()) && ((Ancestor)obj).getDepth() == this.getDepth();
            }
            return false;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, Node.TO_STRING_STYLE).append("record", (Object)this.record.getName()).append("depth", this.depth).toString();
        }
    }
}

