/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.ogm.annotation.GeneratedValue;
import org.neo4j.ogm.annotation.Id;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Type {
    public static final String UNKNOWN_TYPE_STRING = "UNKNOWN";
    private static final Logger LOGGER = LoggerFactory.getLogger(Type.class);
    private static final Pattern DOUBLE_COLON = Pattern.compile("::");
    private static final Pattern START_WITH_BACKSLASH = Pattern.compile("\\*");
    private static final Pattern TYPE_FROM_STRING = Pattern.compile("(?:(?<modifier>[a-zA-Z]*) )?(?<type>[a-zA-Z0-9_$.<>]*)(?<adjustment>[\\[\\]*&\\s]*)?");
    protected String type = "UNKNOWN";
    protected String typeAdjustment = "";
    protected String typeModifier = "";
    protected Origin typeOrigin = Origin.UNRESOLVED;
    protected boolean isFunctionPtr = false;
    @Id
    @GeneratedValue
    private Long id;

    private Type() {
    }

    public Type(String type) {
        this.setFrom(type);
    }

    public Type(String type, String typeAdjustment) {
        this(type);
        this.typeAdjustment = typeAdjustment;
    }

    public Type(String type, String typeAdjustment, boolean isFunctionPtr) {
        this.type = type;
        this.typeAdjustment = typeAdjustment;
        this.isFunctionPtr = isFunctionPtr;
    }

    public Type(String type, String typeAdjustment, Origin typeOrigin) {
        this(type, typeAdjustment);
        this.typeOrigin = typeOrigin;
    }

    public Type(String type, Origin typeOrigin) {
        this(type);
        this.typeOrigin = typeOrigin;
    }

    public Type(Type src) {
        this.type = src.type;
        this.typeAdjustment = src.typeAdjustment;
        this.typeModifier = src.typeModifier;
        this.typeOrigin = src.typeOrigin;
        this.isFunctionPtr = src.isFunctionPtr;
    }

    public static Type getUnknown() {
        return new Type();
    }

    private static String clean(String type) {
        if (type.contains("?") || type.contains("org.eclipse.cdt.internal.core.dom.parser.ProblemType@")) {
            return UNKNOWN_TYPE_STRING;
        }
        type = type.replaceAll("^struct ", "");
        type = type.replaceAll("^const struct ", "");
        type = type.replaceAll(" const ", " ");
        type = type.replaceAll("\\{.*}::", "");
        type = type.replaceAll("\\[[ \\d]*]", "[]");
        type = type.replaceAll("\\(.*\\)", "");
        type = type.replace("::", ".");
        return type.strip();
    }

    public static Type createFrom(String string) {
        return new Type(string);
    }

    public String getTypeName() {
        return this.type;
    }

    public void setTypeName(String type) {
        this.type = type;
    }

    private void setFrom(String string) {
        String cleaned = Type.clean(string);
        Matcher matcher = TYPE_FROM_STRING.matcher(cleaned);
        if (matcher.matches()) {
            String typeName = matcher.group("type");
            String adjustment = matcher.group("adjustment");
            adjustment = adjustment == null ? "" : adjustment.replace(" ", "");
            String modifier = matcher.group("modifier");
            modifier = modifier == null ? "" : modifier;
            this.setTypeName(typeName);
            this.setTypeAdjustment(adjustment);
            this.setTypeModifier(modifier);
        } else {
            LOGGER.warn("Type regex does not match for {} (cleaned version of {})", (Object)cleaned, (Object)string);
            this.setTypeName(cleaned);
        }
    }

    public boolean hasTypeAdjustment() {
        return this.typeAdjustment != null;
    }

    public String getTypeAdjustment() {
        return this.typeAdjustment;
    }

    public void setTypeAdjustment(String typeAdjustment) {
        this.typeAdjustment = typeAdjustment;
    }

    public Origin getTypeOrigin() {
        return this.typeOrigin;
    }

    public void setTypeOrigin(Origin typeOrigin) {
        this.typeOrigin = typeOrigin;
    }

    public Type reference() {
        return new Type(this.type, "*" + this.typeAdjustment, this.isFunctionPtr);
    }

    public Type dereference() {
        return new Type(this.type, this.typeAdjustment.replaceFirst("(\\[])|(\\*)", ""), this.isFunctionPtr);
    }

    public void setFunctionPtr(boolean functionPtr) {
        this.isFunctionPtr = functionPtr;
    }

    public boolean isFunctionPtr() {
        return this.isFunctionPtr;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.hasTypeModifier()) {
            sb.append(this.getTypeModifier());
            sb.append(" ");
        }
        sb.append(this.getTypeName());
        if (this.hasTypeAdjustment()) {
            sb.append(this.getTypeAdjustment());
        }
        return sb.toString();
    }

    public boolean equals(Object other) {
        return other instanceof Type && Objects.equals(((Type)other).type, this.type) && Objects.equals(((Type)other).typeModifier, this.typeModifier) && Objects.equals(((Type)other).typeAdjustment, this.typeAdjustment) && ((Type)other).isFunctionPtr == this.isFunctionPtr;
    }

    public int hashCode() {
        int ret = 0;
        if (this.type != null) {
            ret += 17 * this.type.hashCode();
        }
        if (this.hasTypeModifier()) {
            ret += 17 * this.typeModifier.hashCode();
        }
        if (this.hasTypeAdjustment()) {
            ret += 19 * this.typeAdjustment.hashCode();
        }
        return ret;
    }

    public boolean hasTypeModifier() {
        return !this.typeModifier.isEmpty();
    }

    public String getTypeModifier() {
        return this.typeModifier;
    }

    public void setTypeModifier(String typeModifier) {
        this.typeModifier = typeModifier;
    }

    public static enum Origin {
        RESOLVED,
        DATAFLOW,
        GUESSED,
        UNRESOLVED;

    }
}

