/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph;

import de.fraunhofer.aisec.cpg.graph.ASMDeclarationStatement;
import de.fraunhofer.aisec.cpg.graph.ArrayCreationExpression;
import de.fraunhofer.aisec.cpg.graph.ArrayRangeExpression;
import de.fraunhofer.aisec.cpg.graph.ArraySubscriptionExpression;
import de.fraunhofer.aisec.cpg.graph.AssertStatement;
import de.fraunhofer.aisec.cpg.graph.BinaryOperator;
import de.fraunhofer.aisec.cpg.graph.BreakStatement;
import de.fraunhofer.aisec.cpg.graph.CallExpression;
import de.fraunhofer.aisec.cpg.graph.CaseStatement;
import de.fraunhofer.aisec.cpg.graph.CastExpression;
import de.fraunhofer.aisec.cpg.graph.CatchClause;
import de.fraunhofer.aisec.cpg.graph.CompoundStatement;
import de.fraunhofer.aisec.cpg.graph.CompoundStatementExpression;
import de.fraunhofer.aisec.cpg.graph.ConditionalExpression;
import de.fraunhofer.aisec.cpg.graph.ConstructExpression;
import de.fraunhofer.aisec.cpg.graph.ConstructorDeclaration;
import de.fraunhofer.aisec.cpg.graph.ContinueStatement;
import de.fraunhofer.aisec.cpg.graph.Declaration;
import de.fraunhofer.aisec.cpg.graph.DeclarationStatement;
import de.fraunhofer.aisec.cpg.graph.DeclaredReferenceExpression;
import de.fraunhofer.aisec.cpg.graph.DefaultStatement;
import de.fraunhofer.aisec.cpg.graph.DeleteExpression;
import de.fraunhofer.aisec.cpg.graph.DesignatedInitializerExpression;
import de.fraunhofer.aisec.cpg.graph.DoStatement;
import de.fraunhofer.aisec.cpg.graph.EmptyStatement;
import de.fraunhofer.aisec.cpg.graph.EnumConstantDeclaration;
import de.fraunhofer.aisec.cpg.graph.EnumDeclaration;
import de.fraunhofer.aisec.cpg.graph.ExplicitConstructorInvocation;
import de.fraunhofer.aisec.cpg.graph.Expression;
import de.fraunhofer.aisec.cpg.graph.ExpressionList;
import de.fraunhofer.aisec.cpg.graph.FieldDeclaration;
import de.fraunhofer.aisec.cpg.graph.ForEachStatement;
import de.fraunhofer.aisec.cpg.graph.ForStatement;
import de.fraunhofer.aisec.cpg.graph.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.GotoStatement;
import de.fraunhofer.aisec.cpg.graph.IfStatement;
import de.fraunhofer.aisec.cpg.graph.IncludeDeclaration;
import de.fraunhofer.aisec.cpg.graph.InitializerListExpression;
import de.fraunhofer.aisec.cpg.graph.LabelStatement;
import de.fraunhofer.aisec.cpg.graph.Literal;
import de.fraunhofer.aisec.cpg.graph.MemberCallExpression;
import de.fraunhofer.aisec.cpg.graph.MemberExpression;
import de.fraunhofer.aisec.cpg.graph.MethodDeclaration;
import de.fraunhofer.aisec.cpg.graph.NamespaceDeclaration;
import de.fraunhofer.aisec.cpg.graph.NewExpression;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.ParamVariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.ProblemDeclaration;
import de.fraunhofer.aisec.cpg.graph.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.ReturnStatement;
import de.fraunhofer.aisec.cpg.graph.Statement;
import de.fraunhofer.aisec.cpg.graph.StaticCallExpression;
import de.fraunhofer.aisec.cpg.graph.StaticReferenceExpression;
import de.fraunhofer.aisec.cpg.graph.SwitchStatement;
import de.fraunhofer.aisec.cpg.graph.SynchronizedStatement;
import de.fraunhofer.aisec.cpg.graph.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.TryStatement;
import de.fraunhofer.aisec.cpg.graph.Type;
import de.fraunhofer.aisec.cpg.graph.TypeIdExpression;
import de.fraunhofer.aisec.cpg.graph.UnaryOperator;
import de.fraunhofer.aisec.cpg.graph.UsingDirective;
import de.fraunhofer.aisec.cpg.graph.VariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.WhileStatement;
import de.fraunhofer.aisec.cpg.sarif.PhysicalLocation;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeBuilder.class);

    private NodeBuilder() {
    }

    public static UsingDirective newUsingDirective(String code, String qualifiedName) {
        UsingDirective using = new UsingDirective();
        using.setQualifiedName(qualifiedName);
        using.setCode(code);
        NodeBuilder.log(using);
        return using;
    }

    public static CallExpression newCallExpression(String name, String fqn, String code) {
        CallExpression node = new CallExpression();
        node.setName(name);
        node.setCode(code);
        node.setFqn(fqn);
        NodeBuilder.log(node);
        return node;
    }

    public static StaticCallExpression newStaticCallExpression(String name, String fqn, String code, String targetRecord) {
        StaticCallExpression node = new StaticCallExpression();
        node.setName(name);
        node.setCode(code);
        node.setFqn(fqn);
        node.setTargetRecord(targetRecord);
        NodeBuilder.log(node);
        return node;
    }

    public static CastExpression newCastExpression(String code) {
        CastExpression node = new CastExpression();
        node.setCode(code);
        NodeBuilder.log(node);
        return node;
    }

    public static TypeIdExpression newTypeIdExpression(String operatorCode, Type type, Type referencedType, String code) {
        TypeIdExpression node = new TypeIdExpression();
        node.setCode(code);
        node.setOperatorCode(operatorCode);
        node.setName(operatorCode);
        node.setType(type);
        node.setReferencedType(type);
        NodeBuilder.log(node);
        return node;
    }

    public static ArraySubscriptionExpression newArraySubscriptionExpression(String code) {
        ArraySubscriptionExpression node = new ArraySubscriptionExpression();
        node.setCode(code);
        NodeBuilder.log(node);
        return node;
    }

    public static <T> Literal<T> newLiteral(T value, Type type, String code) {
        Literal<T> node = new Literal<T>();
        node.setValue(value);
        node.setType(type);
        node.setCode(code);
        NodeBuilder.log(node);
        return node;
    }

    public static DeclaredReferenceExpression newDeclaredReferenceExpression(String name, Type typeFullName, String code) {
        DeclaredReferenceExpression node = new DeclaredReferenceExpression();
        node.setName(name);
        node.setType(typeFullName);
        node.setCode(code);
        NodeBuilder.log(node);
        return node;
    }

    public static ArrayRangeExpression newArrayRangeExpression(Expression floor, Expression ceil, String code) {
        ArrayRangeExpression node = new ArrayRangeExpression();
        node.setCode(code);
        node.setFloor(floor);
        node.setCeiling(ceil);
        NodeBuilder.log(node);
        return node;
    }

    public static StaticReferenceExpression newStaticReferenceExpression(String name, Type typeFullName, String code) {
        StaticReferenceExpression node = new StaticReferenceExpression();
        node.setName(name);
        node.setType(typeFullName);
        node.setCode(code);
        NodeBuilder.log(node);
        return node;
    }

    public static FunctionDeclaration newFunctionDeclaration(String name, String code) {
        FunctionDeclaration node = new FunctionDeclaration();
        node.setName(name);
        node.setCode(code);
        NodeBuilder.log(node);
        return node;
    }

    private static void log(Node node) {
        LOGGER.debug("Creating {} {}", (Object)node.getClass().getSimpleName(), (Object)node);
    }

    public static ReturnStatement newReturnStatement(String code) {
        ReturnStatement node = new ReturnStatement();
        node.setCode(code);
        NodeBuilder.log(node);
        return node;
    }

    public static SynchronizedStatement newSynchronizedStatement(String code) {
        SynchronizedStatement node = new SynchronizedStatement();
        node.setCode(code);
        NodeBuilder.log(node);
        return node;
    }

    public static DeleteExpression newDeleteExpression(String code) {
        DeleteExpression node = new DeleteExpression();
        node.setCode(code);
        NodeBuilder.log(node);
        return node;
    }

    public static EmptyStatement newEmptyStatement(String code) {
        EmptyStatement node = new EmptyStatement();
        node.setCode(code);
        NodeBuilder.log(node);
        return node;
    }

    public static ParamVariableDeclaration newMethodParameterIn(String name, Type type, boolean variadic, String code) {
        ParamVariableDeclaration node = new ParamVariableDeclaration();
        node.setName(name);
        node.setType(type);
        node.setCode(code);
        node.setVariadic(variadic);
        return node;
    }

    public static CompoundStatement newCompoundStatement(String code) {
        CompoundStatement node = new CompoundStatement();
        node.setCode(code);
        NodeBuilder.log(node);
        return node;
    }

    public static ExpressionList newExpressionList(String code) {
        ExpressionList node = new ExpressionList();
        node.setCode(code);
        NodeBuilder.log(node);
        return node;
    }

    public static CallExpression newMemberCallExpression(String name, String fqn, Node base, Node member, String code) {
        MemberCallExpression node = new MemberCallExpression();
        node.setName(name);
        node.setBase(base);
        node.setMember(member);
        node.setCode(code);
        node.setFqn(fqn);
        NodeBuilder.log(node);
        return node;
    }

    public static UnaryOperator newUnaryOperator(String operatorType, boolean postfix, boolean prefix, String code) {
        UnaryOperator node = new UnaryOperator();
        node.setOperatorCode(operatorType);
        node.setName(operatorType);
        node.setPostfix(postfix);
        node.setPrefix(prefix);
        node.setCode(code);
        NodeBuilder.log(node);
        return node;
    }

    public static VariableDeclaration newVariableDeclaration(String name, Type type, String code) {
        VariableDeclaration node = new VariableDeclaration();
        node.setName(name);
        node.setType(type);
        node.setCode(code);
        NodeBuilder.log(node);
        return node;
    }

    public static DeclarationStatement newDeclarationStatement(String code) {
        DeclarationStatement node = new DeclarationStatement();
        node.setCode(code);
        return node;
    }

    public static IfStatement newIfStatement(String code) {
        IfStatement node = new IfStatement();
        node.setCode(code);
        NodeBuilder.log(node);
        return node;
    }

    public static LabelStatement newLabelStatement(String code) {
        LabelStatement node = new LabelStatement();
        node.setCode(code);
        NodeBuilder.log(node);
        return node;
    }

    public static GotoStatement newGotoStatement(String code) {
        GotoStatement node = new GotoStatement();
        node.setCode(code);
        NodeBuilder.log(node);
        return node;
    }

    public static WhileStatement newWhileStatement(String code) {
        WhileStatement node = new WhileStatement();
        node.setCode(code);
        NodeBuilder.log(node);
        return node;
    }

    public static DoStatement newDoStatement(String code) {
        DoStatement node = new DoStatement();
        node.setCode(code);
        NodeBuilder.log(node);
        return node;
    }

    public static ForEachStatement newForEachStatement(String code) {
        ForEachStatement node = new ForEachStatement();
        node.setCode(code);
        NodeBuilder.log(node);
        return node;
    }

    public static ForStatement newForStatement(String code) {
        ForStatement node = new ForStatement();
        node.setCode(code);
        NodeBuilder.log(node);
        return node;
    }

    public static ContinueStatement newContinueStatement(String code) {
        ContinueStatement node = new ContinueStatement();
        node.setCode(code);
        NodeBuilder.log(node);
        return node;
    }

    public static BreakStatement newBreakStatement(String code) {
        BreakStatement node = new BreakStatement();
        node.setCode(code);
        NodeBuilder.log(node);
        return node;
    }

    public static BinaryOperator newBinaryOperator(String operatorCode, String code) {
        BinaryOperator node = new BinaryOperator();
        node.setOperatorCode(operatorCode);
        node.setName(operatorCode);
        node.setCode(code);
        NodeBuilder.log(node);
        return node;
    }

    public static TranslationUnitDeclaration newTranslationUnitDeclaration(String name, String code) {
        TranslationUnitDeclaration node = new TranslationUnitDeclaration();
        node.setName(name);
        node.setCode(code);
        NodeBuilder.log(node);
        return node;
    }

    public static RecordDeclaration newRecordDeclaration(String name, List<Type> superTypes, String kind, String code) {
        RecordDeclaration node = new RecordDeclaration();
        node.setName(name);
        node.setSuperTypes(superTypes);
        node.setKind(kind);
        node.setCode(code);
        NodeBuilder.log(node);
        return node;
    }

    public static EnumDeclaration newEnumDeclaration(String name, String code, PhysicalLocation location) {
        EnumDeclaration node = new EnumDeclaration();
        node.setName(name);
        node.setCode(code);
        node.setLocation(location);
        NodeBuilder.log(node);
        return node;
    }

    public static EnumConstantDeclaration newEnumConstantDeclaration(String name, String code, PhysicalLocation location) {
        EnumConstantDeclaration node = new EnumConstantDeclaration();
        node.setName(name);
        node.setCode(code);
        node.setLocation(location);
        NodeBuilder.log(node);
        return node;
    }

    public static FieldDeclaration newFieldDeclaration(String name, Type type, List<String> modifiers, String code, PhysicalLocation location, @Nullable Expression initializer) {
        FieldDeclaration node = new FieldDeclaration();
        node.setName(name);
        node.setType(type);
        node.setModifiers(modifiers);
        node.setCode(code);
        node.setLocation(location);
        if (initializer != null) {
            node.setInitializer(initializer);
        }
        NodeBuilder.log(node);
        return node;
    }

    public static MemberExpression newMemberExpression(Expression base, Node member, String code) {
        MemberExpression node = new MemberExpression();
        node.setBase(base);
        node.setMember(member);
        node.setCode(code);
        node.setName(code);
        NodeBuilder.log(node);
        return node;
    }

    public static Statement newStatement(String code) {
        Statement node = new Statement();
        node.setCode(code);
        NodeBuilder.log(node);
        return node;
    }

    public static Expression newExpression(String code) {
        Expression node = new Expression();
        node.setCode(code);
        NodeBuilder.log(node);
        return node;
    }

    public static InitializerListExpression newInitializerListExpression(String code) {
        InitializerListExpression node = new InitializerListExpression();
        node.setCode(code);
        NodeBuilder.log(node);
        return node;
    }

    public static DesignatedInitializerExpression newDesignatedInitializerExpression(String code) {
        DesignatedInitializerExpression node = new DesignatedInitializerExpression();
        node.setCode(code);
        NodeBuilder.log(node);
        return node;
    }

    public static ArrayCreationExpression newArrayCreationExpression(String code) {
        ArrayCreationExpression node = new ArrayCreationExpression();
        node.setCode(code);
        NodeBuilder.log(node);
        return node;
    }

    public static ConstructExpression newConstructExpression(String code) {
        ConstructExpression node = new ConstructExpression();
        node.setCode(code);
        NodeBuilder.log(node);
        return node;
    }

    public static MethodDeclaration newMethodDeclaration(String name, String code, boolean isStatic, @Nullable RecordDeclaration recordDeclaration) {
        MethodDeclaration node = new MethodDeclaration();
        node.setName(name);
        node.setCode(code);
        node.setStatic(isStatic);
        node.setRecordDeclaration(recordDeclaration);
        NodeBuilder.log(node);
        return node;
    }

    public static ConstructorDeclaration newConstructorDeclaration(String name, String code, @Nullable RecordDeclaration recordDeclaration) {
        ConstructorDeclaration node = new ConstructorDeclaration();
        node.setName(name);
        node.setCode(code);
        node.setRecordDeclaration(recordDeclaration);
        NodeBuilder.log(node);
        return node;
    }

    public static Declaration newDeclaration(String code) {
        Declaration node = new Declaration();
        node.setCode(code);
        NodeBuilder.log(node);
        return node;
    }

    public static ProblemDeclaration newProblemDeclaration(String filename, String problem, String problemLocation) {
        ProblemDeclaration node = new ProblemDeclaration();
        node.setFilename(filename);
        node.setProblem(problem);
        node.setProblemLocation(problemLocation);
        NodeBuilder.log(node);
        return node;
    }

    public static IncludeDeclaration newIncludeDeclaration(String includeFilename) {
        IncludeDeclaration node = new IncludeDeclaration();
        String name = includeFilename.substring(includeFilename.lastIndexOf(47) + 1);
        node.setName(name);
        node.setFilename(includeFilename);
        NodeBuilder.log(node);
        return node;
    }

    public static NewExpression newNewExpression(String code, Type type) {
        NewExpression node = new NewExpression();
        node.setCode(code);
        node.setType(type);
        NodeBuilder.log(node);
        return node;
    }

    public static SwitchStatement newSwitchStatement(String code) {
        SwitchStatement node = new SwitchStatement();
        node.setCode(code);
        NodeBuilder.log(node);
        return node;
    }

    public static CaseStatement newCaseStatement(String code) {
        CaseStatement node = new CaseStatement();
        node.setCode(code);
        NodeBuilder.log(node);
        return node;
    }

    public static DefaultStatement newDefaultStatement(String code) {
        DefaultStatement node = new DefaultStatement();
        node.setCode(code);
        NodeBuilder.log(node);
        return node;
    }

    public static ConditionalExpression newConditionalExpression(Expression condition, Expression thenExpr, Expression elseExpr, Type type) {
        ConditionalExpression node = new ConditionalExpression();
        node.setCondition(condition);
        node.setThenExpr(thenExpr);
        node.setElseExpr(elseExpr);
        node.setType(type);
        NodeBuilder.log(node);
        return node;
    }

    public static ExplicitConstructorInvocation newExplicitConstructorInvocation(String containingClass, String code) {
        ExplicitConstructorInvocation node = new ExplicitConstructorInvocation();
        node.setContainingClass(containingClass);
        node.setCode(code);
        NodeBuilder.log(node);
        return node;
    }

    public static NamespaceDeclaration newNamespaceDeclaration(@NonNull String name) {
        NamespaceDeclaration node = new NamespaceDeclaration();
        node.setName(name);
        NodeBuilder.log(node);
        return node;
    }

    public static CatchClause newCatchClause(@NonNull String code) {
        CatchClause catchClause = new CatchClause();
        catchClause.setCode(code);
        return catchClause;
    }

    public static TryStatement newTryStatement(@NonNull String code) {
        TryStatement tryStatement = new TryStatement();
        tryStatement.setCode(code);
        return tryStatement;
    }

    public static AssertStatement newAssertStatement(@NonNull String code) {
        AssertStatement assertStatement = new AssertStatement();
        assertStatement.setCode(code);
        return assertStatement;
    }

    public static ASMDeclarationStatement newASMDeclarationStatement(@NonNull String code) {
        ASMDeclarationStatement asmStatement = new ASMDeclarationStatement();
        asmStatement.setCode(code);
        return asmStatement;
    }

    public static CompoundStatementExpression newCompoundStatementExpression(@NonNull String code) {
        CompoundStatementExpression cse = new CompoundStatementExpression();
        cse.setCode(code);
        return cse;
    }
}

