/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph;

import de.fraunhofer.aisec.cpg.graph.Expression;
import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.Type;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class InitializerListExpression
extends Expression
implements HasType.TypeListener {
    @SubGraph(value={"AST"})
    private List<Expression> initializers = new ArrayList<Expression>();

    public List<Expression> getInitializers() {
        return this.initializers;
    }

    public void setInitializers(List<Expression> initializers) {
        if (this.initializers != null) {
            this.initializers.forEach(i -> {
                i.unregisterTypeListener(this);
                this.removePrevDFG((Node)i);
            });
        }
        this.initializers = initializers;
        if (initializers != null) {
            initializers.forEach(i -> {
                i.registerTypeListener(this);
                this.addPrevDFG((Node)i);
            });
        }
    }

    @Override
    public void typeChanged(HasType src, HasType root, Type oldType) {
        if (!TypeManager.getInstance().isUnknown(this.type) && src.getType().equals(oldType)) {
            return;
        }
        Type previous = this.type;
        Set<Type> types = this.initializers.parallelStream().map(Expression::getType).filter(Objects::nonNull).map(t -> {
            Type arrayType = new Type((Type)t);
            arrayType.setTypeAdjustment(arrayType.getTypeAdjustment() + "[]");
            return arrayType;
        }).collect(Collectors.toSet());
        Type alternative = !types.isEmpty() ? (Type)types.iterator().next() : null;
        Type commonType = TypeManager.getInstance().getCommonType(types).orElse(alternative);
        HashSet<Type> subTypes = new HashSet<Type>(this.getPossibleSubTypes());
        subTypes.remove(oldType);
        subTypes.addAll(types);
        this.setType(commonType, root);
        this.setPossibleSubTypes(subTypes, root);
        if (!previous.equals(this.type)) {
            this.type.setTypeOrigin(Type.Origin.DATAFLOW);
        }
    }

    @Override
    public void possibleSubTypesChanged(HasType src, HasType root, Set<Type> oldSubTypes) {
        HashSet<Type> subTypes = new HashSet<Type>(this.getPossibleSubTypes());
        subTypes.addAll(src.getPossibleSubTypes());
        this.setPossibleSubTypes(subTypes, root);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, Node.TO_STRING_STYLE).appendSuper(super.toString()).append("initializers", this.initializers).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InitializerListExpression)) {
            return false;
        }
        InitializerListExpression that = (InitializerListExpression)o;
        return super.equals(that) && Objects.equals(this.initializers, that.initializers);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

