/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph;

import de.fraunhofer.aisec.cpg.graph.Expression;
import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.Type;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ArraySubscriptionExpression
extends Expression
implements HasType.TypeListener {
    @SubGraph(value={"AST"})
    private Expression arrayExpression;
    @SubGraph(value={"AST"})
    private Expression subscriptExpression;

    public Expression getArrayExpression() {
        return this.arrayExpression;
    }

    public void setArrayExpression(Expression arrayExpression) {
        this.arrayExpression = arrayExpression;
        this.addPrevDFG(arrayExpression);
        this.setType(this.getSubscriptType(arrayExpression.getType()));
        arrayExpression.registerTypeListener(this);
    }

    private Type getSubscriptType(Type arrayType) {
        Type t = new Type(arrayType);
        if (t.getTypeAdjustment().contains("*")) {
            t.setTypeAdjustment(t.getTypeAdjustment().replaceFirst("\\*", ""));
        } else if (t.getTypeAdjustment().contains("[]")) {
            t.setTypeAdjustment(t.getTypeAdjustment().replaceFirst("\\[]", ""));
        }
        return t;
    }

    public Expression getSubscriptExpression() {
        return this.subscriptExpression;
    }

    public void setSubscriptExpression(Expression subscriptExpression) {
        this.subscriptExpression = subscriptExpression;
    }

    @Override
    public void typeChanged(HasType src, HasType root, Type oldType) {
        Type previous = this.type;
        this.setType(this.getSubscriptType(src.getType()), root);
        if (!previous.equals(this.type)) {
            this.type.setTypeOrigin(Type.Origin.DATAFLOW);
        }
    }

    @Override
    public void possibleSubTypesChanged(HasType src, HasType root, Set<Type> oldSubTypes) {
        HashSet<Type> subTypes = new HashSet<Type>(this.getPossibleSubTypes());
        subTypes.addAll(src.getPossibleSubTypes().stream().map(this::getSubscriptType).collect(Collectors.toList()));
        this.setPossibleSubTypes(subTypes, root);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArraySubscriptionExpression)) {
            return false;
        }
        ArraySubscriptionExpression that = (ArraySubscriptionExpression)o;
        return super.equals(that) && Objects.equals(this.arrayExpression, that.arrayExpression) && Objects.equals(this.subscriptExpression, that.subscriptExpression);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

