/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg;

import de.fraunhofer.aisec.cpg.passes.CallResolver;
import de.fraunhofer.aisec.cpg.passes.EvaluationOrderGraphPass;
import de.fraunhofer.aisec.cpg.passes.FilenameMapper;
import de.fraunhofer.aisec.cpg.passes.ImportResolver;
import de.fraunhofer.aisec.cpg.passes.Pass;
import de.fraunhofer.aisec.cpg.passes.TypeHierarchyResolver;
import de.fraunhofer.aisec.cpg.passes.VariableUsageResolver;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

public class TranslationConfiguration {
    public final boolean debugParser;
    public final boolean loadIncludes;
    public final String[] includePaths;
    public final boolean codeInNodes;
    final boolean failOnError;
    public final Map<String, String> symbols;
    private List<File> sourceLocations;
    private File topLevel;
    private @NonNull List<Pass> passes;

    private TranslationConfiguration(Map<String, String> symbols, List<File> sourceLocations, File topLevel, boolean debugParser, boolean failOnError, boolean loadIncludes, String[] includePaths, List<Pass> passes, boolean codeInNodes) {
        this.symbols = symbols;
        this.sourceLocations = sourceLocations;
        this.topLevel = topLevel;
        this.debugParser = debugParser;
        this.failOnError = failOnError;
        this.loadIncludes = loadIncludes;
        this.includePaths = includePaths;
        this.passes = passes != null ? passes : new ArrayList();
        this.codeInNodes = codeInNodes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Map<String, String> getSymbols() {
        return this.symbols;
    }

    public List<File> getSourceLocations() {
        return this.sourceLocations;
    }

    public File getTopLevel() {
        return this.topLevel;
    }

    public List<Pass> getRegisteredPasses() {
        return this.passes;
    }

    public static class Builder {
        private List<File> sourceLocations = new ArrayList<File>();
        private File topLevel = null;
        private boolean debugParser = false;
        private boolean failOnError = false;
        private boolean loadIncludes = false;
        private Map<String, String> symbols = new HashMap<String, String>();
        private List<String> includePaths = new ArrayList<String>();
        private List<Pass> passes = new ArrayList<Pass>();
        private boolean codeInNodes = true;

        public Builder symbols(Map<String, String> symbols) {
            this.symbols = symbols;
            return this;
        }

        public Builder sourceLocations(File ... sourceLocations) {
            this.sourceLocations = Arrays.asList(sourceLocations);
            return this;
        }

        public Builder topLevel(File topLevel) {
            this.topLevel = topLevel;
            return this;
        }

        public Builder debugParser(boolean debugParser) {
            this.debugParser = debugParser;
            return this;
        }

        public Builder failOnError(boolean failOnError) {
            this.failOnError = failOnError;
            return this;
        }

        public Builder loadIncludes(boolean loadIncludes) {
            this.loadIncludes = loadIncludes;
            return this;
        }

        public Builder includePath(String includePath) {
            this.includePaths.add(includePath);
            return this;
        }

        public Builder registerPass(@NonNull Pass pass) {
            this.passes.add(pass);
            return this;
        }

        public Builder defaultPasses() {
            this.registerPass(new FilenameMapper());
            this.registerPass(new TypeHierarchyResolver());
            this.registerPass(new ImportResolver());
            this.registerPass(new VariableUsageResolver());
            this.registerPass(new CallResolver());
            this.registerPass(new EvaluationOrderGraphPass());
            return this;
        }

        public Builder codeInNodes(boolean b) {
            this.codeInNodes = b;
            return this;
        }

        public TranslationConfiguration build() {
            String[] paths = new String[this.includePaths.size()];
            return new TranslationConfiguration(this.symbols, this.sourceLocations, this.topLevel, this.debugParser, this.failOnError, this.loadIncludes, this.includePaths.toArray(paths), this.passes, this.codeInNodes);
        }
    }
}

