/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.helpers;

import de.fraunhofer.aisec.cpg.graph.Type;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.ogm.typeconversion.CompositeAttributeConverter;

public class TypeConverter
implements CompositeAttributeConverter<Type> {
    protected String basePropertyName = "type";

    public Map<String, ?> toGraphProperties(Type value) {
        HashMap<Object, String> properties = new HashMap<Object, String>();
        if (value != null) {
            properties.put(this.basePropertyName, value.toString());
            properties.put(this.basePropertyName + "Name", value.getTypeName());
            properties.put(this.basePropertyName + "Modifier", value.getTypeModifier());
            properties.put(this.basePropertyName + "Adjustment", value.getTypeAdjustment());
        }
        return properties;
    }

    public Type toEntityAttribute(Map<String, ?> value) {
        try {
            return Type.createFrom((String)value.get(this.basePropertyName));
        }
        catch (NullPointerException e) {
            return Type.getUnknown();
        }
    }

    public static class CastTypeConverter
    extends TypeConverter {
        public CastTypeConverter() {
            this.basePropertyName = "castType";
        }
    }
}

