/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.helpers;

import de.fraunhofer.aisec.cpg.graph.CompoundStatement;
import de.fraunhofer.aisec.cpg.graph.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.TranslationUnitDeclaration;
import de.fraunhofer.aisec.cpg.graph.ValueDeclaration;
import de.fraunhofer.aisec.cpg.helpers.NodeComparator;
import de.fraunhofer.aisec.cpg.helpers.TriConsumer;
import java.lang.annotation.AnnotationFormatError;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubgraphWalker {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubgraphWalker.class);

    private SubgraphWalker() {
    }

    private static Collection<Field> getAllFields(Class<?> classType) {
        if (classType.getSuperclass() != null) {
            Collection<Field> fields = SubgraphWalker.getAllFields(classType.getSuperclass());
            fields.addAll(Arrays.asList(classType.getDeclaredFields()));
            return fields;
        }
        return new ArrayList<Field>();
    }

    public static Set<Node> getAstChildren(Node node) {
        HashSet<Node> children = new HashSet<Node>();
        if (node == null) {
            return children;
        }
        Class<?> classType = node.getClass();
        for (Field field : SubgraphWalker.getAllFields(classType)) {
            SubGraph subGraph = field.getAnnotation(SubGraph.class);
            if (subGraph == null || !Arrays.asList(subGraph.value()).contains("AST")) continue;
            try {
                field.setAccessible(true);
                Object obj = field.get(node);
                field.setAccessible(false);
                if (obj == null) continue;
                if (obj instanceof Node) {
                    children.add((Node)obj);
                    continue;
                }
                if (obj instanceof Collection) {
                    Collection astChildren = (Collection)obj;
                    astChildren.removeIf(Objects::isNull);
                    children.addAll(astChildren);
                    continue;
                }
                throw new AnnotationFormatError("Found @SubGraph(\"AST\") on field of type " + obj.getClass() + " but can only used with node graph classes or collections of graph nodes");
            }
            catch (IllegalAccessException ex) {
                LOGGER.error("Error while retrieving AST children: {}", (Object)ex.getMessage());
            }
        }
        return children;
    }

    public static List<Node> flattenAST(Node n) {
        if (n == null) {
            return new ArrayList<Node>();
        }
        HashSet<Node> list = new HashSet<Node>();
        SubgraphWalker.flattenASTInternal(list, n);
        ArrayList<Node> ret = new ArrayList<Node>(list);
        ret.sort(new NodeComparator());
        return ret;
    }

    private static void flattenASTInternal(@NonNull Set<Node> list, @NonNull Node n) {
        list.add(n);
        for (Node child : SubgraphWalker.getAstChildren(n)) {
            if (list.contains(child)) continue;
            SubgraphWalker.flattenASTInternal(list, child);
        }
    }

    public static Border getEOGPathEdges(Node n) {
        Border border = new Border();
        List<Node> flattedASTTree = SubgraphWalker.flattenAST(n);
        List eogNodes = flattedASTTree.stream().filter(node -> !node.getPrevEOG().isEmpty() || !node.getNextEOG().isEmpty()).collect(Collectors.toList());
        border.entries = eogNodes.stream().filter(node -> node.getPrevEOG().stream().anyMatch(prev -> !eogNodes.contains(prev))).collect(Collectors.toList());
        border.exits = eogNodes.stream().filter(node -> node.getNextEOG().stream().anyMatch(next -> !eogNodes.contains(next))).collect(Collectors.toList());
        return border;
    }

    public static void visit(Node stmt, Consumer<Node> visitor) {
        List<Node> nodes = SubgraphWalker.flattenAST(stmt);
        for (Node n : nodes) {
            visitor.accept(n);
        }
    }

    public static class ScopedWalker {
        private Map<Node, Pair<Node, List<ValueDeclaration>>> nodeToParentBlockAndContainedValueDeclarations = new IdentityHashMap<Node, Pair<Node, List<ValueDeclaration>>>();
        private Deque<RecordDeclaration> currentClass = new ArrayDeque<RecordDeclaration>();
        private IterativeGraphWalker walker;
        private List<TriConsumer<RecordDeclaration, Node, Node>> handlers = new ArrayList<TriConsumer<RecordDeclaration, Node, Node>>();

        public void clearCallbacks() {
            this.handlers.clear();
        }

        public void registerHandler(TriConsumer<RecordDeclaration, Node, Node> handler) {
            this.handlers.add(handler);
        }

        public void registerHandler(BiConsumer<Node, RecordDeclaration> handler) {
            this.handlers.add((currClass, parent, currNode) -> handler.accept((Node)currNode, (RecordDeclaration)currClass));
        }

        public void iterate(Node root) {
            this.walker = new IterativeGraphWalker();
            this.handlers.forEach(h -> this.walker.registerOnNodeVisit(n -> this.handleNode((Node)n, (TriConsumer<RecordDeclaration, Node, Node>)h)));
            this.walker.registerOnScopeExit(this::leaveScope);
            this.walker.iterate(root);
        }

        private void handleNode(Node current, TriConsumer<RecordDeclaration, Node, Node> handler) {
            Node parent = this.walker.getBacklog().peek();
            if (current instanceof RecordDeclaration && current != this.currentClass.peek()) {
                this.currentClass.push((RecordDeclaration)current);
            }
            handler.accept(this.currentClass.peek(), parent, current);
        }

        private void leaveScope(Node exiting) {
            if (exiting instanceof RecordDeclaration) {
                this.currentClass.pop();
            }
        }

        public RecordDeclaration getCurrentClass() {
            return this.currentClass.isEmpty() ? null : this.currentClass.peek();
        }

        public void collectDeclarations(Node current) {
            Node parentBlock = null;
            for (Node node : this.walker.getBacklog()) {
                if (!(node instanceof RecordDeclaration) && !(node instanceof CompoundStatement) && !(node instanceof FunctionDeclaration) && !(node instanceof TranslationUnitDeclaration)) continue;
                parentBlock = node;
                break;
            }
            this.nodeToParentBlockAndContainedValueDeclarations.put(current, (Pair<Node, List<ValueDeclaration>>)new MutablePair((Object)parentBlock, new ArrayList()));
            if (current instanceof ValueDeclaration) {
                LOGGER.debug("Adding variable {}", (Object)current.getCode());
                if (parentBlock == null) {
                    LOGGER.warn("Parent block is empty during subgraph run");
                } else {
                    ((List)this.nodeToParentBlockAndContainedValueDeclarations.get(parentBlock).getRight()).add((ValueDeclaration)current);
                }
            }
        }

        public List<ValueDeclaration> getAllDeclarationsForScope(Node scope) {
            ArrayList<ValueDeclaration> result = new ArrayList<ValueDeclaration>();
            Node currentScope = scope;
            HashSet<String> scopedVars = new HashSet<String>();
            while (currentScope != null && this.nodeToParentBlockAndContainedValueDeclarations.containsKey(scope)) {
                Pair<Node, List<ValueDeclaration>> entry = this.nodeToParentBlockAndContainedValueDeclarations.get(currentScope);
                for (ValueDeclaration val : (List)entry.getRight()) {
                    if (!(val instanceof FunctionDeclaration) && scopedVars.contains(val.getName())) continue;
                    result.add(val);
                    scopedVars.add(val.getName());
                }
                currentScope = (Node)entry.getLeft();
            }
            return result;
        }

        public Optional<? extends ValueDeclaration> getDeclarationForScope(Node scope, String name) {
            Node currentScope = scope;
            while (currentScope != null && this.nodeToParentBlockAndContainedValueDeclarations.containsKey(scope)) {
                Pair<Node, List<ValueDeclaration>> entry = this.nodeToParentBlockAndContainedValueDeclarations.get(currentScope);
                for (ValueDeclaration val : (List)entry.getRight()) {
                    if (!val.getName().equals(name)) continue;
                    return Optional.of(val);
                }
                currentScope = (Node)entry.getLeft();
            }
            return Optional.empty();
        }
    }

    public static class IterativeGraphWalker {
        private Deque<Node> todo;
        private Deque<Node> backlog;
        private List<Consumer<Node>> onNodeVisit = new ArrayList<Consumer<Node>>();
        private List<Consumer<Node>> onScopeExit = new ArrayList<Consumer<Node>>();

        public void iterate(Node root) {
            this.todo = new ArrayDeque<Node>();
            this.backlog = new ArrayDeque<Node>();
            HashSet<Node> seen = new HashSet<Node>();
            this.todo.push(root);
            while (!this.todo.isEmpty()) {
                Node current = this.todo.pop();
                if (!this.backlog.isEmpty() && this.backlog.peek().equals(current)) {
                    this.onScopeExit.forEach(c -> c.accept(this.backlog.pop()));
                    continue;
                }
                this.todo.push(current);
                this.onNodeVisit.forEach(c -> c.accept(current));
                Set<Node> unseenChildren = SubgraphWalker.getAstChildren(current).stream().filter(Predicate.not(seen::contains)).collect(Collectors.toSet());
                seen.addAll(unseenChildren);
                unseenChildren.forEach(this.todo::push);
                this.backlog.push(current);
            }
        }

        public void registerOnNodeVisit(Consumer<Node> callback) {
            this.onNodeVisit.add(callback);
        }

        public void registerOnScopeExit(Consumer<Node> callback) {
            this.onScopeExit.add(callback);
        }

        public void clearCallbacks() {
            this.onNodeVisit.clear();
            this.onScopeExit.clear();
        }

        public Deque<Node> getTodo() {
            return this.todo;
        }

        public Deque<Node> getBacklog() {
            return this.backlog;
        }
    }

    public static class Border {
        private List<Node> entries = new ArrayList<Node>();
        private List<Node> exits = new ArrayList<Node>();

        public List<Node> getEntries() {
            return this.entries;
        }

        public List<Node> getExits() {
            return this.exits;
        }
    }
}

