/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.helpers;

import de.fraunhofer.aisec.cpg.graph.Type;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neo4j.ogm.typeconversion.AttributeConverter;

public class SimpleTypeConverter
implements AttributeConverter<Type, String> {
    private static final Pattern pattern = Pattern.compile("(?<type>.*)(?: (?<adjustment>.*))?");

    private Type stringToType(String value) {
        Matcher matcher = pattern.matcher(value);
        if (matcher.matches()) {
            String adjustment;
            String type = matcher.group("type");
            if (type == null) {
                type = "";
            }
            if ((adjustment = matcher.group("adjustment")) == null) {
                adjustment = "";
            }
            return new Type(type, adjustment);
        }
        return null;
    }

    public String toGraphProperty(Type value) {
        Object property = value.getTypeName();
        if (!value.getTypeAdjustment().isEmpty()) {
            property = (String)property + " " + value.getTypeAdjustment();
        }
        return property;
    }

    public Type toEntityAttribute(String value) {
        return this.stringToType(value);
    }
}

