/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph;

import de.fraunhofer.aisec.cpg.graph.Declaration;
import de.fraunhofer.aisec.cpg.graph.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.Type;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.helpers.TypeConverter;
import de.fraunhofer.aisec.cpg.helpers.TypeSetConverter;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.neo4j.ogm.annotation.Transient;
import org.neo4j.ogm.annotation.typeconversion.Convert;

public abstract class ValueDeclaration
extends Declaration
implements HasType {
    @Convert(value=TypeConverter.class)
    protected Type type = Type.getUnknown();
    @Convert(value=TypeSetConverter.class)
    protected Set<Type> possibleSubTypes = new HashSet<Type>();
    @Transient
    private Set<HasType.TypeListener> typeListeners = new HashSet<HasType.TypeListener>();

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public void setType(Type type, HasType root) {
        if (type == null || root == this || TypeManager.getInstance().isPrimitive(type) && !TypeManager.getInstance().isUnknown(this.type)) {
            return;
        }
        type = new Type(type);
        Type oldType = new Type(this.type);
        if (this instanceof FunctionDeclaration) {
            type.setFunctionPtr(false);
            this.type.setFunctionPtr(false);
        } else {
            type.setFunctionPtr(type.isFunctionPtr() || this.type.isFunctionPtr());
            this.type.setFunctionPtr(type.isFunctionPtr() || this.type.isFunctionPtr());
        }
        if (TypeManager.getInstance().isUnknown(type)) {
            return;
        }
        HashSet<Type> subTypes = new HashSet<Type>(this.getPossibleSubTypes());
        subTypes.add(type);
        this.type = TypeManager.getInstance().getCommonType(subTypes).orElse(type);
        this.setPossibleSubTypes(subTypes);
        if (!Objects.equals(oldType, type)) {
            this.typeListeners.stream().filter(l -> !l.equals(this)).forEach(l -> l.typeChanged(this, root == null ? this : root, oldType));
        }
    }

    @Override
    public void resetTypes(Type type) {
        HashSet<Type> oldSubTypes = new HashSet<Type>(this.getPossibleSubTypes());
        Type oldType = this.type;
        this.type = type;
        this.setPossibleSubTypes(new HashSet<Type>(List.of(type)));
        if (!Objects.equals(oldType, type)) {
            this.typeListeners.stream().filter(l -> !l.equals(this)).forEach(l -> l.typeChanged(this, this, oldType));
        }
        if (oldSubTypes.size() != 1 || !oldSubTypes.contains(type)) {
            this.typeListeners.stream().filter(l -> !l.equals(this)).forEach(l -> l.possibleSubTypesChanged(this, this, oldSubTypes));
        }
    }

    @Override
    public void registerTypeListener(HasType.TypeListener listener) {
        this.typeListeners.add(listener);
        listener.typeChanged(this, this, this.type);
        listener.possibleSubTypesChanged(this, this, this.possibleSubTypes);
    }

    @Override
    public void unregisterTypeListener(HasType.TypeListener listener) {
        this.typeListeners.remove(listener);
    }

    @Override
    public Set<HasType.TypeListener> getTypeListeners() {
        return this.typeListeners;
    }

    @Override
    public Set<Type> getPossibleSubTypes() {
        return this.possibleSubTypes;
    }

    @Override
    public void setPossibleSubTypes(Set<Type> possibleSubTypes, HasType root) {
        if (root == this) {
            return;
        }
        if (possibleSubTypes.stream().allMatch(TypeManager.getInstance()::isPrimitive) && !this.possibleSubTypes.isEmpty()) {
            return;
        }
        Set<Type> oldSubTypes = this.possibleSubTypes;
        if (this.possibleSubTypes.addAll(possibleSubTypes)) {
            this.typeListeners.stream().filter(l -> !l.equals(this)).forEach(l -> l.possibleSubTypesChanged(this, root == null ? this : root, oldSubTypes));
        }
    }

    @Override
    public void refreshType() {
        this.typeListeners.forEach(l -> {
            l.typeChanged(this, this, this.type);
            l.possibleSubTypesChanged(this, this, this.possibleSubTypes);
        });
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, Node.TO_STRING_STYLE).appendSuper(super.toString()).append("type", (Object)this.type).append("possibleSubTypes", this.possibleSubTypes).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ValueDeclaration)) {
            return false;
        }
        ValueDeclaration that = (ValueDeclaration)o;
        return super.equals(that) && Objects.equals(this.type, that.type) && Objects.equals(this.possibleSubTypes, that.possibleSubTypes);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

