/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph;

import de.fraunhofer.aisec.cpg.graph.Expression;
import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.Type;
import de.fraunhofer.aisec.cpg.helpers.Util;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.neo4j.ogm.annotation.Transient;

public class UnaryOperator
extends Expression
implements HasType.TypeListener {
    public static final String OPERATOR_POSTFIX_INCREMENT = "++";
    public static final String OPERATOR_POSTFIX_DECREMENT = "--";
    @SubGraph(value={"AST"})
    private Expression input;
    private String operatorCode;
    private boolean postfix;
    private boolean prefix;
    @Transient
    private Set<HasType.TypeListener> checked = new HashSet<HasType.TypeListener>();

    public Expression getInput() {
        return this.input;
    }

    public void setInput(Expression input) {
        if (this.input != null) {
            this.input.unregisterTypeListener(this);
            this.removePrevDFG(this.input);
        }
        this.input = input;
        if (input != null) {
            input.registerTypeListener(this);
            this.addPrevDFG(input);
        }
    }

    private boolean getsDataFromInput(HasType.TypeListener curr, HasType.TypeListener target) {
        if (this.checked.contains(curr)) {
            return false;
        }
        this.checked.add(curr);
        if (curr == target) {
            return true;
        }
        if (curr instanceof HasType) {
            return ((HasType)((Object)curr)).getTypeListeners().stream().anyMatch(l -> this.getsDataFromInput((HasType.TypeListener)l, target));
        }
        return false;
    }

    private boolean getsDataFromInput(HasType.TypeListener listener) {
        this.checked.clear();
        return this.input.getTypeListeners().stream().anyMatch(l -> this.getsDataFromInput((HasType.TypeListener)l, listener));
    }

    public String getOperatorCode() {
        return this.operatorCode;
    }

    public void setOperatorCode(String operatorCode) {
        this.operatorCode = operatorCode;
    }

    public boolean isPostfix() {
        return this.postfix;
    }

    public void setPostfix(boolean postfix) {
        this.postfix = postfix;
    }

    public boolean isPrefix() {
        return this.prefix;
    }

    public void setPrefix(boolean prefix) {
        this.prefix = prefix;
    }

    @Override
    public void typeChanged(HasType src, HasType root, Type oldType) {
        Type previous = this.type;
        if (src == this.input) {
            Type newType = src.getType();
            if (this.operatorCode.equals("*")) {
                newType = newType.dereference();
            } else if (this.operatorCode.equals("&")) {
                newType = newType.reference();
            }
            this.setType(newType, root);
        } else {
            this.setType(src.getType(), root);
            Type newType = src.getType();
            if (this.operatorCode.equals("*")) {
                newType = src.getType().reference();
            } else if (this.operatorCode.equals("&")) {
                newType = src.getType().dereference();
            }
            this.input.setType(newType, this);
        }
        if (!previous.equals(this.type)) {
            this.type.setTypeOrigin(Type.Origin.DATAFLOW);
        }
    }

    @Override
    public void possibleSubTypesChanged(HasType src, HasType root, Set<Type> oldSubTypes) {
        if (src instanceof HasType.TypeListener && this.getsDataFromInput((HasType.TypeListener)((Object)src))) {
            return;
        }
        Set<Type> currSubTypes = new HashSet<Type>(this.getPossibleSubTypes());
        Set<Type> newSubTypes = src.getPossibleSubTypes();
        currSubTypes.addAll(newSubTypes);
        if (this.operatorCode.equals("*")) {
            currSubTypes = currSubTypes.stream().filter(Util.distinctBy(Type::getTypeName)).map(Type::dereference).collect(Collectors.toSet());
        } else if (this.operatorCode.equals("&")) {
            currSubTypes = currSubTypes.stream().filter(Util.distinctBy(Type::getTypeName)).map(Type::reference).collect(Collectors.toSet());
        }
        this.getPossibleSubTypes().clear();
        this.setPossibleSubTypes(currSubTypes, root);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, Node.TO_STRING_STYLE).appendSuper(super.toString()).append("input", (Object)this.input).append("operatorCode", (Object)this.operatorCode).append("postfix", this.postfix).append("prefix", this.prefix).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UnaryOperator)) {
            return false;
        }
        UnaryOperator that = (UnaryOperator)o;
        return super.equals(that) && this.postfix == that.postfix && this.prefix == that.prefix && Objects.equals(this.input, that.input) && Objects.equals(this.operatorCode, that.operatorCode);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

