/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph;

import de.fraunhofer.aisec.cpg.graph.Declaration;
import de.fraunhofer.aisec.cpg.graph.IncludeDeclaration;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class TranslationUnitDeclaration
extends Declaration {
    @SubGraph(value={"AST"})
    private List<Declaration> declarations = new ArrayList<Declaration>();
    @SubGraph(value={"AST"})
    private List<Declaration> includes = new ArrayList<Declaration>();
    @SubGraph(value={"AST"})
    private List<Declaration> namespaces = new ArrayList<Declaration>();

    public <T> T getDeclarationAs(int i, Class<T> clazz) {
        return clazz.cast(this.declarations.get(i));
    }

    public <T extends Declaration> Optional<T> getDeclarationByName(String name, Class<T> clazz) {
        return this.declarations.stream().filter(declaration -> clazz.isAssignableFrom(declaration.getClass())).map(clazz::cast).filter(declaration -> Objects.equals(declaration.getName(), name)).findFirst();
    }

    public List<Declaration> getDeclarations() {
        return this.declarations;
    }

    public void setDeclarations(List<Declaration> declarations) {
        this.declarations = declarations;
    }

    public List<Declaration> getIncludes() {
        return this.includes;
    }

    public void setIncludes(List<Declaration> includes) {
        this.includes = includes;
    }

    public List<Declaration> getNamespaces() {
        return this.namespaces;
    }

    public void add(Declaration decl) {
        if (decl instanceof IncludeDeclaration) {
            this.includes.add(decl);
        } else {
            this.declarations.add(decl);
        }
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, Node.TO_STRING_STYLE).append("declarations", this.declarations).append("includes", this.includes).append("namespaces", this.namespaces).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TranslationUnitDeclaration)) {
            return false;
        }
        TranslationUnitDeclaration that = (TranslationUnitDeclaration)o;
        return super.equals(that) && Objects.equals(this.declarations, that.declarations) && Objects.equals(this.includes, that.includes) && Objects.equals(this.namespaces, that.namespaces);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

