/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph;

import de.fraunhofer.aisec.cpg.graph.Region;
import de.fraunhofer.aisec.cpg.helpers.RegionConverter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.neo4j.ogm.annotation.GeneratedValue;
import org.neo4j.ogm.annotation.Id;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.annotation.typeconversion.Convert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Node {
    public static final ToStringStyle TO_STRING_STYLE = ToStringStyle.SHORT_PREFIX_STYLE;
    protected static final Logger log = LoggerFactory.getLogger(Node.class);
    public static final String EMPTY_NAME = "";
    protected @NonNull String name = "";
    protected @Nullable String code;
    protected @Nullable String comment;
    @Convert(value=RegionConverter.class)
    protected Region region = new Region();
    protected String file;
    @Relationship(value="EOG", direction="INCOMING")
    protected List<Node> prevEOG = new ArrayList<Node>();
    @Relationship(value="EOG", direction="OUTGOING")
    protected @NonNull List<Node> nextEOG = new ArrayList<Node>();
    @Relationship(value="CFG", direction="OUTGOING")
    protected @NonNull List<Node> nextCFG = new ArrayList<Node>();
    @Relationship(value="DFG", direction="INCOMING")
    protected Set<Node> prevDFG = new HashSet<Node>();
    @Relationship(value="DFG")
    protected Set<Node> nextDFG = new HashSet<Node>();
    protected boolean dummy = false;
    protected boolean implicit = false;
    @Id
    @GeneratedValue
    private Long id;
    private int argumentIndex;

    public Long getId() {
        return this.id;
    }

    public @NonNull String getName() {
        return this.name;
    }

    public void setName(@NonNull String name) {
        this.name = name;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public @Nullable String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Region getRegion() {
        return this.region;
    }

    public void setRegion(Region region) {
        this.region = region;
    }

    public List<Node> getPrevEOG() {
        return this.prevEOG;
    }

    public void setPrevEOG(List<Node> prevEOG) {
        this.prevEOG = prevEOG;
    }

    public @NonNull List<Node> getNextEOG() {
        return this.nextEOG;
    }

    public void setNextEOG(@NonNull List<Node> nextEOG) {
        this.nextEOG = nextEOG;
    }

    public @NonNull List<Node> getNextCFG() {
        return this.nextCFG;
    }

    public Set<Node> getNextDFG() {
        return this.nextDFG;
    }

    public void setNextDFG(Set<Node> nextDFG) {
        this.nextDFG = nextDFG;
    }

    public void addNextDFG(Node next) {
        this.nextDFG.add(next);
        next.prevDFG.add(this);
    }

    public void removeNextDFG(Node next) {
        if (next != null) {
            this.nextDFG.remove(next);
            next.prevDFG.remove(this);
        }
    }

    public Set<Node> getPrevDFG() {
        return this.prevDFG;
    }

    public void setPrevDFG(Set<Node> prevDFG) {
        this.prevDFG = prevDFG;
    }

    public void addPrevDFG(Node prev) {
        this.prevDFG.add(prev);
        prev.nextDFG.add(this);
    }

    public void removePrevDFG(Node prev) {
        if (prev != null) {
            this.prevDFG.remove(prev);
            prev.nextDFG.remove(this);
        }
    }

    public int getArgumentIndex() {
        return this.argumentIndex;
    }

    public void setArgumentIndex(int argumentIndex) {
        this.argumentIndex = argumentIndex;
    }

    public boolean isDummy() {
        return this.dummy;
    }

    @Deprecated(forRemoval=true)
    public void setDummy(boolean dummy) {
        this.dummy = dummy;
    }

    public void setImplicit(boolean implicit) {
        this.implicit = implicit;
    }

    public boolean isImplicit() {
        return this.implicit;
    }

    public void disconnectFromGraph() {
        for (Node n : this.nextDFG) {
            n.prevDFG.remove(this);
        }
        this.nextDFG.clear();
        for (Node n : this.prevDFG) {
            n.nextDFG.remove(this);
        }
        this.prevDFG.clear();
        for (Node n : this.nextEOG) {
            n.prevEOG.remove(this);
        }
        this.nextEOG.clear();
        for (Node n : this.prevEOG) {
            n.nextEOG.remove(this);
        }
        this.prevEOG.clear();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, TO_STRING_STYLE).append("id", (Object)this.id).append("name", (Object)this.name).append("region", (Object)this.region).append("argumentIndex", this.argumentIndex).toString();
    }

    public void setComment(@NonNull String comment) {
        this.comment = comment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Node)) {
            return false;
        }
        Node node = (Node)o;
        if (this.region == null || this.region.equals(Region.UNKNOWN_REGION) || node.region == null || node.region.equals(Region.UNKNOWN_REGION)) {
            return false;
        }
        return Objects.equals(this.name, node.name) && Objects.equals(this.code, node.code) && Objects.equals(this.comment, node.comment) && Objects.equals(this.region, node.region) && Objects.equals(this.file, node.file);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.getClass());
    }
}

