/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph;

import de.fraunhofer.aisec.cpg.graph.Expression;
import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.Type;
import de.fraunhofer.aisec.cpg.graph.ValueDeclaration;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DeclaredReferenceExpression
extends Expression
implements HasType.TypeListener {
    private Set<ValueDeclaration> refersTo = new HashSet<ValueDeclaration>();
    private boolean writingAccess = false;

    public Set<ValueDeclaration> getRefersTo() {
        return this.refersTo;
    }

    public void setRefersTo(@NonNull Set<ValueDeclaration> refersTo) {
        this.refersTo.forEach(r -> {
            if (this.writingAccess) {
                this.removeNextDFG((Node)r);
            } else {
                this.removePrevDFG((Node)r);
            }
            r.unregisterTypeListener(this);
            if (r instanceof HasType.TypeListener) {
                this.unregisterTypeListener((HasType.TypeListener)((Object)r));
            }
        });
        this.refersTo = refersTo;
        refersTo.forEach(r -> {
            if (this.writingAccess) {
                this.addNextDFG((Node)r);
            } else {
                this.addPrevDFG((Node)r);
            }
            r.registerTypeListener(this);
            if (r instanceof HasType.TypeListener) {
                this.registerTypeListener((HasType.TypeListener)((Object)r));
            }
        });
    }

    @Override
    public void typeChanged(HasType src, HasType root, Type oldType) {
        Type previous = this.type;
        this.setType(src.getType(), root);
        if (!previous.equals(this.type)) {
            this.type.setTypeOrigin(Type.Origin.DATAFLOW);
        }
    }

    @Override
    public void possibleSubTypesChanged(HasType src, HasType root, Set<Type> oldSubTypes) {
        HashSet<Type> subTypes = new HashSet<Type>(this.getPossibleSubTypes());
        subTypes.addAll(src.getPossibleSubTypes());
        this.setPossibleSubTypes(subTypes, root);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, Node.TO_STRING_STYLE).appendSuper(super.toString()).append("refersTo", this.refersTo).toString();
    }

    public void setWritingAccess(boolean writingAccess) {
        this.refersTo.forEach(r -> {
            if (this.writingAccess) {
                this.removeNextDFG((Node)r);
            } else {
                this.removePrevDFG((Node)r);
            }
        });
        this.writingAccess = writingAccess;
        this.refersTo.forEach(r -> {
            if (this.writingAccess) {
                this.addNextDFG((Node)r);
            } else {
                this.addPrevDFG((Node)r);
            }
        });
    }

    public boolean isWritingAccess() {
        return this.writingAccess;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeclaredReferenceExpression)) {
            return false;
        }
        DeclaredReferenceExpression that = (DeclaredReferenceExpression)o;
        return super.equals(that) && Objects.equals(this.refersTo, that.refersTo);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

