/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph;

import de.fraunhofer.aisec.cpg.graph.ConstructorDeclaration;
import de.fraunhofer.aisec.cpg.graph.Expression;
import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.PopulatedByPass;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.Type;
import de.fraunhofer.aisec.cpg.passes.CallResolver;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class ConstructExpression
extends Expression
implements HasType.TypeListener {
    @PopulatedByPass(value=CallResolver.class)
    private ConstructorDeclaration constructor;
    @SubGraph(value={"AST"})
    private List<Expression> arguments = new ArrayList<Expression>();

    public ConstructorDeclaration getConstructor() {
        return this.constructor;
    }

    public void setConstructor(ConstructorDeclaration constructor) {
        if (this.constructor != null) {
            this.constructor.unregisterTypeListener(this);
            this.removePrevDFG(this.constructor);
        }
        this.constructor = constructor;
        if (constructor != null) {
            constructor.registerTypeListener(this);
        }
    }

    public List<Expression> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<Expression> arguments) {
        this.arguments = arguments;
    }

    public List<Type> getSignature() {
        return this.getArguments().stream().map(Expression::getType).collect(Collectors.toList());
    }

    @Override
    public void typeChanged(HasType src, HasType root, Type oldType) {
        Type previous = this.type;
        this.setType(src.getType(), root);
        if (!previous.equals(this.type)) {
            this.type.setTypeOrigin(Type.Origin.DATAFLOW);
        }
    }

    @Override
    public void possibleSubTypesChanged(HasType src, HasType root, Set<Type> oldSubTypes) {
        HashSet<Type> subTypes = new HashSet<Type>(this.getPossibleSubTypes());
        subTypes.addAll(src.getPossibleSubTypes());
        this.setPossibleSubTypes(subTypes, root);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, Node.TO_STRING_STYLE).appendSuper(super.toString()).append("constructor", (Object)this.constructor).append("arguments", this.arguments).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConstructExpression)) {
            return false;
        }
        ConstructExpression that = (ConstructExpression)o;
        return super.equals(that) && Objects.equals(this.constructor, that.constructor) && Objects.equals(this.arguments, that.arguments);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

