/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph;

import de.fraunhofer.aisec.cpg.graph.Expression;
import de.fraunhofer.aisec.cpg.graph.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.ParamVariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.Type;
import de.fraunhofer.aisec.cpg.graph.TypeManager;
import de.fraunhofer.aisec.cpg.graph.ValueDeclaration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class CallExpression
extends Expression
implements HasType.TypeListener {
    protected List<FunctionDeclaration> invokes = new ArrayList<FunctionDeclaration>();
    @SubGraph(value={"AST"})
    private List<Expression> arguments = new ArrayList<Expression>();
    @SubGraph(value={"AST"})
    private Node base;
    private String fqn;

    public Node getBase() {
        return this.base;
    }

    public void setBase(Node base) {
        this.base = base;
    }

    public List<Expression> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<Expression> arguments) {
        this.arguments = arguments;
    }

    public List<FunctionDeclaration> getInvokes() {
        return this.invokes;
    }

    public void setInvokes(List<FunctionDeclaration> invokes) {
        this.invokes.forEach(i -> {
            i.unregisterTypeListener(this);
            for (ParamVariableDeclaration param : i.getParameters()) {
                param.getPrevDFG().stream().filter(x -> this.arguments.contains(x)).forEach(param::removeNextDFG);
            }
            this.removePrevDFG((Node)i);
        });
        this.invokes = invokes;
        invokes.forEach(i -> {
            i.registerTypeListener(this);
            i.getParameters().sort(Comparator.comparing(Node::getArgumentIndex));
            for (int j = 0; j < this.arguments.size(); ++j) {
                ParamVariableDeclaration param = i.getParameters().get(j);
                if (param.isVariadic()) {
                    while (j < this.arguments.size()) {
                        param.addPrevDFG(this.arguments.get(j));
                        ++j;
                    }
                    break;
                }
                param.addPrevDFG(this.arguments.get(j));
            }
            this.addPrevDFG((Node)i);
        });
    }

    public List<Type> getSignature() {
        return this.getArguments().stream().map(Expression::getType).collect(Collectors.toList());
    }

    @Override
    public void typeChanged(HasType src, HasType root, Type oldType) {
        Type previous = this.type;
        List<Type> types = this.invokes.stream().map(ValueDeclaration::getType).filter(Objects::nonNull).collect(Collectors.toList());
        Type alternative = !types.isEmpty() ? (Type)types.get(0) : null;
        Type commonType = TypeManager.getInstance().getCommonType(types).orElse(alternative);
        HashSet<Type> subTypes = new HashSet<Type>(this.getPossibleSubTypes());
        subTypes.remove(oldType);
        subTypes.addAll(types);
        this.setType(commonType, root);
        this.setPossibleSubTypes(subTypes, root);
        if (!previous.equals(this.type)) {
            this.type.setTypeOrigin(Type.Origin.DATAFLOW);
        }
    }

    @Override
    public void possibleSubTypesChanged(HasType src, HasType root, Set<Type> oldSubTypes) {
        HashSet<Type> subTypes = new HashSet<Type>(this.getPossibleSubTypes());
        subTypes.addAll(src.getPossibleSubTypes());
        this.setPossibleSubTypes(subTypes, root);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, Node.TO_STRING_STYLE).appendSuper(super.toString()).append("arguments", this.arguments).append("invokes", this.invokes).append("base", (Object)this.base).toString();
    }

    public String getFqn() {
        return this.fqn;
    }

    public void setFqn(String fqn) {
        this.fqn = fqn;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CallExpression)) {
            return false;
        }
        CallExpression that = (CallExpression)o;
        return super.equals(that) && Objects.equals(this.arguments, that.arguments) && Objects.equals(this.invokes, that.invokes) && Objects.equals(this.base, that.base);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

