/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.graph;

import de.fraunhofer.aisec.cpg.graph.DeclaredReferenceExpression;
import de.fraunhofer.aisec.cpg.graph.Expression;
import de.fraunhofer.aisec.cpg.graph.HasType;
import de.fraunhofer.aisec.cpg.graph.MemberExpression;
import de.fraunhofer.aisec.cpg.graph.Node;
import de.fraunhofer.aisec.cpg.graph.SubGraph;
import de.fraunhofer.aisec.cpg.graph.Type;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class BinaryOperator
extends Expression
implements HasType.TypeListener {
    @SubGraph(value={"AST"})
    private Expression lhs;
    @SubGraph(value={"AST"})
    private Expression rhs;
    private String operatorCode;

    public Expression getLhs() {
        return this.lhs;
    }

    public <T extends Expression> T getLhsAs(Class<T> clazz) {
        return (T)(clazz.isInstance(this.lhs) ? (Expression)clazz.cast(this.lhs) : null);
    }

    public void setLhs(Expression lhs) {
        if (this.lhs != null) {
            this.disconnectOldLhs();
        }
        this.lhs = lhs;
        if (lhs != null) {
            this.connectNewLhs(lhs);
        }
    }

    private void connectNewLhs(Expression lhs) {
        lhs.registerTypeListener(this);
        if ("=".equals(this.operatorCode)) {
            if (lhs instanceof DeclaredReferenceExpression) {
                ((DeclaredReferenceExpression)lhs).setWritingAccess(true);
            } else if (lhs instanceof MemberExpression) {
                ((MemberExpression)lhs).setWritingAccess(true);
            }
            if (lhs instanceof HasType.TypeListener) {
                this.registerTypeListener((HasType.TypeListener)((Object)lhs));
            }
            if (this.rhs != null) {
                lhs.addPrevDFG(this.rhs);
            }
            if (lhs instanceof HasType.TypeListener) {
                this.registerTypeListener((HasType.TypeListener)((Object)this.lhs));
            }
        } else {
            this.addPrevDFG(lhs);
        }
    }

    private void disconnectOldLhs() {
        this.lhs.unregisterTypeListener(this);
        if ("=".equals(this.operatorCode)) {
            if (this.lhs instanceof HasType.TypeListener) {
                this.unregisterTypeListener((HasType.TypeListener)((Object)this.lhs));
            }
            if (this.rhs != null) {
                this.lhs.removePrevDFG(this.lhs);
            }
            if (this.lhs instanceof HasType.TypeListener) {
                this.unregisterTypeListener((HasType.TypeListener)((Object)this.lhs));
            }
        } else {
            this.removePrevDFG(this.lhs);
        }
    }

    public Expression getRhs() {
        return this.rhs;
    }

    public <T extends Expression> T getRhsAs(Class<T> clazz) {
        return (T)(clazz.isInstance(this.rhs) ? (Expression)clazz.cast(this.rhs) : null);
    }

    public void setRhs(Expression rhs) {
        if (this.rhs != null) {
            this.disconnectOldRhs();
        }
        this.rhs = rhs;
        if (rhs != null) {
            this.connectNewRhs(rhs);
        }
    }

    private void connectNewRhs(Expression rhs) {
        rhs.registerTypeListener(this);
        if ("=".equals(this.operatorCode)) {
            if (rhs instanceof HasType.TypeListener) {
                this.registerTypeListener((HasType.TypeListener)((Object)rhs));
            }
            if (this.lhs != null) {
                this.lhs.addPrevDFG(rhs);
            }
        } else {
            this.addPrevDFG(rhs);
        }
    }

    private void disconnectOldRhs() {
        this.rhs.unregisterTypeListener(this);
        if ("=".equals(this.operatorCode)) {
            if (this.rhs instanceof HasType.TypeListener) {
                this.unregisterTypeListener((HasType.TypeListener)((Object)this.rhs));
            }
            if (this.lhs != null) {
                this.lhs.removePrevDFG(this.rhs);
            }
        } else {
            this.removePrevDFG(this.rhs);
        }
    }

    public String getOperatorCode() {
        return this.operatorCode;
    }

    public void setOperatorCode(String operatorCode) {
        this.operatorCode = operatorCode;
    }

    @Override
    public void typeChanged(HasType src, HasType root, Type oldType) {
        Type previous = this.type;
        if (this.operatorCode.equals("=")) {
            this.setType(src.getType(), root);
        } else if (this.lhs != null && "java.lang.String".equals(this.lhs.getType().toString()) || this.rhs != null && "java.lang.String".equals(this.rhs.getType().toString())) {
            this.getPossibleSubTypes().clear();
            this.setType(new Type("java.lang.String"), root);
        }
        if (!previous.equals(this.type)) {
            this.type.setTypeOrigin(Type.Origin.DATAFLOW);
        }
    }

    @Override
    public void possibleSubTypesChanged(HasType src, HasType root, Set<Type> oldSubTypes) {
        HashSet<Type> subTypes = new HashSet<Type>(this.getPossibleSubTypes());
        subTypes.addAll(src.getPossibleSubTypes());
        this.setPossibleSubTypes(subTypes, root);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, Node.TO_STRING_STYLE).appendSuper(super.toString()).append("lhs", (Object)this.lhs).append("rhs", (Object)this.rhs).append("operatorCode", (Object)this.operatorCode).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BinaryOperator)) {
            return false;
        }
        BinaryOperator that = (BinaryOperator)o;
        return super.equals(that) && Objects.equals(this.lhs, that.lhs) && Objects.equals(this.rhs, that.rhs) && Objects.equals(this.operatorCode, that.operatorCode);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

