/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.java;

import com.github.javaparser.JavaToken;
import com.github.javaparser.Range;
import com.github.javaparser.TokenRange;
import com.github.javaparser.ast.stmt.AssertStmt;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.BreakStmt;
import com.github.javaparser.ast.stmt.CatchClause;
import com.github.javaparser.ast.stmt.ContinueStmt;
import com.github.javaparser.ast.stmt.DoStmt;
import com.github.javaparser.ast.stmt.EmptyStmt;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.ForEachStmt;
import com.github.javaparser.ast.stmt.ForStmt;
import com.github.javaparser.ast.stmt.IfStmt;
import com.github.javaparser.ast.stmt.LabeledStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.stmt.SwitchEntry;
import com.github.javaparser.ast.stmt.SwitchStmt;
import com.github.javaparser.ast.stmt.SynchronizedStmt;
import com.github.javaparser.ast.stmt.ThrowStmt;
import com.github.javaparser.ast.stmt.TryStmt;
import com.github.javaparser.ast.stmt.WhileStmt;
import com.github.javaparser.ast.type.ReferenceType;
import com.github.javaparser.ast.type.UnionType;
import com.github.javaparser.utils.Pair;
import de.fraunhofer.aisec.cpg.frontends.Handler;
import de.fraunhofer.aisec.cpg.frontends.java.JavaLanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.AssertStatement;
import de.fraunhofer.aisec.cpg.graph.BreakStatement;
import de.fraunhofer.aisec.cpg.graph.CaseStatement;
import de.fraunhofer.aisec.cpg.graph.CompoundStatement;
import de.fraunhofer.aisec.cpg.graph.ContinueStatement;
import de.fraunhofer.aisec.cpg.graph.Declaration;
import de.fraunhofer.aisec.cpg.graph.DeclarationStatement;
import de.fraunhofer.aisec.cpg.graph.DefaultStatement;
import de.fraunhofer.aisec.cpg.graph.DoStatement;
import de.fraunhofer.aisec.cpg.graph.EmptyStatement;
import de.fraunhofer.aisec.cpg.graph.ExplicitConstructorInvocation;
import de.fraunhofer.aisec.cpg.graph.Expression;
import de.fraunhofer.aisec.cpg.graph.ExpressionList;
import de.fraunhofer.aisec.cpg.graph.ForEachStatement;
import de.fraunhofer.aisec.cpg.graph.ForStatement;
import de.fraunhofer.aisec.cpg.graph.IfStatement;
import de.fraunhofer.aisec.cpg.graph.LabelStatement;
import de.fraunhofer.aisec.cpg.graph.Literal;
import de.fraunhofer.aisec.cpg.graph.NodeBuilder;
import de.fraunhofer.aisec.cpg.graph.Region;
import de.fraunhofer.aisec.cpg.graph.ReturnStatement;
import de.fraunhofer.aisec.cpg.graph.SwitchStatement;
import de.fraunhofer.aisec.cpg.graph.SynchronizedStatement;
import de.fraunhofer.aisec.cpg.graph.TryStatement;
import de.fraunhofer.aisec.cpg.graph.Type;
import de.fraunhofer.aisec.cpg.graph.UnaryOperator;
import de.fraunhofer.aisec.cpg.graph.VariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.WhileStatement;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatementAnalyzer
extends Handler<de.fraunhofer.aisec.cpg.graph.Statement, Statement, JavaLanguageFrontend> {
    private static final Logger log = LoggerFactory.getLogger(StatementAnalyzer.class);

    public StatementAnalyzer(JavaLanguageFrontend lang) {
        super(de.fraunhofer.aisec.cpg.graph.Statement::new, lang);
        this.map.put(IfStmt.class, this::handleIfStatement);
        this.map.put(AssertStmt.class, this::handleAssertStatement);
        this.map.put(WhileStmt.class, this::handleWhileStatement);
        this.map.put(DoStmt.class, this::handleDoStatement);
        this.map.put(ForEachStmt.class, this::handleForEachStatement);
        this.map.put(ForStmt.class, this::handleForStatement);
        this.map.put(BreakStmt.class, this::handleBreakStatement);
        this.map.put(ContinueStmt.class, this::handleContinueStatement);
        this.map.put(ReturnStmt.class, this::handleReturnStatement);
        this.map.put(BlockStmt.class, this::handleBlockStatement);
        this.map.put(LabeledStmt.class, this::handleLabelStatement);
        this.map.put(ExplicitConstructorInvocationStmt.class, this::handleExplicitConstructorInvocation);
        this.map.put(ExpressionStmt.class, this::handleExpressionStatement);
        this.map.put(SwitchStmt.class, this::handleSwitchStatement);
        this.map.put(EmptyStmt.class, this::handleEmptyStatement);
        this.map.put(SynchronizedStmt.class, this::handleSynchronizedStatement);
        this.map.put(TryStmt.class, this::handleTryStatement);
        this.map.put(ThrowStmt.class, this::handleThrowStmt);
    }

    public de.fraunhofer.aisec.cpg.graph.Statement handleExpressionStatement(Statement stmt) {
        return (de.fraunhofer.aisec.cpg.graph.Statement)((JavaLanguageFrontend)this.lang).getExpressionHandler().handle(stmt.asExpressionStmt().getExpression());
    }

    private de.fraunhofer.aisec.cpg.graph.Statement handleThrowStmt(Statement stmt) {
        ThrowStmt throwStmt = (ThrowStmt)stmt;
        UnaryOperator throwOperation = NodeBuilder.newUnaryOperator("throw", false, true, throwStmt.toString());
        throwOperation.setInput((Expression)((JavaLanguageFrontend)this.lang).getExpressionHandler().handle(throwStmt.getExpression()));
        return throwOperation;
    }

    private ReturnStatement handleReturnStatement(Statement stmt) {
        ReturnStmt returnStmt = stmt.asReturnStmt();
        Optional optionalExpression = returnStmt.getExpression();
        Expression expression = null;
        if (optionalExpression.isPresent()) {
            com.github.javaparser.ast.expr.Expression expr = (com.github.javaparser.ast.expr.Expression)optionalExpression.get();
            expression = (Expression)((JavaLanguageFrontend)this.lang).getExpressionHandler().handle(expr);
        }
        ReturnStatement returnStatement = NodeBuilder.newReturnStatement(returnStmt.toString());
        if (expression != null) {
            returnStatement.setReturnValue(expression);
        }
        ((JavaLanguageFrontend)this.lang).setCodeAndRegion(returnStatement, stmt);
        return returnStatement;
    }

    private IfStatement handleIfStatement(Statement stmt) {
        IfStmt ifStmt = stmt.asIfStmt();
        com.github.javaparser.ast.expr.Expression conditionExpression = ifStmt.getCondition();
        Statement thenStatement = ifStmt.getThenStmt();
        Optional optionalElseStatement = ifStmt.getElseStmt();
        IfStatement ifStatement = NodeBuilder.newIfStatement(ifStmt.toString());
        ((JavaLanguageFrontend)this.lang).getScopeManager().enterScope(ifStatement);
        ifStatement.setThenStatement((de.fraunhofer.aisec.cpg.graph.Statement)this.handle(thenStatement));
        ifStatement.setCondition((Expression)((JavaLanguageFrontend)this.lang).getExpressionHandler().handle(conditionExpression));
        optionalElseStatement.ifPresent(statement -> ifStatement.setElseStatement((de.fraunhofer.aisec.cpg.graph.Statement)this.handle(statement)));
        ((JavaLanguageFrontend)this.lang).getScopeManager().leaveScope(ifStatement);
        return ifStatement;
    }

    private AssertStatement handleAssertStatement(Statement stmt) {
        AssertStmt assertStmt = stmt.asAssertStmt();
        com.github.javaparser.ast.expr.Expression conditionExpression = assertStmt.getCheck();
        Optional thenStatement = assertStmt.getMessage();
        AssertStatement assertStatement = NodeBuilder.newAssertStatement(stmt.toString());
        assertStatement.setCondition((Expression)((JavaLanguageFrontend)this.lang).getExpressionHandler().handle(conditionExpression));
        thenStatement.ifPresent(statement -> assertStatement.setMessage((de.fraunhofer.aisec.cpg.graph.Statement)((JavaLanguageFrontend)this.lang).getExpressionHandler().handle((com.github.javaparser.ast.expr.Expression)thenStatement.get())));
        return assertStatement;
    }

    private WhileStatement handleWhileStatement(Statement stmt) {
        WhileStmt whileStmt = stmt.asWhileStmt();
        com.github.javaparser.ast.expr.Expression conditionExpression = whileStmt.getCondition();
        Statement statement = whileStmt.getBody();
        WhileStatement whileStatement = NodeBuilder.newWhileStatement(whileStmt.toString());
        ((JavaLanguageFrontend)this.lang).getScopeManager().enterScope(whileStatement);
        whileStatement.setStatement((de.fraunhofer.aisec.cpg.graph.Statement)this.handle(statement));
        whileStatement.setCondition((Expression)((JavaLanguageFrontend)this.lang).getExpressionHandler().handle(conditionExpression));
        ((JavaLanguageFrontend)this.lang).getScopeManager().leaveScope(whileStatement);
        return whileStatement;
    }

    private ForEachStatement handleForEachStatement(Statement stmt) {
        ForEachStatement statement = NodeBuilder.newForEachStatement(stmt.toString());
        ((JavaLanguageFrontend)this.lang).getScopeManager().enterScope(statement);
        ForEachStmt forEachStmt = stmt.asForEachStmt();
        de.fraunhofer.aisec.cpg.graph.Statement var = (de.fraunhofer.aisec.cpg.graph.Statement)((JavaLanguageFrontend)this.lang).getExpressionHandler().handle(forEachStmt.getVariable());
        de.fraunhofer.aisec.cpg.graph.Statement iterable = (de.fraunhofer.aisec.cpg.graph.Statement)((JavaLanguageFrontend)this.lang).getExpressionHandler().handle(forEachStmt.getIterable());
        if (!(var instanceof DeclarationStatement) || !((DeclarationStatement)var).isSingleDeclaration()) {
            log.error("more or unknown decl in foreach");
        } else {
            statement.setVariable(((DeclarationStatement)var).getSingleDeclaration());
        }
        statement.setIterable(iterable);
        statement.setStatement((de.fraunhofer.aisec.cpg.graph.Statement)this.handle(forEachStmt.getBody()));
        ((JavaLanguageFrontend)this.lang).getScopeManager().leaveScope(statement);
        return statement;
    }

    private ForStatement handleForStatement(Statement stmt) {
        Region ofExprList;
        ForStmt forStmt = stmt.asForStmt();
        Optional tokenRange = forStmt.getTokenRange();
        String code = tokenRange.isPresent() ? ((TokenRange)tokenRange.get()).toString() : stmt.toString();
        ForStatement statement = NodeBuilder.newForStatement(code);
        ((JavaLanguageFrontend)this.lang).getScopeManager().enterScope(statement);
        if (forStmt.getInitialization().size() > 1) {
            ofExprList = null;
            for (com.github.javaparser.ast.expr.Expression initExpr : forStmt.getInitialization()) {
                if (ofExprList == null) {
                    ofExprList = ((JavaLanguageFrontend)this.lang).getRegionFromRawNode(initExpr);
                    continue;
                }
                ofExprList = ((JavaLanguageFrontend)this.lang).mergeRegions(ofExprList, ((JavaLanguageFrontend)this.lang).getRegionFromRawNode(initExpr));
            }
            String initString = ((JavaLanguageFrontend)this.lang).getCodeOfSubregion(statement, ((JavaLanguageFrontend)this.lang).getRegionFromRawNode(stmt), ofExprList);
            ExpressionList initExprList = NodeBuilder.newExpressionList(initString);
            initExprList.setRegion(ofExprList);
            forStmt.getInitialization().forEach(expr -> initExprList.addExpression((de.fraunhofer.aisec.cpg.graph.Statement)((JavaLanguageFrontend)this.lang).getExpressionHandler().handle(expr)));
            statement.setInitializerStatement(initExprList);
        } else if (forStmt.getInitialization().size() == 1) {
            statement.setInitializerStatement((de.fraunhofer.aisec.cpg.graph.Statement)((JavaLanguageFrontend)this.lang).getExpressionHandler().handle((com.github.javaparser.ast.expr.Expression)forStmt.getInitialization().get(0)));
        }
        forStmt.getCompare().ifPresent(condition -> statement.setCondition((Expression)((JavaLanguageFrontend)this.lang).getExpressionHandler().handle(condition)));
        if (statement.getCondition() == null) {
            Literal<Boolean> literal = NodeBuilder.newLiteral(true, new Type("boolean"), "true");
            literal.setRegion(new Region());
            statement.setCondition(literal);
        }
        if (forStmt.getUpdate().size() > 1) {
            ofExprList = null;
            for (com.github.javaparser.ast.expr.Expression initExpr : forStmt.getUpdate()) {
                if (ofExprList == null) {
                    ofExprList = ((JavaLanguageFrontend)this.lang).getRegionFromRawNode(initExpr);
                    continue;
                }
                ofExprList = ((JavaLanguageFrontend)this.lang).mergeRegions(ofExprList, ((JavaLanguageFrontend)this.lang).getRegionFromRawNode(initExpr));
            }
            String updateString = ((JavaLanguageFrontend)this.lang).getCodeOfSubregion(statement, ((JavaLanguageFrontend)this.lang).getRegionFromRawNode(stmt), ofExprList);
            ExpressionList updateExprList = NodeBuilder.newExpressionList(updateString);
            updateExprList.setRegion(ofExprList);
            forStmt.getUpdate().forEach(expr -> updateExprList.addExpression((Expression)((JavaLanguageFrontend)this.lang).getExpressionHandler().handle(expr)));
            statement.setIterationExpression(updateExprList);
        } else if (forStmt.getUpdate().size() == 1) {
            statement.setIterationExpression((Expression)((JavaLanguageFrontend)this.lang).getExpressionHandler().handle((com.github.javaparser.ast.expr.Expression)forStmt.getUpdate().get(0)));
        }
        statement.setStatement((de.fraunhofer.aisec.cpg.graph.Statement)this.handle(forStmt.getBody()));
        ((JavaLanguageFrontend)this.lang).getScopeManager().leaveScope(statement);
        return statement;
    }

    private DoStatement handleDoStatement(Statement stmt) {
        DoStmt doStmt = stmt.asDoStmt();
        com.github.javaparser.ast.expr.Expression conditionExpression = doStmt.getCondition();
        Statement statement = doStmt.getBody();
        DoStatement doStatement = NodeBuilder.newDoStatement(doStmt.toString());
        ((JavaLanguageFrontend)this.lang).getScopeManager().enterScope(doStatement);
        doStatement.setStatement((de.fraunhofer.aisec.cpg.graph.Statement)this.handle(statement));
        doStatement.setCondition((Expression)((JavaLanguageFrontend)this.lang).getExpressionHandler().handle(conditionExpression));
        ((JavaLanguageFrontend)this.lang).getScopeManager().leaveScope(doStatement);
        return doStatement;
    }

    private EmptyStatement handleEmptyStatement(Statement stmt) {
        EmptyStmt emptyStmt = stmt.asEmptyStmt();
        return NodeBuilder.newEmptyStatement(emptyStmt.toString());
    }

    private SynchronizedStatement handleSynchronizedStatement(Statement stmt) {
        SynchronizedStmt synchronizedJava = stmt.asSynchronizedStmt();
        SynchronizedStatement synchronizedCPG = NodeBuilder.newSynchronizedStatement(stmt.toString());
        synchronizedCPG.setExpression((Expression)((JavaLanguageFrontend)this.lang).getExpressionHandler().handle(synchronizedJava.getExpression()));
        synchronizedCPG.setBlockStatement((CompoundStatement)this.handle(synchronizedJava.getBody()));
        return synchronizedCPG;
    }

    private LabelStatement handleLabelStatement(Statement stmt) {
        LabeledStmt labelStmt = stmt.asLabeledStmt();
        String label = labelStmt.getLabel().getIdentifier();
        Statement statement = labelStmt.getStatement();
        LabelStatement labelStatement = NodeBuilder.newLabelStatement(labelStmt.toString());
        labelStatement.setSubStatement((de.fraunhofer.aisec.cpg.graph.Statement)this.handle(statement));
        labelStatement.setLabel(label);
        return labelStatement;
    }

    private BreakStatement handleBreakStatement(Statement stmt) {
        BreakStmt breakStmt = stmt.asBreakStmt();
        BreakStatement breakStatement = new BreakStatement();
        breakStmt.getLabel().ifPresent(label -> breakStatement.setLabel(label.toString()));
        return breakStatement;
    }

    private ContinueStatement handleContinueStatement(Statement stmt) {
        ContinueStmt continueStmt = stmt.asContinueStmt();
        ContinueStatement continueStatement = new ContinueStatement();
        continueStmt.getLabel().ifPresent(label -> continueStatement.setLabel(label.toString()));
        return continueStatement;
    }

    public CompoundStatement handleBlockStatement(Statement stmt) {
        BlockStmt blockStmt = stmt.asBlockStmt();
        CompoundStatement compoundStatement = NodeBuilder.newCompoundStatement(stmt.toString());
        ((JavaLanguageFrontend)this.lang).getScopeManager().enterScope(compoundStatement);
        for (Statement child : blockStmt.getStatements()) {
            de.fraunhofer.aisec.cpg.graph.Statement statement = (de.fraunhofer.aisec.cpg.graph.Statement)this.handle(child);
            compoundStatement.getStatements().add(statement);
        }
        ((JavaLanguageFrontend)this.lang).setCodeAndRegion(compoundStatement, stmt);
        ((JavaLanguageFrontend)this.lang).getScopeManager().leaveScope(compoundStatement);
        return compoundStatement;
    }

    public de.fraunhofer.aisec.cpg.graph.Statement handleCaseDefaultStatement(com.github.javaparser.ast.expr.Expression caseExpression, SwitchEntry sEntry) {
        Optional optionalTokenRange = sEntry.getTokenRange();
        Pair<JavaToken, JavaToken> caseTokens = null;
        if (optionalTokenRange.isEmpty()) {
            caseTokens = new Pair<JavaToken, JavaToken>(null, null);
            log.error("Token for Region for Default case not available");
        }
        if (caseExpression == null) {
            if (optionalTokenRange.isPresent()) {
                caseTokens = this.getOuterTokensWithText("default", ":", ((TokenRange)optionalTokenRange.get()).getBegin(), ((TokenRange)optionalTokenRange.get()).getEnd());
            }
            DefaultStatement defaultStatement = NodeBuilder.newDefaultStatement(this.getCodeBetweenTokens((JavaToken)caseTokens.a, (JavaToken)caseTokens.b));
            defaultStatement.setRegion(this.getRegionFromTokens((JavaToken)caseTokens.a, (JavaToken)caseTokens.b));
            return defaultStatement;
        }
        if (optionalTokenRange.isPresent()) {
            caseTokens = this.getOuterTokensWithText("case", ":", ((TokenRange)optionalTokenRange.get()).getBegin(), ((TokenRange)optionalTokenRange.get()).getEnd());
        }
        CaseStatement caseStatement = NodeBuilder.newCaseStatement(this.getCodeBetweenTokens((JavaToken)caseTokens.a, (JavaToken)caseTokens.b));
        caseStatement.setCaseExpression((Expression)((JavaLanguageFrontend)this.lang).getExpressionHandler().handle(caseExpression));
        caseStatement.setRegion(this.getRegionFromTokens((JavaToken)caseTokens.a, (JavaToken)caseTokens.b));
        return caseStatement;
    }

    public JavaToken getPreviousTokenWith(String text, JavaToken token) {
        Optional optional = token.getPreviousToken();
        while (token.getText().equals(text) && optional.isPresent()) {
            token = (JavaToken)optional.get();
            optional = token.getPreviousToken();
        }
        return token;
    }

    public JavaToken getNextTokenWith(String text, JavaToken token) {
        Optional optional = token.getNextToken();
        while (token.getText().equals(text) && optional.isPresent()) {
            token = (JavaToken)optional.get();
            optional = token.getNextToken();
        }
        return token;
    }

    public Pair<JavaToken, JavaToken> getOuterTokensWithText(String startDelim, String endDelim, JavaToken start, JavaToken end) {
        return new Pair((Object)this.getPreviousTokenWith(startDelim, start), (Object)this.getNextTokenWith(endDelim, end));
    }

    public Region getRegionFromTokens(JavaToken startToken, JavaToken endToken) {
        if (startToken != null && endToken != null) {
            Optional startOpt = startToken.getRange();
            Optional endOpt = endToken.getRange();
            if (startOpt.isPresent() && endOpt.isPresent()) {
                Range rstart = (Range)startOpt.get();
                Range rend = (Range)endOpt.get();
                return new Region(rstart.begin.line, rstart.begin.column, rend.end.line, rend.end.column + 1);
            }
        }
        return new Region();
    }

    public String getCodeBetweenTokens(JavaToken startToken, JavaToken endToken) {
        if (startToken == null || endToken == null) {
            return "UNKNOWN";
        }
        StringBuilder newCode = new StringBuilder(startToken.getText());
        JavaToken current = startToken;
        while ((current = (JavaToken)current.getNextToken().orElse(null)) != null) {
            newCode.append(current.getText());
            if (current != endToken) continue;
        }
        return newCode.toString();
    }

    public SwitchStatement handleSwitchStatement(Statement stmt) {
        SwitchStmt switchStmt = stmt.asSwitchStmt();
        SwitchStatement switchStatement = NodeBuilder.newSwitchStatement(stmt.toString());
        ((JavaLanguageFrontend)this.lang).getScopeManager().enterScope(switchStatement);
        switchStatement.setSelector((Expression)((JavaLanguageFrontend)this.lang).getExpressionHandler().handle(switchStmt.getSelector()));
        JavaToken start = null;
        JavaToken end = null;
        Optional tokenRange = switchStmt.getTokenRange();
        Optional tokenRangeSelector = switchStmt.getSelector().getTokenRange();
        if (tokenRange.isPresent() && tokenRangeSelector.isPresent()) {
            start = this.getNextTokenWith("{", ((TokenRange)tokenRangeSelector.get()).getEnd());
            end = this.getPreviousTokenWith("}", ((TokenRange)tokenRange.get()).getEnd());
        }
        CompoundStatement compoundStatement = NodeBuilder.newCompoundStatement(this.getCodeBetweenTokens(start, end));
        compoundStatement.setRegion(this.getRegionFromTokens(start, end));
        for (SwitchEntry sentry : switchStmt.getEntries()) {
            if (sentry.getLabels().isEmpty()) {
                compoundStatement.getStatements().add(this.handleCaseDefaultStatement(null, sentry));
            }
            for (com.github.javaparser.ast.expr.Expression caseExp : sentry.getLabels()) {
                compoundStatement.getStatements().add(this.handleCaseDefaultStatement(caseExp, sentry));
            }
            for (Statement subStmt : sentry.getStatements()) {
                compoundStatement.getStatements().add((de.fraunhofer.aisec.cpg.graph.Statement)this.handle(subStmt));
            }
        }
        switchStatement.setStatement(compoundStatement);
        ((JavaLanguageFrontend)this.lang).getScopeManager().leaveScope(switchStatement);
        return switchStatement;
    }

    private ExplicitConstructorInvocation handleExplicitConstructorInvocation(Statement stmt) {
        String containingClass;
        ExplicitConstructorInvocationStmt eciStatement = stmt.asExplicitConstructorInvocationStmt();
        try {
            containingClass = eciStatement.resolve().declaringType().getQualifiedName();
        }
        catch (NoClassDefFoundError | RuntimeException e) {
            containingClass = ((JavaLanguageFrontend)this.lang).recoverTypeFromUnsolvedException(e);
        }
        ExplicitConstructorInvocation node = NodeBuilder.newExplicitConstructorInvocation(containingClass, eciStatement.toString());
        List<Expression> arguments = eciStatement.getArguments().stream().map(((JavaLanguageFrontend)this.lang).getExpressionHandler()::handle).map(Expression.class::cast).collect(Collectors.toList());
        node.setArguments(arguments);
        return node;
    }

    private TryStatement handleTryStatement(Statement stmt) {
        TryStmt tryStmt = stmt.asTryStmt();
        TryStatement tryStatement = NodeBuilder.newTryStatement(stmt.toString());
        ((JavaLanguageFrontend)this.lang).getScopeManager().enterScope(tryStatement);
        List<de.fraunhofer.aisec.cpg.graph.Statement> resources = tryStmt.getResources().stream().map(((JavaLanguageFrontend)this.lang).getExpressionHandler()::handle).collect(Collectors.toList());
        CompoundStatement tryBlock = this.handleBlockStatement((Statement)tryStmt.getTryBlock());
        List<de.fraunhofer.aisec.cpg.graph.CatchClause> catchClauses = tryStmt.getCatchClauses().stream().map(this::handleCatchClause).collect(Collectors.toList());
        CompoundStatement finallyBlock = tryStmt.getFinallyBlock().map(this::handleBlockStatement).orElse(null);
        ((JavaLanguageFrontend)this.lang).getScopeManager().leaveScope(tryStatement);
        tryStatement.setResources(resources);
        tryStatement.setTryBlock(tryBlock);
        tryStatement.setFinallyBlock(finallyBlock);
        tryStatement.setCatchClauses(catchClauses);
        for (de.fraunhofer.aisec.cpg.graph.Statement r : resources) {
            if (!(r instanceof DeclarationStatement)) continue;
            for (Declaration d : ((DeclarationStatement)r).getDeclarations()) {
                if (!(d instanceof VariableDeclaration)) continue;
                ((JavaLanguageFrontend)this.lang).getScopeManager().addValueDeclaration((VariableDeclaration)d);
            }
        }
        return tryStatement;
    }

    private de.fraunhofer.aisec.cpg.graph.CatchClause handleCatchClause(CatchClause catchCls) {
        Type concreteType;
        de.fraunhofer.aisec.cpg.graph.CatchClause cClause = NodeBuilder.newCatchClause(catchCls.toString());
        ((JavaLanguageFrontend)this.lang).getScopeManager().enterScope(cClause);
        HashSet<Type> possibleTypes = new HashSet<Type>();
        if (catchCls.getParameter().getType() instanceof UnionType) {
            for (ReferenceType t : ((UnionType)catchCls.getParameter().getType()).getElements()) {
                possibleTypes.add(((JavaLanguageFrontend)this.lang).getTypeAsGoodAsPossible((com.github.javaparser.ast.type.Type)t));
            }
            concreteType = new Type("java.lang.Throwable", Type.Origin.GUESSED);
        } else {
            concreteType = ((JavaLanguageFrontend)this.lang).getTypeAsGoodAsPossible(catchCls.getParameter().getType());
            possibleTypes.add(concreteType);
        }
        VariableDeclaration parameter = NodeBuilder.newVariableDeclaration(catchCls.getParameter().getName().toString(), concreteType, catchCls.getParameter().toString());
        parameter.setPossibleSubTypes(possibleTypes);
        CompoundStatement body = this.handleBlockStatement((Statement)catchCls.getBody());
        cClause.setBody(body);
        cClause.setParameter(parameter);
        ((JavaLanguageFrontend)this.lang).getScopeManager().addValueDeclaration(parameter);
        ((JavaLanguageFrontend)this.lang).getScopeManager().leaveScope(cClause);
        return cClause;
    }
}

