/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.cpp;

import de.fraunhofer.aisec.cpg.frontends.Handler;
import de.fraunhofer.aisec.cpg.frontends.cpp.CXXLanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.BreakStatement;
import de.fraunhofer.aisec.cpg.graph.CaseStatement;
import de.fraunhofer.aisec.cpg.graph.CatchClause;
import de.fraunhofer.aisec.cpg.graph.CompoundStatement;
import de.fraunhofer.aisec.cpg.graph.ContinueStatement;
import de.fraunhofer.aisec.cpg.graph.Declaration;
import de.fraunhofer.aisec.cpg.graph.DeclarationStatement;
import de.fraunhofer.aisec.cpg.graph.DefaultStatement;
import de.fraunhofer.aisec.cpg.graph.DoStatement;
import de.fraunhofer.aisec.cpg.graph.EmptyStatement;
import de.fraunhofer.aisec.cpg.graph.Expression;
import de.fraunhofer.aisec.cpg.graph.ForEachStatement;
import de.fraunhofer.aisec.cpg.graph.ForStatement;
import de.fraunhofer.aisec.cpg.graph.GotoStatement;
import de.fraunhofer.aisec.cpg.graph.IfStatement;
import de.fraunhofer.aisec.cpg.graph.LabelStatement;
import de.fraunhofer.aisec.cpg.graph.Literal;
import de.fraunhofer.aisec.cpg.graph.NodeBuilder;
import de.fraunhofer.aisec.cpg.graph.Region;
import de.fraunhofer.aisec.cpg.graph.ReturnStatement;
import de.fraunhofer.aisec.cpg.graph.Statement;
import de.fraunhofer.aisec.cpg.graph.SwitchStatement;
import de.fraunhofer.aisec.cpg.graph.TryStatement;
import de.fraunhofer.aisec.cpg.graph.Type;
import de.fraunhofer.aisec.cpg.graph.VariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.WhileStatement;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ILabel;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCatchHandler;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTASMDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTBreakStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTCaseStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTCatchHandler;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTCompoundStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTContinueStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTDeclarationStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTDefaultStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTDoStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTExpressionStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTForStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTGotoStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTIfStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTLabelStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTNullStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTRangeBasedForStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTReturnStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTSwitchStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTTryBlockStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTWhileStatement;

class StatementHandler
extends Handler<Statement, IASTStatement, CXXLanguageFrontend> {
    StatementHandler(CXXLanguageFrontend lang) {
        super(Statement::new, lang);
        this.map.put(CPPASTCompoundStatement.class, ctx -> this.handleCompoundStatement((CPPASTCompoundStatement)ctx));
        this.map.put(CPPASTReturnStatement.class, ctx -> this.handleReturnStatement((CPPASTReturnStatement)ctx));
        this.map.put(CPPASTDeclarationStatement.class, ctx -> this.handleDeclarationStatement((CPPASTDeclarationStatement)ctx));
        this.map.put(CPPASTExpressionStatement.class, ctx -> this.handleExpressionStatement((CPPASTExpressionStatement)ctx));
        this.map.put(CPPASTIfStatement.class, ctx -> this.handleIfStatement((CPPASTIfStatement)ctx));
        this.map.put(CPPASTWhileStatement.class, ctx -> this.handleWhileStatement((CPPASTWhileStatement)ctx));
        this.map.put(CPPASTDoStatement.class, ctx -> this.handleDoStatement((CPPASTDoStatement)ctx));
        this.map.put(CPPASTForStatement.class, ctx -> this.handleForStatement((CPPASTForStatement)ctx));
        this.map.put(CPPASTRangeBasedForStatement.class, ctx -> this.handleForEachStatement((CPPASTRangeBasedForStatement)ctx));
        this.map.put(CPPASTContinueStatement.class, ctx -> this.handleContinueStatement((CPPASTContinueStatement)ctx));
        this.map.put(CPPASTBreakStatement.class, ctx -> this.handleBreakStatement((CPPASTBreakStatement)ctx));
        this.map.put(CPPASTLabelStatement.class, ctx -> this.handleLabelStatement((CPPASTLabelStatement)ctx));
        this.map.put(CPPASTSwitchStatement.class, ctx -> this.handleSwitchStatement((CPPASTSwitchStatement)ctx));
        this.map.put(CPPASTCaseStatement.class, ctx -> this.handleCaseStatement((CPPASTCaseStatement)ctx));
        this.map.put(CPPASTDefaultStatement.class, ctx -> this.handleDefaultStatement((CPPASTDefaultStatement)ctx));
        this.map.put(CPPASTNullStatement.class, ctx -> this.handleEmptyStatement((CPPASTNullStatement)ctx));
        this.map.put(CPPASTGotoStatement.class, ctx -> this.handleGotoStatement((CPPASTGotoStatement)ctx));
        this.map.put(CPPASTTryBlockStatement.class, ctx -> this.handleTryBlockStatement((CPPASTTryBlockStatement)ctx));
        this.map.put(CPPASTCatchHandler.class, ctx -> this.handleCatchHandler((ICPPASTCatchHandler)ctx));
    }

    private EmptyStatement handleEmptyStatement(CPPASTNullStatement emptyStmt) {
        return NodeBuilder.newEmptyStatement(emptyStmt.getRawSignature());
    }

    private TryStatement handleTryBlockStatement(CPPASTTryBlockStatement tryStmt) {
        TryStatement tryStatement = NodeBuilder.newTryStatement(tryStmt.toString());
        ((CXXLanguageFrontend)this.lang).getScopeManager().enterScope(tryStatement);
        CompoundStatement statement = (CompoundStatement)this.handle(tryStmt.getTryBody());
        List<CatchClause> catchClauses = Arrays.stream(tryStmt.getCatchHandlers()).map(this::handleCatchHandler).collect(Collectors.toList());
        tryStatement.setTryBlock(statement);
        tryStatement.setCatchClauses(catchClauses);
        ((CXXLanguageFrontend)this.lang).getScopeManager().leaveScope(tryStatement);
        return tryStatement;
    }

    private CatchClause handleCatchHandler(ICPPASTCatchHandler catchHandler) {
        CatchClause catchClause = NodeBuilder.newCatchClause(catchHandler.getRawSignature());
        ((CXXLanguageFrontend)this.lang).getScopeManager().enterScope(catchClause);
        Statement body = (Statement)((CXXLanguageFrontend)this.lang).getStatementHandler().handle(catchHandler.getCatchBody());
        Declaration decl = null;
        if (catchHandler.getDeclaration() != null) {
            decl = (Declaration)((CXXLanguageFrontend)this.lang).getDeclarationHandler().handle(catchHandler.getDeclaration());
        }
        catchClause.setBody((CompoundStatement)body);
        if (decl != null) {
            catchClause.setParameter((VariableDeclaration)decl);
        }
        ((CXXLanguageFrontend)this.lang).getScopeManager().leaveScope(catchClause);
        return catchClause;
    }

    private IfStatement handleIfStatement(CPPASTIfStatement ctx) {
        IfStatement statement = NodeBuilder.newIfStatement(ctx.getRawSignature());
        ((CXXLanguageFrontend)this.lang).getScopeManager().enterScope(statement);
        if (ctx.getInitializerStatement() != null) {
            statement.setInitializerStatement((Statement)this.handle(ctx.getInitializerStatement()));
        }
        if (ctx.getConditionDeclaration() != null) {
            statement.setConditionDeclaration((Declaration)((CXXLanguageFrontend)this.lang).getDeclarationHandler().handle(ctx.getConditionDeclaration()));
        }
        statement.setConstExpression(ctx.isConstexpr());
        if (ctx.getConditionExpression() != null) {
            statement.setCondition((Expression)((CXXLanguageFrontend)this.lang).getExpressionHandler().handle(ctx.getConditionExpression()));
        }
        statement.setThenStatement((Statement)this.handle(ctx.getThenClause()));
        if (ctx.getElseClause() != null) {
            statement.setElseStatement((Statement)this.handle(ctx.getElseClause()));
        }
        ((CXXLanguageFrontend)this.lang).getScopeManager().leaveScope(statement);
        return statement;
    }

    private LabelStatement handleLabelStatement(CPPASTLabelStatement ctx) {
        LabelStatement statement = NodeBuilder.newLabelStatement(ctx.getRawSignature());
        statement.setSubStatement((Statement)this.handle(ctx.getNestedStatement()));
        statement.setLabel(ctx.getName().toString());
        return statement;
    }

    private GotoStatement handleGotoStatement(CPPASTGotoStatement ctx) {
        GotoStatement statement = NodeBuilder.newGotoStatement(ctx.getRawSignature());
        BiConsumer<Object, Object> assigneTargetLabel = (from, to) -> statement.setTargetLabel((LabelStatement)to);
        IBinding b = null;
        try {
            b = ctx.getName().resolveBinding();
            if (b instanceof ILabel) {
                ILabel label = (ILabel)b;
                label.getLabelStatement();
                ((CXXLanguageFrontend)this.lang).registerObjectListener(label.getLabelStatement(), assigneTargetLabel);
            }
        }
        catch (Exception e) {
            ((CXXLanguageFrontend)this.lang).registerPredicateListener((from, to) -> to instanceof LabelStatement && ((LabelStatement)to).getLabel().equals(statement.getLabelName()), assigneTargetLabel);
        }
        return statement;
    }

    private WhileStatement handleWhileStatement(CPPASTWhileStatement ctx) {
        WhileStatement statement = NodeBuilder.newWhileStatement(ctx.getRawSignature());
        ((CXXLanguageFrontend)this.lang).getScopeManager().enterScope(statement);
        if (ctx.getConditionDeclaration() != null) {
            statement.setConditionDeclaration((Declaration)((CXXLanguageFrontend)this.lang).getDeclarationHandler().handle(ctx.getConditionDeclaration()));
        }
        if (ctx.getCondition() != null) {
            statement.setCondition((Expression)((CXXLanguageFrontend)this.lang).getExpressionHandler().handle(ctx.getCondition()));
        }
        statement.setStatement((Statement)this.handle(ctx.getBody()));
        ((CXXLanguageFrontend)this.lang).getScopeManager().leaveScope(statement);
        return statement;
    }

    private DoStatement handleDoStatement(CPPASTDoStatement ctx) {
        DoStatement statement = NodeBuilder.newDoStatement(ctx.getRawSignature());
        ((CXXLanguageFrontend)this.lang).getScopeManager().enterScope(statement);
        statement.setCondition((Expression)((CXXLanguageFrontend)this.lang).getExpressionHandler().handle(ctx.getCondition()));
        statement.setStatement((Statement)this.handle(ctx.getBody()));
        ((CXXLanguageFrontend)this.lang).getScopeManager().leaveScope(statement);
        return statement;
    }

    private ForStatement handleForStatement(CPPASTForStatement ctx) {
        ForStatement statement = NodeBuilder.newForStatement(ctx.getRawSignature());
        ((CXXLanguageFrontend)this.lang).getScopeManager().enterScope(statement);
        statement.setInitializerStatement((Statement)this.handle(ctx.getInitializerStatement()));
        if (ctx.getConditionDeclaration() != null) {
            statement.setConditionDeclaration((Declaration)((CXXLanguageFrontend)this.lang).getDeclarationHandler().handle(ctx.getConditionDeclaration()));
        }
        if (ctx.getConditionExpression() != null) {
            statement.setCondition((Expression)((CXXLanguageFrontend)this.lang).getExpressionHandler().handle(ctx.getConditionExpression()));
        }
        if (statement.getConditionDeclaration() == null && statement.getCondition() == null) {
            Literal<Boolean> literal = NodeBuilder.newLiteral(true, new Type("bool"), "true");
            literal.setRegion(new Region());
            statement.setCondition(literal);
        }
        if (ctx.getIterationExpression() != null) {
            statement.setIterationExpression((Expression)((CXXLanguageFrontend)this.lang).getExpressionHandler().handle(ctx.getIterationExpression()));
        }
        statement.setStatement((Statement)this.handle(ctx.getBody()));
        ((CXXLanguageFrontend)this.lang).getScopeManager().leaveScope(statement);
        return statement;
    }

    private ForEachStatement handleForEachStatement(CPPASTRangeBasedForStatement ctx) {
        ForEachStatement statement = NodeBuilder.newForEachStatement(ctx.getRawSignature());
        ((CXXLanguageFrontend)this.lang).getScopeManager().enterScope(statement);
        Declaration var = (Declaration)((CXXLanguageFrontend)this.lang).getDeclarationHandler().handle(ctx.getDeclaration());
        Statement iterable = (Statement)((CXXLanguageFrontend)this.lang).getExpressionHandler().handle(ctx.getInitializerClause());
        statement.setVariable(var);
        statement.setIterable(iterable);
        statement.setStatement((Statement)this.handle(ctx.getBody()));
        ((CXXLanguageFrontend)this.lang).getScopeManager().leaveScope(statement);
        return statement;
    }

    private BreakStatement handleBreakStatement(CPPASTBreakStatement ctx) {
        return NodeBuilder.newBreakStatement(ctx.getRawSignature());
    }

    private ContinueStatement handleContinueStatement(CPPASTContinueStatement ctx) {
        return NodeBuilder.newContinueStatement(ctx.getRawSignature());
    }

    private Expression handleExpressionStatement(CPPASTExpressionStatement ctx) {
        return (Expression)((CXXLanguageFrontend)this.lang).getExpressionHandler().handle(ctx.getExpression());
    }

    private DeclarationStatement handleDeclarationStatement(CPPASTDeclarationStatement ctx) {
        if (ctx.getDeclaration() instanceof CPPASTASMDeclaration) {
            return NodeBuilder.newASMDeclarationStatement(ctx.getRawSignature());
        }
        DeclarationStatement declarationStatement = NodeBuilder.newDeclarationStatement(ctx.getRawSignature());
        declarationStatement.setDeclarations((List)((CXXLanguageFrontend)this.lang).getDeclarationListHandler().handle(ctx.getDeclaration()));
        return declarationStatement;
    }

    private ReturnStatement handleReturnStatement(CPPASTReturnStatement ctx) {
        ReturnStatement returnStatement = NodeBuilder.newReturnStatement(ctx.getRawSignature());
        if (ctx.getReturnValue() != null) {
            returnStatement.setReturnValue((Expression)((CXXLanguageFrontend)this.lang).getExpressionHandler().handle(ctx.getReturnValue()));
        }
        return returnStatement;
    }

    private CompoundStatement handleCompoundStatement(CPPASTCompoundStatement ctx) {
        CompoundStatement compoundStatement = NodeBuilder.newCompoundStatement(ctx.getRawSignature());
        ((CXXLanguageFrontend)this.lang).getScopeManager().enterScope(compoundStatement);
        for (IASTStatement statement : ctx.getStatements()) {
            compoundStatement.getStatements().add((Statement)this.handle(statement));
        }
        ((CXXLanguageFrontend)this.lang).getScopeManager().leaveScope(compoundStatement);
        return compoundStatement;
    }

    private SwitchStatement handleSwitchStatement(CPPASTSwitchStatement ctx) {
        SwitchStatement switchStatement = NodeBuilder.newSwitchStatement(ctx.getRawSignature());
        ((CXXLanguageFrontend)this.lang).getScopeManager().enterScope(switchStatement);
        if (ctx.getInitializerStatement() != null) {
            switchStatement.setInitializerStatement((Statement)this.handle(ctx.getInitializerStatement()));
        }
        if (ctx.getControllerDeclaration() != null) {
            switchStatement.setSelectorDeclaration((Declaration)((CXXLanguageFrontend)this.lang).getDeclarationHandler().handle(ctx.getControllerDeclaration()));
        }
        if (ctx.getControllerExpression() != null) {
            switchStatement.setSelector((Expression)((CXXLanguageFrontend)this.lang).getExpressionHandler().handle(ctx.getControllerExpression()));
        }
        switchStatement.setStatement((Statement)this.handle(ctx.getBody()));
        ((CXXLanguageFrontend)this.lang).getScopeManager().leaveScope(switchStatement);
        return switchStatement;
    }

    private CaseStatement handleCaseStatement(CPPASTCaseStatement ctx) {
        CaseStatement caseStatement = NodeBuilder.newCaseStatement(ctx.getRawSignature());
        caseStatement.setCaseExpression((Expression)((CXXLanguageFrontend)this.lang).getExpressionHandler().handle(ctx.getExpression()));
        return caseStatement;
    }

    private DefaultStatement handleDefaultStatement(CPPASTDefaultStatement ctx) {
        return NodeBuilder.newDefaultStatement(ctx.getRawSignature());
    }
}

