/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.cpp;

import de.fraunhofer.aisec.cpg.frontends.Handler;
import de.fraunhofer.aisec.cpg.frontends.cpp.CXXLanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.ConstructorDeclaration;
import de.fraunhofer.aisec.cpg.graph.Declaration;
import de.fraunhofer.aisec.cpg.graph.Expression;
import de.fraunhofer.aisec.cpg.graph.FieldDeclaration;
import de.fraunhofer.aisec.cpg.graph.FunctionDeclaration;
import de.fraunhofer.aisec.cpg.graph.MethodDeclaration;
import de.fraunhofer.aisec.cpg.graph.NodeBuilder;
import de.fraunhofer.aisec.cpg.graph.ParamVariableDeclaration;
import de.fraunhofer.aisec.cpg.graph.RecordDeclaration;
import de.fraunhofer.aisec.cpg.graph.Region;
import de.fraunhofer.aisec.cpg.graph.Type;
import de.fraunhofer.aisec.cpg.graph.ValueDeclaration;
import de.fraunhofer.aisec.cpg.graph.VariableDeclaration;
import de.fraunhofer.aisec.cpg.passes.scopes.RecordScope;
import de.fraunhofer.aisec.cpg.passes.scopes.Scope;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTNameOwner;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTArrayDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFunctionDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTVisibilityLabel;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;

class DeclaratorHandler
extends Handler<Declaration, IASTNameOwner, CXXLanguageFrontend> {
    DeclaratorHandler(CXXLanguageFrontend lang) {
        super(Declaration::new, lang);
        this.map.put(CPPASTDeclarator.class, ctx -> this.handleDeclarator((CPPASTDeclarator)ctx));
        this.map.put(CPPASTArrayDeclarator.class, ctx -> this.handleDeclarator((CPPASTDeclarator)ctx));
        this.map.put(CPPASTFunctionDeclarator.class, ctx -> this.handleFunctionDeclarator((CPPASTFunctionDeclarator)ctx));
        this.map.put(CPPASTCompositeTypeSpecifier.class, ctx -> this.handleCompositeTypeSpecifier((CPPASTCompositeTypeSpecifier)ctx));
    }

    private int getEvaluatedIntegerValue(IASTExpression exp) {
        try {
            Method method = exp.getClass().getMethod("getEvaluation", new Class[0]);
            ICPPEvaluation evaluation = (ICPPEvaluation)method.invoke((Object)exp, new Object[0]);
            return evaluation.getValue().numberValue().intValue();
        }
        catch (Exception e) {
            return -1;
        }
    }

    private VariableDeclaration handleDeclarator(CPPASTDeclarator ctx) {
        VariableDeclaration declaration = NodeBuilder.newVariableDeclaration(ctx.getName().toString(), Type.getUnknown(), ctx.getRawSignature());
        IASTInitializer init = ctx.getInitializer();
        if (init != null) {
            declaration.setInitializer((Expression)((CXXLanguageFrontend)this.lang).getInitializerHandler().handle(init));
        }
        Object typeAdjustment = List.of(ctx.getPointerOperators()).stream().map(IASTNode::getRawSignature).collect(Collectors.joining());
        if (ctx instanceof CPPASTArrayDeclarator) {
            typeAdjustment = (String)typeAdjustment + "[]";
        }
        declaration.getType().setTypeAdjustment((String)typeAdjustment);
        ((CXXLanguageFrontend)this.lang).getScopeManager().addValueDeclaration(declaration);
        return declaration;
    }

    private ValueDeclaration handleFunctionDeclarator(CPPASTFunctionDeclarator ctx) {
        FunctionDeclaration declaration;
        if (ctx.getName().toString().isEmpty()) {
            return this.handleFunctionPointer(ctx);
        }
        String name = ctx.getName().toString();
        if (name.contains("::")) {
            String[] rr = name.split("::");
            ICPPASTParameterDeclaration[] recordName = rr[0];
            String methodName = rr[1];
            declaration = NodeBuilder.newMethodDeclaration(methodName, ctx.getRawSignature(), false, ((CXXLanguageFrontend)this.lang).getRecordForName((String)recordName).orElse(null));
        } else {
            declaration = NodeBuilder.newFunctionDeclaration(name, ctx.getRawSignature());
        }
        ((CXXLanguageFrontend)this.lang).getScopeManager().enterScope(declaration);
        int i = 0;
        for (ICPPASTParameterDeclaration param : ctx.getParameters()) {
            ParamVariableDeclaration arg = (ParamVariableDeclaration)((CXXLanguageFrontend)this.lang).getParameterDeclarationHandler().handle(param);
            IBinding binding = ctx.getParameters()[i].getDeclarator().getName().resolveBinding();
            if (binding != null) {
                ((CXXLanguageFrontend)this.lang).cacheDeclaration(binding, arg);
            }
            arg.setArgumentIndex(i);
            ((CXXLanguageFrontend)this.lang).getScopeManager().addValueDeclaration(arg);
            ++i;
        }
        if (ctx.takesVarArgs()) {
            ParamVariableDeclaration varargs = NodeBuilder.newMethodParameterIn("va_args", Type.getUnknown(), true, "");
            varargs.setArgumentIndex(i);
            ((CXXLanguageFrontend)this.lang).getScopeManager().addValueDeclaration(varargs);
        }
        declaration.getType().setTypeAdjustment(List.of(ctx.getPointerOperators()).stream().map(IASTNode::getRawSignature).collect(Collectors.joining()));
        ((CXXLanguageFrontend)this.lang).getScopeManager().leaveScope(declaration);
        return declaration;
    }

    private ValueDeclaration handleFunctionPointer(CPPASTFunctionDeclarator ctx) {
        ValueDeclaration result;
        Expression initializer = ctx.getInitializer() == null ? null : (Expression)((CXXLanguageFrontend)this.lang).getInitializerHandler().handle(ctx.getInitializer());
        FunctionDeclaration currFunction = ((CXXLanguageFrontend)this.lang).getScopeManager().getCurrentFunction();
        if (currFunction != null) {
            result = NodeBuilder.newVariableDeclaration(ctx.getNestedDeclarator().getName().toString(), Type.getUnknown(), ctx.getRawSignature());
            ((VariableDeclaration)result).setInitializer(initializer);
            result.setRegion(((CXXLanguageFrontend)this.lang).getRegionFromRawNode(ctx));
            result.getType().setFunctionPtr(true);
            result.refreshType();
        } else {
            RecordScope recordScope = (RecordScope)((CXXLanguageFrontend)this.lang).getScopeManager().getFirstScopeThat(RecordScope.class::isInstance);
            if (recordScope != null) {
                String code = ctx.getRawSignature();
                Pattern namePattern = Pattern.compile("\\((\\*|.+\\*)(?<name>[^)]*)");
                Matcher matcher = namePattern.matcher(code);
                String name = "";
                if (matcher.find()) {
                    name = matcher.group("name").strip();
                }
                result = NodeBuilder.newFieldDeclaration(name, Type.getUnknown(), Collections.emptyList(), code, ((CXXLanguageFrontend)this.lang).getRegionFromRawNode(ctx), initializer);
                result.setRegion(((CXXLanguageFrontend)this.lang).getRegionFromRawNode(ctx));
                result.getType().setFunctionPtr(true);
                result.refreshType();
            } else {
                log.error("Function pointer declaration that is neither in a function nor in a record. This should not happen!");
                return null;
            }
        }
        return result;
    }

    private RecordDeclaration handleCompositeTypeSpecifier(CPPASTCompositeTypeSpecifier ctx) {
        String kind;
        switch (ctx.getKey()) {
            default: {
                kind = "struct";
                break;
            }
            case 2: {
                kind = "union";
                break;
            }
            case 3: {
                kind = "class";
            }
        }
        RecordDeclaration recordDeclaration = NodeBuilder.newRecordDeclaration(ctx.getName().toString(), new ArrayList<Type>(), kind, ctx.getRawSignature());
        ((CXXLanguageFrontend)this.lang).addRecord(recordDeclaration);
        ((CXXLanguageFrontend)this.lang).getScopeManager().enterScope(recordDeclaration);
        if (kind.equals("class")) {
            FieldDeclaration fieldDeclaration = NodeBuilder.newFieldDeclaration("this", new Type(ctx.getName().toString()), new ArrayList<String>(), "this", new Region(-1, -1, -1, -1), null);
            recordDeclaration.getFields().add(fieldDeclaration);
            ((CXXLanguageFrontend)this.lang).getScopeManager().addValueDeclaration(fieldDeclaration);
        }
        for (IASTDeclaration member : ctx.getMembers()) {
            if (member instanceof CPPASTVisibilityLabel) continue;
            Declaration declaration = (Declaration)((CXXLanguageFrontend)this.lang).getDeclarationHandler().handle(member);
            Scope declarationScope = ((CXXLanguageFrontend)this.lang).getScopeManager().getScopeOfStatment(declaration);
            if (declaration instanceof FunctionDeclaration) {
                MethodDeclaration method = MethodDeclaration.from((FunctionDeclaration)declaration, recordDeclaration);
                declaration.disconnectFromGraph();
                if (declaration.getName().equals(recordDeclaration.getName())) {
                    ConstructorDeclaration constructor = ConstructorDeclaration.from(method);
                    if (declarationScope != null) {
                        declarationScope.setAstNode(constructor);
                    }
                    recordDeclaration.getConstructors().add(constructor);
                } else {
                    recordDeclaration.getMethods().add(method);
                }
                if (declarationScope == null) continue;
                declarationScope.setAstNode(method);
                continue;
            }
            if (declaration instanceof VariableDeclaration) {
                recordDeclaration.getFields().add(FieldDeclaration.from((VariableDeclaration)declaration));
                continue;
            }
            if (!(declaration instanceof FieldDeclaration)) continue;
            recordDeclaration.getFields().add((FieldDeclaration)declaration);
        }
        if (recordDeclaration.getConstructors().isEmpty()) {
            ConstructorDeclaration constructorDeclaration = NodeBuilder.newConstructorDeclaration(recordDeclaration.getName(), recordDeclaration.getName(), recordDeclaration);
            recordDeclaration.getConstructors().add(constructorDeclaration);
            ((CXXLanguageFrontend)this.lang).getScopeManager().addValueDeclaration(constructorDeclaration);
        }
        ((CXXLanguageFrontend)this.lang).getScopeManager().leaveScope(recordDeclaration);
        return recordDeclaration;
    }
}

