/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.aisec.cpg.frontends.cpp;

import de.fraunhofer.aisec.cpg.frontends.Handler;
import de.fraunhofer.aisec.cpg.frontends.cpp.CXXLanguageFrontend;
import de.fraunhofer.aisec.cpg.graph.Declaration;
import de.fraunhofer.aisec.cpg.graph.Type;
import de.fraunhofer.aisec.cpg.graph.ValueDeclaration;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTSimpleDeclaration;

class DeclarationListHandler
extends Handler<List<Declaration>, IASTDeclaration, CXXLanguageFrontend> {
    DeclarationListHandler(CXXLanguageFrontend lang) {
        super(ArrayList::new, lang);
        this.map.put(CPPASTSimpleDeclaration.class, ctx -> this.handleSimpleDeclaration((CPPASTSimpleDeclaration)ctx));
    }

    private List<Declaration> handleSimpleDeclaration(CPPASTSimpleDeclaration ctx) {
        ArrayList<Declaration> list = new ArrayList<Declaration>();
        for (IASTDeclarator declarator : ctx.getDeclarators()) {
            ValueDeclaration declaration = (ValueDeclaration)((CXXLanguageFrontend)this.lang).getDeclaratorHandler().handle(declarator);
            String typeAdjustment = declaration.getType().getTypeAdjustment();
            String typeString = ctx.getDeclSpecifier().toString();
            declaration.setType(Type.createFrom(typeString));
            declaration.getType().setTypeAdjustment(typeAdjustment);
            ((CXXLanguageFrontend)this.lang).cacheDeclaration(declarator.getName().resolveBinding(), declaration);
            list.add(declaration);
        }
        return list;
    }
}

